/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.fit;

import fit.ColumnFixture;
import fit.Parse;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class OurColumnFixture
extends ColumnFixture {
    public static final String NO_ESCAPE_PREFIX = "@@NO_ESCAPE@@";

    public void execute() {
        this.calculateDerivedValues();
    }

    protected void calculateDerivedValues() {
    }

    protected Integer parseIntArg(int index) {
        return this.parseIntArg(index, null);
    }

    protected Integer parseIntArg(int index, Integer defaultValue) {
        Integer result = defaultValue;
        try {
            String argValue = this.getStringArg(index);
            if (argValue != null && !"".equals(argValue)) {
                result = Integer.valueOf(argValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    protected String getStringArg(int index) {
        return this.getStringArg(index, null);
    }

    protected String getStringArg(int index, String defaultValue) {
        String result = defaultValue;
        String[] arg = this.getArgs();
        if (arg != null && arg.length > index) {
            result = arg[index];
        }
        return result;
    }

    public String timeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getTimeStampPattern());
        return dateFormat.format(Calendar.getInstance().getTime());
    }

    protected String getTimeStampPattern() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public void wrong(Parse cell, String actual) {
        if (actual.startsWith(NO_ESCAPE_PREFIX)) {
            this.wrong(cell);
            String actualNoPrefix = actual.substring(NO_ESCAPE_PREFIX.length());
            cell.addToBody(OurColumnFixture.label((String)"expected") + "<hr>" + actualNoPrefix + OurColumnFixture.label((String)"actual"));
        } else {
            super.wrong(cell, actual);
        }
    }
}

