/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.fit;

import java.util.Map;
import nl.hsac.fitnesse.fixture.fit.MapColumnFixture;
import nl.hsac.fitnesse.fixture.util.FtpFileUtil;
import org.apache.commons.lang3.StringUtils;

public class ReadFileFromFtpServerFixture
extends MapColumnFixture {
    public static final String DEFAULT_NR_OF_LINES_TO_BE_READ = "10";
    private static final String HOST_NAME_KEY = "host";
    private static final String PORT_NUMBER_KEY = "port";
    private static final String USER_NAME_KEY = "userName";
    private static final String PASSWORD_KEY = "password";
    private static final String FILE_PATH_KEY = "file";
    private static final String LINES_COUNT_KEY = "nrOfLines";
    private String fileAsString = null;
    private Integer fileSize = null;
    private String errorMessage = null;

    @Override
    public void execute() {
        Map<String, Object> currentRow = this.getCurrentRowValues();
        String hostName = (String)currentRow.get(HOST_NAME_KEY);
        String userName = (String)currentRow.get(USER_NAME_KEY);
        String password = (String)currentRow.get(PASSWORD_KEY);
        String filePath = (String)currentRow.get(FILE_PATH_KEY);
        Integer port = null;
        this.errorMessage = "";
        if (currentRow.get(PORT_NUMBER_KEY) != null) {
            port = Integer.valueOf((String)currentRow.get(PORT_NUMBER_KEY));
        }
        Integer nrOfLines = Integer.valueOf((String)this.get(LINES_COUNT_KEY));
        this.fileAsString = "";
        try {
            this.fileAsString = FtpFileUtil.loadFileFromFTPServer(hostName, port, userName, password, filePath, nrOfLines);
        }
        catch (Exception ex) {
            this.handleException(ex, "load file from FTP server");
        }
        this.fileSize = null;
        try {
            this.fileSize = FtpFileUtil.getFileSizeOnFTPServer(hostName, port, userName, password, filePath);
        }
        catch (Exception ex) {
            this.handleException(ex, "get file size");
        }
    }

    @Override
    protected void setDefaults(Map<String, Object> values) {
        super.setDefaults(values);
        values.put(LINES_COUNT_KEY, DEFAULT_NR_OF_LINES_TO_BE_READ);
    }

    public String result() {
        String result = null;
        if (this.fileAsString != null) {
            result = this.fileAsString.replaceAll("[\r\n]", "");
        }
        return result;
    }

    public String error() {
        String errorWithNoNewlines = "";
        if (this.errorMessage != null) {
            errorWithNoNewlines = this.errorMessage.replaceAll("[\r\n]", "");
        }
        return errorWithNoNewlines;
    }

    public Integer fileSize() {
        return this.fileSize;
    }

    private void handleException(Exception ex, String action) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.errorMessage)) {
            sb.append(this.errorMessage);
            sb.append(" ");
        }
        sb.append(String.format("Failed %s. Cause: %s", action, ex.getMessage()));
        this.errorMessage = sb.toString();
    }
}

