/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.fit;

import java.util.Map;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.fit.MapColumnFixture;

public abstract class ServiceAndCheckMapColumnFixture<Response, CheckResponse>
extends MapColumnFixture {
    private final Class<? extends Response> responseClass;
    private final Class<? extends CheckResponse> checkResponseClass;
    private final Environment env = Environment.getInstance();
    private Response response;
    private CheckResponse checkResponse;
    private boolean checkCalled;
    private int tryCount;
    private int waitTime;
    private int maxTries;
    private long responseTime;
    private long checkTime;

    public ServiceAndCheckMapColumnFixture(Class<? extends Response> aResponseClass, Class<? extends CheckResponse> aCheckResponseClass) {
        this.checkResponseClass = aCheckResponseClass;
        this.responseClass = aResponseClass;
    }

    public Class<? extends Response> getResponseClass() {
        return this.responseClass;
    }

    public Class<? extends CheckResponse> getCheckResponseClass() {
        return this.checkResponseClass;
    }

    @Override
    public void execute() {
        super.execute();
        long startTime = this.currentTimeMillis();
        try {
            this.setRawResponse(this.callService());
        }
        finally {
            this.responseTime = this.currentTimeMillis() - startTime;
        }
    }

    protected abstract Response callService();

    @Override
    public void reset() {
        super.reset();
        this.response = this.getEnvironment().createInstance(this.responseClass);
        this.checkResponse = this.getEnvironment().createInstance(this.checkResponseClass);
        this.checkCalled = false;
        this.tryCount = 0;
        this.responseTime = 0L;
        this.checkTime = 0L;
    }

    public Response getRawResponse() {
        return this.response;
    }

    public void setRawResponse(Response aResponse) {
        this.response = aResponse;
    }

    public CheckResponse getRawCheckResponse() {
        if (!this.checkCalled) {
            this.setupMaxTries();
            this.setupWaitTime();
            this.addResultsToValuesForCheck(this.getCurrentRowValues());
            long startTime = this.currentTimeMillis();
            try {
                this.executeCheckWithRetry();
            }
            finally {
                this.checkTime = this.currentTimeMillis() - startTime;
            }
        }
        return this.checkResponse;
    }

    protected void setupMaxTries() {
        this.maxTries = this.parseIntArg(0, 1);
    }

    protected void setupWaitTime() {
        this.waitTime = this.parseIntArg(1, 0);
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public void setRawCheckResponse(CheckResponse aCheckResponse) {
        this.checkCalled = true;
        this.checkResponse = aCheckResponse;
    }

    protected void addResultsToValuesForCheck(Map<String, Object> values) {
    }

    protected void executeCheckWithRetry() {
        ++this.tryCount;
        this.executeCheckCall();
        if (this.tryCount < this.maxTries && this.isRetryDesirable()) {
            this.executeCheckWithRetry();
        } else {
            this.checkExecutionCompleted();
        }
    }

    protected void checkExecutionCompleted() {
    }

    protected boolean isRetryDesirable() {
        return false;
    }

    protected void executeCheckCall() {
        this.waitForChangeToComplete();
        this.setRawCheckResponse(this.callCheckService());
    }

    protected void waitForChangeToComplete() {
        if (this.waitTime > 0) {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Waiting for change to complete interrupted", e);
            }
        }
    }

    protected abstract CheckResponse callCheckService();

    protected Environment getEnvironment() {
        return this.env;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int aWaitTime) {
        this.waitTime = aWaitTime;
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public void setMaxTries(int aMaxTries) {
        this.maxTries = aMaxTries;
    }

    public int tryCount() {
        return this.tryCount;
    }

    public long responseTime() {
        return this.responseTime;
    }

    public long checkTime() {
        return this.checkTime;
    }
}

