/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.fit;

import java.util.Collections;
import java.util.Map;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.fit.TemplateBasedMapColumnFixture;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;

public abstract class SoapCallMapColumnFixture<Response extends XmlHttpResponse>
extends TemplateBasedMapColumnFixture<Response, XmlHttpResponse> {
    protected static void registerNs(String prefix, String url) {
        Environment.getInstance().registerNamespace(prefix, url);
    }

    public SoapCallMapColumnFixture(Class<? extends Response> aResponseClass) {
        super(aResponseClass, XmlHttpResponse.class);
    }

    @Override
    protected void executeCheckCall() {
        try {
            super.executeCheckCall();
        }
        catch (RuntimeException e) {
            XmlHttpResponse checkResponse = (XmlHttpResponse)this.getEnvironment().createInstance(this.getCheckResponseClass());
            checkResponse.setResponse("Unable to perform check. Error: " + e.getMessage());
            this.setRawCheckResponse(checkResponse);
        }
    }

    @Override
    protected XmlHttpResponse callCheckService() {
        return (XmlHttpResponse)this.getEnvironment().createInstance(this.getCheckResponseClass());
    }

    protected Response callServiceImpl(String urlSymbolKey, String soapAction) {
        String url = SoapCallMapColumnFixture.getSymbol((String)urlSymbolKey).toString();
        XmlHttpResponse response = (XmlHttpResponse)this.getEnvironment().createInstance(this.getResponseClass());
        this.callSoapService(url, this.getTemplateName(), soapAction, response);
        return (Response)response;
    }

    protected XmlHttpResponse callCheckServiceImpl(String urlSymbolKey, String soapAction) {
        String url = SoapCallMapColumnFixture.getSymbol((String)urlSymbolKey).toString();
        XmlHttpResponse response = (XmlHttpResponse)this.getEnvironment().createInstance(this.getCheckResponseClass());
        this.callSoapService(url, this.getCheckTemplateName(), soapAction, response);
        return response;
    }

    protected void callSoapService(String url, String templateName, String soapAction, XmlHttpResponse response) {
        Map<String, Object> headers = soapAction != null ? Collections.singletonMap("SOAPAction", soapAction) : null;
        this.getEnvironment().callService(url, templateName, this.getCurrentRowValues(), response, headers);
    }

    public String request() {
        return this.xmlAsHtml(this.getRequest());
    }

    public String response() {
        return this.xmlAsHtml(this.getResponse());
    }

    public String getRequest() {
        return ((XmlHttpResponse)this.getRawResponse()).getRequest();
    }

    public String getResponse() {
        return ((XmlHttpResponse)this.getRawResponse()).getResponse();
    }

    public String checkResponse() {
        return this.xmlAsHtml(((XmlHttpResponse)this.getRawCheckResponse()).getResponse());
    }

    public String checkRequest() {
        return this.xmlAsHtml(((XmlHttpResponse)this.getRawCheckResponse()).getRequest());
    }

    protected String xmlAsHtml(String xml) {
        return this.getEnvironment().getHtmlForXml(xml);
    }
}

