/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.leanapps;

import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.leanapps.LalResponse;

public class LalPolicyXPaths {
    private static final String NAMESPACE_PREFIX = "ns:";

    public static void registerNamespace() {
        Environment.getInstance().registerNamespace("lal", "http://www.leanapps.com/businesslayer/xml");
    }

    public static String getXsiTypeValue(String type) {
        return NAMESPACE_PREFIX + type;
    }

    public static String partyInitials(String partyNr) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:initials";
    }

    public static String partyFirstName(String partyNr) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:firstName";
    }

    public static String partyMiddleName(String partyNr) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:middleName";
    }

    public static String partyLastName(String partyNr) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:lastName";
    }

    public static String partyDateOfBirth(String partyNr) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:dateOfBirth";
    }

    public static String partyGender(String partyNr) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:gender";
    }

    public static String partyBSN(String partyNr) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:socialSecurityNr";
    }

    public static String partyStreet(String partyNr) {
        return LalPolicyXPaths.getPartyStreet(partyNr) + "lal:streetName";
    }

    public static String partyStreetNr(String partyNr) {
        return LalPolicyXPaths.getPartyStreet(partyNr) + "lal:streetNumber";
    }

    public static String partyZipCode(String partyNr) {
        return LalPolicyXPaths.getPartyAddress(partyNr) + "lal:zipCode";
    }

    public static String partyCity(String partyNr) {
        return LalPolicyXPaths.getPartyAddress(partyNr) + "lal:city";
    }

    public static String partyCountryCode(String partyNr) {
        return LalPolicyXPaths.getPartyAddress(partyNr) + "lal:countryCode";
    }

    public static String partyPhone(String partyNr) {
        return LalPolicyXPaths.getPartyAddress(partyNr) + "lal:phone";
    }

    public static String partyEmail(String partyNr) {
        return LalPolicyXPaths.getPartyAddress(partyNr) + "lal:email";
    }

    public static String partyAccountType(String partyNr, String accountId) {
        return LalPolicyXPaths.getAccount(partyNr, accountId) + "@xsi:type";
    }

    public static String partyAccountNumber(String partyNr, String accountId) {
        return LalPolicyXPaths.getAccount(partyNr, accountId) + "lal:accountNumber";
    }

    public static String partyAccountCity(String partyNr, String accountId) {
        return LalPolicyXPaths.getAccount(partyNr, accountId) + "lal:city";
    }

    public static String partyBlockCorrespondence(String partyNr) {
        String partySelect = LalPolicyXPaths.getPartySelect(partyNr);
        return partySelect + "lal:attributes/lal:attribute[lal:specificationKey='BLOCK_CORRESPONDENCE']/lal:boolean";
    }

    public static String premium() {
        return LalPolicyXPaths.getInsuranceSelect() + "lal:premiums/lal:premium/";
    }

    public static String insuranceAccount() {
        return LalPolicyXPaths.getInsuranceSelect() + "lal:insuranceAccount/";
    }

    public static String equalPremium() {
        return LalPolicyXPaths.getInsuranceSelect() + "lal:premiums/lal:premium[@xsi:type='ns:EqualPremium']/";
    }

    public static String singlePremium() {
        return LalPolicyXPaths.getInsuranceSelect() + "lal:singlePremiums/lal:singlePremium/";
    }

    public static String yslKind() {
        return LalPolicyXPaths.getInsuranceSelect() + "/lal:attributes/lal:attribute[lal:specificationKey/text() = 'YSL_KIND']/lal:boolean";
    }

    public static String insuredAmount() {
        return LalPolicyXPaths.deathCoverageSelect() + "/lal:amount";
    }

    public static String getDeathCoverageSubselect() {
        return "/lal:deathCoverages/lal:deathCoverage";
    }

    public static String deathCoverageSelect() {
        return LalPolicyXPaths.getInsuranceSelect() + LalPolicyXPaths.getDeathCoverageSubselect();
    }

    public static String sumFinancialBookingForSinglePayment() {
        return "sum(" + LalPolicyXPaths.getFinancialBooking() + "[lal:transactionCategory/text()='SINGLE_PAYMENT' and lal:state/text() = 'RECEIVABLE_STATE_CREATED']/lal:amount)";
    }

    public static String singlePayment() {
        return LalPolicyXPaths.getSinglePaymentSelect() + "/lal:amount";
    }

    public static String intermediary(LalResponse lalResponse) {
        return LalPolicyXPaths.partyInRole(lalResponse, "InsuranceIntermediary");
    }

    public static String partyInRole(LalResponse lalResponse, String role) {
        String roleType = lalResponse.getXsiTypeValue(role);
        return LalPolicyXPaths.getInsuranceSelect() + "/lal:roles/lal:role[@xsi:type='" + roleType + "']/lal:partyId/lal:key";
    }

    public static String productionCompany() {
        String roleType = LalPolicyXPaths.getXsiTypeValue("InsuranceInstitute");
        return LalPolicyXPaths.getInsuranceSelect() + "/lal:roles/lal:role[@xsi:type='" + roleType + "']/lal:partyId/lal:key";
    }

    protected static String getSinglePaymentSubSelect() {
        return "/lal:singlePayments/lal:singlePayment";
    }

    protected static String getSinglePaymentSelect() {
        return LalPolicyXPaths.getInsuranceSelect() + LalPolicyXPaths.getSinglePaymentSubSelect();
    }

    public static String getFinancialBooking() {
        return LalPolicyXPaths.getInsuranceSelect() + "/lal:financialBookings/lal:financialBooking";
    }

    private static String getAccount(String partyNr, String accountId) {
        return LalPolicyXPaths.getPartySelect(partyNr) + "lal:accounts/lal:account[lal:id/lal:key = '" + accountId + "']/";
    }

    private static String getPartyStreet(String partyNr) {
        return LalPolicyXPaths.getPartyAddress(partyNr) + "lal:street/";
    }

    private static String getPartyAddress(String partyNr) {
        String partySelect = LalPolicyXPaths.getPartySelect(partyNr);
        return partySelect + "lal:addresses/lal:address/";
    }

    private static String getPartySelect(String partyNr) {
        return LalPolicyXPaths.getPoliciesSelect() + "lal:parties/lal:party[lal:id/lal:key='" + partyNr + "']/";
    }

    private static String getInsuranceSelect() {
        return LalPolicyXPaths.getPoliciesSelect() + "lal:policies/lal:policy/lal:insurances/lal:insurance/";
    }

    private static String getPoliciesSelect() {
        return "/env:Envelope/env:Body/lal:getPoliciesBody/lal:policiesBody/";
    }
}

