/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.leanapps;

import java.util.List;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.leanapps.LalPolicyXPaths;
import nl.hsac.fitnesse.fixture.util.XPathCheckResult;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;

public class LalResponse
extends XmlHttpResponse {
    private static final String NAMESPACE_PREFIX = "ns:";
    protected static String INSURANCE_SELECT = "/env:Envelope/env:Body/lal:getPoliciesBody/lal:policiesBody/lal:policies/lal:policy/lal:insurances/lal:insurance";
    protected static String POLICY_SELECT = "/env:Envelope/env:Body/lal:getPoliciesBody/lal:policiesBody/lal:policies/lal:policy";

    @Override
    public void validResponse() {
        super.validResponse();
        if (!"OK".equals(this.getStatus())) {
            String response = this.getResponse();
            Environment.handleErrorResponse("NOK response received: ", response);
        }
    }

    public String getStatus() {
        return this.getRawXPath(this.getResponse(), "//*[local-name()='status']/*[local-name()='status']", new Object[0]);
    }

    public String getError() {
        return this.getRawXPath(this.getResponse(), "//*[local-name()='error']/*[local-name()='message']", new Object[0]);
    }

    @Override
    public String getXsiTypeValue(String type) {
        return NAMESPACE_PREFIX + type;
    }

    protected static String getInsuranceSelect() {
        return INSURANCE_SELECT;
    }

    protected static String getPolicySelect() {
        return POLICY_SELECT;
    }

    public String paymentFrequency() {
        return this.getLalResponse().getXPath(this.getPremiumSelect() + "/lal:frequency", new Object[0]);
    }

    public LalResponse getLalResponse() {
        return this;
    }

    public Double premiumAmount() {
        return this.getXPathAmount(this.getPremiumSelect() + "/lal:amount", new Object[0]);
    }

    public Double insuredAmount() {
        return this.getXPathAmount(this.deathCoverageSelect() + "/lal:amount", new Object[0]);
    }

    public String deathCoverageSelect() {
        return LalResponse.getInsuranceSelect() + LalResponse.getDeathCoverageSubselect();
    }

    public static String getDeathCoverageSubselect() {
        return LalPolicyXPaths.getDeathCoverageSubselect();
    }

    public String premiumEndDate() {
        return this.getXPathDate(this.getPremiumSelect() + "/lal:endDate", new Object[0]);
    }

    public String intermediary() {
        String roleType = this.getLalResponse().getXsiTypeValue("InsuranceIntermediary");
        return this.getLalResponse().getXPath(LalResponse.getInsuranceSelect() + "/lal:roles/lal:role[@xsi:type='%s']/lal:partyId/lal:key", roleType);
    }

    public String productionCompany() {
        String roleType = this.getLalResponse().getXsiTypeValue("InsuranceInstitute");
        return this.getLalResponse().getXPath(LalResponse.getInsuranceSelect() + "/lal:roles/lal:role[@xsi:type='%s']/lal:partyId/lal:key", roleType);
    }

    public String collectionMethod() {
        return this.getXPath(this.getPremiumPayerSelect() + "/lal:collectionMethod", new Object[0]);
    }

    public String birthDate(String partyNr) {
        return this.getXPathDate(LalPolicyXPaths.partyDateOfBirth(partyNr), new Object[0]);
    }

    public boolean containsPolicy(String policyNr) {
        Double countPolicy = this.getLalResponse().getXPathAmount("count(" + LalResponse.getPolicySelect() + "/lal:id/lal:key[text()= '" + policyNr + "'])", new Object[0]);
        return countPolicy > 0.0;
    }

    public XPathCheckResult containsPolicies(List<String> policyNrList) {
        XPathCheckResult result = new XPathCheckResult();
        int i = 0;
        for (String currentPolicyNr : policyNrList) {
            ++i;
            if (this.containsPolicy(currentPolicyNr)) continue;
            result.addMisMatch(Integer.toString(i), currentPolicyNr, null);
        }
        return result;
    }

    protected String getPremiumPayerSelect() {
        return this.getPremiumSelect() + "/lal:premiumPayers/lal:premiumPayer";
    }

    protected String getPremiumSelect() {
        return LalResponse.getInsuranceSelect() + this.getPremiumSubSelect();
    }

    protected String getSinglePaymentSelect() {
        return LalResponse.getInsuranceSelect() + this.getSinglePaymentSubSelect();
    }

    protected String getPremiumSubSelect() {
        if (this.isPremiumPremium()) {
            return this.getPremiumPremiumSubSelect();
        }
        return this.getSinglePremiumSubSelect();
    }

    protected boolean isPremiumPremium() {
        Double premiumOid = this.getLalResponse().getXPathAmount(LalResponse.getInsuranceSelect() + this.getPremiumPremiumSubSelect() + "/lal:id/lal:oid", new Object[0]);
        if (premiumOid != null) {
            return premiumOid > 0.0;
        }
        return false;
    }

    public Double premiumPremiumOid() {
        return this.getXPathAmount(LalResponse.getInsuranceSelect() + this.getPremiumPremiumSubSelect() + "/lal:id/lal:oid", new Object[0]);
    }

    protected String getPremiumPremiumSubSelect() {
        return "/lal:premiums/lal:premium";
    }

    protected String getSinglePremiumSubSelect() {
        return "/lal:singlePremiums/lal:singlePremium";
    }

    protected String getSinglePaymentSubSelect() {
        return "/lal:singlePayments/lal:singlePayment";
    }

    protected String getFinancialBooking() {
        return LalResponse.getInsuranceSelect() + "/lal:financialBookings/lal:financialBooking";
    }

    protected String getPoliciesSelect() {
        return "/env:Envelope/env:Body/lal:getPoliciesBody/lal:policiesBody/lal:policies";
    }

    protected String getInsuranceStatedSelect() {
        return this.getPoliciesSelect() + "/lal:policy/lal:insurances/lal:insurance/lal:versionInfo/lal:currentVersion/lal:state";
    }

    public Double sumFinancialBookingForSinglePayment() {
        return this.getXPathAmount("sum(" + this.getFinancialBooking() + "[lal:transactionCategory/text()='SINGLE_PAYMENT' and lal:state/text() = 'RECEIVABLE_STATE_CREATED']/lal:amount)", new Object[0]);
    }

    public Double sumFinancialBooking() {
        return this.getXPathAmount("sum(" + this.getFinancialBooking() + "/lal:amount)", new Object[0]);
    }

    public Double sumFinancialBookingDeath() {
        return this.getXPathAmount("sum(" + this.getFinancialBooking() + "[lal:transactionCategory/text()='DEATH']/lal:amount)", new Object[0]);
    }

    public Double singlePayment() {
        return this.getXPathAmount(this.getSinglePaymentSelect() + "/lal:amount", new Object[0]);
    }

    public Double financialBooking() {
        return this.getXPathAmount(this.getFinancialBooking() + "/lal:amount", new Object[0]);
    }

    public Double numberInsuranceTerminatedDeath() {
        return this.getXPathAmount("count(" + this.getInsuranceStatedSelect() + "[text()='TERMINATED_DEATH'])", new Object[0]);
    }

    public Double numberInsuranceInForce() {
        return this.getXPathAmount("count(" + this.getInsuranceStatedSelect() + "[text()='IN_FORCE'])", new Object[0]);
    }

    public String insuranceState() {
        return this.getXPath(this.getInsuranceStatedSelect(), new Object[0]);
    }

    public String getInsured() {
        return this.getXPath(LalPolicyXPaths.partyInRole(this, "InsuranceInsured"), new Object[0]);
    }

    public String getPolicyHolder() {
        return this.getXPath(LalPolicyXPaths.partyInRole(this, "InsurancePolicyHolder"), new Object[0]);
    }
}

