/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.leanapps;

import fit.ColumnFixture;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.leanapps.LalCallColumnFixture;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;
import org.apache.commons.lang3.StringUtils;

public class ReportXmlFixture
extends ColumnFixture {
    private final Environment env = Environment.getInstance();
    private boolean hasWaited = false;
    private XmlHttpResponse response;
    private String policyNr;
    private String versionNr = "1";
    private boolean isTermination = false;

    public void execute() throws Exception {
        if (!this.hasWaited) {
            this.waitForReportXml();
            this.hasWaited = true;
        }
        super.execute();
        if (!StringUtils.isEmpty((CharSequence)this.policyNr)) {
            this.response = this.getReportXml(this.getReportXmlFilename());
        }
    }

    private XmlHttpResponse getReportXml(String reportXmlFilename) {
        String url = LalCallColumnFixture.getLalUrl() + "/xmlrr/archive/Report/" + reportXmlFilename;
        return this.env.doHttpGetXml(url);
    }

    private void waitForReportXml() {
        String waitTime = this.env.getRequiredSymbol("reportXmlWait");
        long waitDuration = Long.parseLong(waitTime);
        try {
            Thread.sleep(waitDuration);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting for report XML interrupted", e);
        }
    }

    public void reset() throws Exception {
        super.reset();
        this.response = new XmlHttpResponse();
        this.policyNr = null;
    }

    public String reportTrigger() {
        String foundTrigger;
        try {
            foundTrigger = this.response.getXPath("//LaLifeFreeParams/LaLifeFreeParam[name=\"YARDEN_REPORT_TRIGGER\"]/value", new Object[0]);
        }
        catch (Exception e) {
            foundTrigger = null;
        }
        return foundTrigger;
    }

    public String getReportXmlFilename() {
        String postFix = ".xml";
        if (!this.isTermination) {
            postFix = "_1_" + this.versionNr + postFix;
        }
        String preFix = "policy_";
        if (this.isTermination) {
            preFix = preFix + "laa004_";
        }
        return preFix + this.getPolicyNr() + postFix;
    }

    public String reportTriggerUrl() {
        return this.response.getRequest();
    }

    public String reportXml() {
        return Environment.getInstance().getHtmlForXml(this.response.getResponse());
    }

    public String getPolicyNr() {
        return this.policyNr;
    }

    public void setPolicyNr(String aPolicyNr) {
        this.policyNr = aPolicyNr;
    }

    public void setResponse(XmlHttpResponse aResponse) {
        this.response = aResponse;
    }

    public boolean isTermination() {
        return this.isTermination;
    }

    public void setTermination(boolean aIsTermination) {
        this.isTermination = aIsTermination;
    }

    public void setVersionNr(String aVersionNr) {
        this.versionNr = aVersionNr;
    }
}

