/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Base64Fixture
extends SlimFixture {
    private String saveBase;

    public Base64Fixture() {
        this.saveBase = new File(this.filesDir, "base64").getPath() + "/";
    }

    public String encode(String fileUrl) {
        String file = this.getFilePathFromWikiUrl(fileUrl);
        try {
            byte[] content = IOUtils.toByteArray((InputStream)new FileInputStream(file));
            return this.base64Encode(content);
        }
        catch (IOException e) {
            throw new SlimFixtureException("Unable to read: " + file, e);
        }
    }

    public String createFrom(String fileName, String base64String) {
        byte[] content;
        String ext;
        String baseName = FilenameUtils.getBaseName((String)fileName);
        String target = this.saveBase + baseName;
        String downloadedFile = FileUtil.saveToFile(target, ext = FilenameUtils.getExtension((String)fileName), content = this.base64Decode(base64String));
        String wikiUrl = this.getWikiUrl(downloadedFile);
        String result = wikiUrl != null ? String.format("<a href=\"%s\">%s</a>", wikiUrl, fileName) : downloadedFile;
        return result;
    }

    protected String base64Encode(byte[] content) {
        return Base64.encodeBase64String((byte[])content);
    }

    protected byte[] base64Decode(String base64String) {
        return Base64.decodeBase64((String)base64String);
    }

    public String getSaveBase() {
        return this.saveBase;
    }

    public void setSaveBase(String saveBase) {
        this.saveBase = saveBase;
    }
}

