/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import com.sksamuel.diffpatch.DiffMatchPatch;
import java.util.LinkedList;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.util.Formatter;
import org.apache.commons.text.StringEscapeUtils;

public class CompareFixture
extends SlimFixture {
    private final DiffMatchPatch diffMatchPatch = new DiffMatchPatch();

    public String differenceBetweenAnd(String first, String second) {
        Formatter whitespaceFormatter = new Formatter(){

            @Override
            public String format(String value) {
                return CompareFixture.this.ensureWhitespaceVisible(value);
            }
        };
        return this.getDifferencesHtml(first, second, whitespaceFormatter);
    }

    public String differenceBetweenExplicitWhitespaceAnd(String first, String second) {
        Formatter whitespaceFormatter = new Formatter(){

            @Override
            public String format(String value) {
                return CompareFixture.this.explicitWhitespace(value);
            }
        };
        return this.getDifferencesHtml(first, second, whitespaceFormatter);
    }

    protected String getDifferencesHtml(String first, String second, Formatter whitespaceFormatter) {
        if (first == null) {
            if (second == null) {
                return null;
            }
            first = "";
        } else if (second == null) {
            second = "";
        }
        LinkedList<DiffMatchPatch.Diff> diffs = this.getDiffs(first, second);
        String rootTag = first.startsWith("<pre>") && first.endsWith("</pre>") ? "pre" : "div";
        String diffPrettyHtml = this.diffToHtml(rootTag, diffs, whitespaceFormatter);
        if (first.startsWith("<pre>") && first.endsWith("</pre>")) {
            diffPrettyHtml = diffPrettyHtml.replaceFirst("^<div>", "<pre>").replaceFirst("</div>$", "</pre>");
        }
        return diffPrettyHtml;
    }

    public int countDifferencesBetweenAnd(String first, String second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            first = "";
        } else if (second == null) {
            second = "";
        }
        LinkedList<DiffMatchPatch.Diff> diffs = this.getDiffs(first, second);
        int diffCount = 0;
        for (DiffMatchPatch.Diff diff : diffs) {
            if (diff.operation == DiffMatchPatch.Operation.EQUAL) continue;
            ++diffCount;
        }
        return diffCount;
    }

    protected LinkedList<DiffMatchPatch.Diff> getDiffs(String first, String second) {
        LinkedList diffs = this.diffMatchPatch.diff_main(this.cleanupValue(first), this.cleanupValue(second));
        this.diffMatchPatch.diff_cleanupSemantic(diffs);
        return diffs;
    }

    public String differenceBetweenIgnoreWhitespaceAnd(String first, String second) {
        String cleanSecond;
        String cleanFirst = this.allWhitespaceToSingleSpace(first);
        String cleanDiff = this.differenceBetweenAnd(cleanFirst, cleanSecond = this.allWhitespaceToSingleSpace(second));
        if (cleanDiff != null) {
            if (("<div>" + cleanFirst + "</div>").equals(cleanDiff)) {
                cleanDiff = "<div>" + first + "</div>";
            } else if (cleanFirst != null && cleanFirst.equals(cleanDiff)) {
                cleanDiff = first;
            }
        }
        return cleanDiff;
    }

    public int countDifferencesBetweenIgnoreWhitespaceAnd(String first, String second) {
        String cleanFirst = this.allWhitespaceToSingleSpace(first);
        String cleanSecond = this.allWhitespaceToSingleSpace(second);
        return this.countDifferencesBetweenAnd(cleanFirst, cleanSecond);
    }

    protected String allWhitespaceToSingleSpace(String value) {
        return value != null ? value.replace("\u00a0", " ").replaceAll("\\s+", " ") : null;
    }

    protected String diffToHtml(String rootTag, LinkedList<DiffMatchPatch.Diff> diffs, Formatter whitespaceFormatter) {
        StringBuilder html = new StringBuilder("<");
        html.append(rootTag);
        html.append(">");
        if (diffs.size() == 1 && diffs.get((int)0).operation == DiffMatchPatch.Operation.EQUAL) {
            html.append(StringEscapeUtils.escapeHtml4((String)diffs.get((int)0).text));
        } else {
            for (DiffMatchPatch.Diff aDiff : diffs) {
                String text = StringEscapeUtils.escapeHtml4((String)aDiff.text);
                switch (aDiff.operation) {
                    case INSERT: {
                        text = whitespaceFormatter.format(text);
                        html.append("<ins class=\"collapse_rim\">").append(text).append("</ins>");
                        break;
                    }
                    case DELETE: {
                        text = whitespaceFormatter.format(text);
                        html.append("<del class=\"collapse_rim\">").append(text).append("</del>");
                        break;
                    }
                    case EQUAL: {
                        html.append("<span>").append(text).append("</span>");
                    }
                }
            }
        }
        html.append("</");
        html.append(rootTag);
        html.append(">");
        return html.toString();
    }

    protected String ensureWhitespaceVisible(String text) {
        return text.replace(" ", "&nbsp;").replaceAll("\r?\n", "&nbsp;<br/>");
    }

    protected String explicitWhitespace(String text) {
        return text.replace(" ", "&middot;").replace("\r", "&#8629;").replace("\n", "&para;<br/>").replace("\t", "&rarr;").replace("&nbsp;", "&bull;");
    }
}

