/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;

public class DateFormatFixture
extends SlimFixture {
    private String dateFormat;
    private TimeZone timezone;
    private String locale;
    private boolean timestampHasMilliseconds = true;

    public DateFormatFixture() {
        this(DateFormatFixture.getDefaultFormat(), DateFormatFixture.getDefaultTimeZone(), DateFormatFixture.getDefaultLocale());
    }

    public DateFormatFixture(String dateformat) {
        this(dateformat, DateFormatFixture.getDefaultTimeZone(), DateFormatFixture.getDefaultLocale());
    }

    public DateFormatFixture(String dateformat, String timezone) {
        this(dateformat, timezone, DateFormatFixture.getDefaultLocale());
    }

    public DateFormatFixture(String dateformat, String timezone, String locale) {
        this.setDateFormat(dateformat);
        this.setTimezone(timezone);
        this.setLocale(locale);
    }

    public void setDateFormat(String df) {
        this.dateFormat = df;
    }

    public void setTimezone(String newTimezone) {
        this.timezone = TimeZone.getTimeZone(newTimezone);
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void timestampHasMilliseconds(boolean hasMillis) {
        this.timestampHasMilliseconds = hasMillis;
    }

    public String formatTimestamp(long timestamp) {
        return this.formatTimestamp(this.getConfiguredDateFormat(), timestamp);
    }

    public String formatTimestampAs(long timestamp, String dateFormat) {
        SimpleDateFormat sdf = this.getDateFormat(dateFormat);
        return this.formatTimestamp(sdf, timestamp);
    }

    public String formatDateAs(String date, String newFormat) {
        Date parsedDate = this.parseDate(date);
        SimpleDateFormat targetFormat = this.getDateFormat(newFormat);
        return targetFormat.format(parsedDate);
    }

    public long timestampForDate(String date) {
        Date parsedDate = this.parseDate(date);
        return this.timestampForDate(parsedDate);
    }

    public long timestampForDateAs(String date, String dateFormat) {
        SimpleDateFormat df = this.getDateFormat(dateFormat);
        Date parsedDate = this.parseDate(df, date);
        return this.timestampForDate(parsedDate);
    }

    protected long timestampForDate(Date parsedDate) {
        long timeStamp = parsedDate.getTime();
        if (!this.timestampHasMilliseconds) {
            timeStamp /= 1000L;
        }
        return timeStamp;
    }

    protected String formatTimestamp(DateFormat sdf, long timestamp) {
        if (!this.timestampHasMilliseconds) {
            timestamp *= 1000L;
        }
        Date date = new Date(timestamp);
        return sdf.format(date);
    }

    protected Date parseDate(String date) {
        SimpleDateFormat sdf = this.getConfiguredDateFormat();
        return this.parseDate(sdf, date);
    }

    protected Date parseDate(SimpleDateFormat sdf, String date) {
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            String pattern = sdf.toPattern();
            throw new SlimFixtureException(false, "Could not parse " + date + " using format: " + pattern, e);
        }
    }

    protected SimpleDateFormat getConfiguredDateFormat() {
        return this.getDateFormat(this.dateFormat);
    }

    protected SimpleDateFormat getDateFormat(String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.forLanguageTag(this.locale));
        sdf.setTimeZone(this.timezone);
        return sdf;
    }

    protected static String getDefaultFormat() {
        return ((SimpleDateFormat)DateFormat.getDateInstance(3)).toPattern();
    }

    protected static String getDefaultTimeZone() {
        return TimeZone.getDefault().getID();
    }

    protected static String getDefaultLocale() {
        return Locale.getDefault().getLanguage();
    }
}

