/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import nl.hsac.fitnesse.fixture.slim.DateFormatFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;

public class DateTimeCalculatorFixture
extends SlimFixture {
    private String dateFormat;
    private DateFormatFixture dff;

    public DateTimeCalculatorFixture(String dateFormat) {
        this.setDateFormat(dateFormat);
    }

    public void setDateFormat(String df) {
        this.dateFormat = df;
        this.dff = new DateFormatFixture(this.dateFormat);
    }

    public String addYearsTo(int years, String formattedDate) {
        return this.addUnitsToDate(1, years, formattedDate);
    }

    public String addMonthsTo(int months, String formattedDate) {
        return this.addUnitsToDate(2, months, formattedDate);
    }

    public String addDaysTo(int days, String formattedDate) {
        return this.addUnitsToDate(5, days, formattedDate);
    }

    public String addHoursTo(int hours, String formattedDate) {
        return this.addUnitsToDate(10, hours, formattedDate);
    }

    public String addMinutesTo(int minutes, String formattedDate) {
        return this.addUnitsToDate(12, minutes, formattedDate);
    }

    public String addSecondsTo(int seconds, String formattedDate) {
        return this.addUnitsToDate(13, seconds, formattedDate);
    }

    private String addUnitsToDate(int unit, int number, String formattedDate) {
        Date d = this.dff.parseDate(formattedDate);
        SimpleDateFormat df = this.dff.getDateFormat(this.dateFormat);
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(unit, number);
        d = c.getTime();
        return df.format(d);
    }
}

