/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureWithMap;
import nl.hsac.fitnesse.fixture.util.ProgramResponse;
import org.apache.commons.lang3.StringUtils;

public class ExecuteProgramTest
extends SlimFixtureWithMap {
    private int timeout = 60000;
    private String workingDirectory;
    private List<String> arguments = new ArrayList<String>();
    private ProgramResponse response = new ProgramResponse();

    public void setTimeoutOfMilliseconds(int timeout) {
        this.timeout = timeout;
    }

    public void setTimeoutOfSeconds(int timeoutSeconds) {
        this.setTimeoutOfMilliseconds(timeoutSeconds * 1000);
    }

    public int timeout() {
        return this.timeout;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setAsArguments(List<String> arguments) {
        this.arguments = arguments == null ? new ArrayList<String>() : arguments;
    }

    public void setAsArgument(String argument, int index) {
        while (this.arguments.size() <= index) {
            this.arguments.add("");
        }
        this.arguments.set(index, argument);
    }

    public boolean execute(String command) {
        this.response = new ProgramResponse();
        if (!this.getCurrentValues().isEmpty()) {
            LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : this.getCurrentValues().entrySet()) {
                String value = String.valueOf(entry.getValue());
                env.put(entry.getKey(), value);
            }
            this.response.setEnvironment(env);
        }
        this.response.setDirectory(this.workingDirectory);
        this.response.setCommand(command);
        this.response.setArguments(this.arguments);
        this.getEnvironment().invokeProgram(this.timeout, this.response);
        return true;
    }

    public Integer exitCode() {
        return this.response.getExitCode();
    }

    public String standardOut() {
        return this.formatOutput(this.rawStandardOut());
    }

    public String standardError() {
        return this.rawStandardError();
    }

    public String rawStandardOut() {
        return this.response.getStdOut();
    }

    public String rawStandardError() {
        return this.response.getStdErr();
    }

    protected String formatOutput(String output) {
        String result = StringUtils.isEmpty((CharSequence)output) ? output : this.getEnvironment().getHtml(output);
        return result;
    }
}

