/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import nl.hsac.fitnesse.fixture.slim.Base64Fixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureWithMap;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import org.apache.commons.io.FilenameUtils;

public class FileFixture
extends SlimFixtureWithMap {
    private String directory;

    public FileFixture() {
        this.directory = new File(this.filesDir, "fileFixture").getPath() + File.separator;
    }

    public void setDirectory(String aDirectory) {
        if (this.isFilesUrl(aDirectory)) {
            String url = this.getUrl(aDirectory);
            String relativeDir = url.substring("files".length());
            relativeDir = relativeDir.replace('/', File.separatorChar);
            this.directory = this.filesDir + relativeDir;
        } else {
            this.directory = new File(aDirectory).isAbsolute() ? aDirectory : new File(this.getEnvironment().getFitNesseDir(), aDirectory).getAbsolutePath();
        }
        if (!this.directory.endsWith(File.separator)) {
            this.directory = this.directory + File.separator;
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    public String createFileFromBase64(String baseName, String base64Content) {
        Base64Fixture base64Fixture = this.getBase64Fixture();
        byte[] bytes = base64Fixture.base64Decode(base64Content);
        return this.createContaining(baseName, bytes);
    }

    public String createContainingValue(String filename, String key) {
        Object data = this.value(key);
        if (data == null) {
            throw new SlimFixtureException(false, "No value for key: " + key);
        }
        return this.createContaining(filename, data);
    }

    public String createContaining(String filename, Object data) {
        String file;
        if (data instanceof byte[]) {
            file = this.createContaining(filename, (byte[])data);
        } else if (data != null) {
            file = this.createContaining(filename, data.toString());
        } else {
            throw new SlimFixtureException(false, "Unable to create file from null");
        }
        return file;
    }

    public String createContaining(String filename, String content) {
        String fullName = this.getFullName(filename);
        this.ensureParentExists(fullName);
        File f = FileUtil.writeFile(fullName, content);
        return this.linkToFile(f);
    }

    protected String createContaining(String filename, byte[] content) {
        String baseName = FilenameUtils.getBaseName((String)filename);
        String target = this.getFullName(baseName);
        this.ensureParentExists(target);
        String ext = FilenameUtils.getExtension((String)filename);
        String downloadedFile = FileUtil.saveToFile(target, ext, content);
        return this.linkToFile(downloadedFile);
    }

    public String textIn(String filename) {
        String text = "";
        String fullName = this.getFullName(filename);
        if (this.sizeOf(filename) > 0L) {
            try {
                FileInputStream s = new FileInputStream(fullName);
                text = FileUtil.streamToString(s, fullName);
            }
            catch (FileNotFoundException e) {
                throw new SlimFixtureException(false, "Unable to find: " + fullName);
            }
        }
        return text;
    }

    public String takeFirstLineFrom(String filename) throws IOException {
        String fullName = this.getFullName(filename);
        this.ensureParentExists(fullName);
        File file = new File(fullName);
        Scanner fileScanner = new Scanner(file);
        if (!fileScanner.hasNextLine()) {
            throw new IOException(fullName + " is an empty file.");
        }
        String result = fileScanner.nextLine();
        String tmpFilename = fullName + ".tmp";
        File tmpFile = FileUtil.writeFromScanner(tmpFilename, fileScanner);
        FileUtil.copyFile(tmpFilename, fullName);
        tmpFile.delete();
        return result;
    }

    public boolean convertLineEndingsOfToWindows(String filename) throws IOException {
        return this.convertLineEndingsOf(filename, "\r\n");
    }

    public boolean convertLineEndingsOfToUnix(String filename) throws IOException {
        return this.convertLineEndingsOf(filename, "\n");
    }

    protected boolean convertLineEndingsOf(String filename, String lineEnding) throws IOException {
        String fullName = this.getFullName(filename);
        String original = this.textIn(fullName);
        String converted = this.getEnvironment().getLineEndingHelper().convertEndingsTo(original, lineEnding);
        String tmpFilename = fullName + ".tmp";
        File tmpFile = FileUtil.writeFile(tmpFilename, converted);
        FileUtil.copyFile(tmpFilename, fullName);
        tmpFile.delete();
        return true;
    }

    public String contentOf(String filename) throws IOException {
        String content = this.textIn(filename);
        return this.getEnvironment().getHtml(content);
    }

    public String createUsing(String filename, String templateName) {
        String content = this.getEnvironment().processTemplate(templateName, this.getCurrentValues());
        return this.createContaining(filename, content);
    }

    public String copyTo(String sourceName, String targetName) throws IOException {
        String fullSource = this.getFullName(sourceName);
        this.getFile(fullSource);
        String fullTarget = this.getFullName(targetName);
        this.ensureParentExists(fullTarget);
        File destFile = FileUtil.copyFile(fullSource, fullTarget);
        return this.linkToFile(destFile);
    }

    public long sizeOf(String filename) {
        String fullName = this.getFullName(filename);
        File file = this.getFile(fullName);
        return file.length();
    }

    public boolean exists(String filename) {
        String fullName = this.getFullName(filename);
        return new File(fullName).exists();
    }

    public boolean delete(String filename) {
        String fullName = this.getFullName(filename);
        File file = this.getFile(fullName);
        return file.delete();
    }

    public boolean deleteIfExists(String filename) {
        String fullName = this.getFullName(filename);
        File file = new File(fullName);
        boolean result = file.exists();
        if (result && !file.delete()) {
            throw new SlimFixtureException(false, "Unable to delete file");
        }
        return result;
    }

    public String filenameOf(String filename) {
        String fullName = this.getFullName(filename);
        return this.getFile(fullName).getName();
    }

    public String baseNameOf(String filename) {
        return FilenameUtils.getBaseName((String)this.filenameOf(filename));
    }

    public String extensionOf(String filename) {
        return FilenameUtils.getExtension((String)this.filenameOf(filename));
    }

    protected File getFile(String fullName) {
        File file = new File(fullName);
        if (!file.exists()) {
            throw new SlimFixtureException(false, "Unable to find: " + file.getAbsolutePath());
        }
        return file;
    }

    protected void ensureParentExists(String fullName) {
        File f = new File(fullName);
        File parentFile = f.getParentFile();
        parentFile.mkdirs();
    }

    protected String getFullName(String filename) {
        String name = filename.startsWith(File.separator) || ":\\".equals(filename.substring(1, 3)) ? filename : (this.isFilesUrl(filename) ? this.getFilePathFromWikiUrl(filename) : this.directory + filename);
        return this.cleanupPath(name);
    }

    private boolean isFilesUrl(String filename) {
        String url = this.getUrl(filename);
        return !filename.equals(url) && url.startsWith("files/");
    }

    private String cleanupPath(String fullPath) {
        return FilenameUtils.separatorsToSystem((String)fullPath);
    }

    public boolean pollUntilExists(String filename) {
        String fullname = this.getFullName(filename);
        return this.repeatUntil(FileFixture.fileExistsCompletion(fullname));
    }

    public boolean pollUntilDoesNotExist(String filename) {
        String fullname = this.getFullName(filename);
        return this.repeatUntilNot(FileFixture.fileExistsCompletion(fullname));
    }

    protected static SlimFixture.FunctionalCompletion fileExistsCompletion(String fullname) {
        return new SlimFixture.FunctionalCompletion(() -> new File(fullname).exists());
    }

    public boolean pollUntilSizeOfExceeds(String filename, long expectedSize) {
        return this.repeatUntil(new SlimFixture.FunctionalCompletion(() -> this.exists(filename) && this.sizeOf(filename) > expectedSize));
    }

    public String appendTo(String extraContent, String filename) {
        String fullName = this.getFullName(filename);
        this.ensureParentExists(fullName);
        File f = FileUtil.appendToFile(fullName, extraContent, false);
        return this.linkToFile(f);
    }

    public String appendToOnNewLine(String extraContent, String filename) {
        String fullName = this.getFullName(filename);
        this.ensureParentExists(fullName);
        File f = FileUtil.appendToFile(fullName, extraContent, true);
        return this.linkToFile(f);
    }

    public String zipAs(String inputfile, String zipname) {
        String fullName = this.getFullName(inputfile);
        File inputSrc = new File(fullName);
        String[] inputFiles = inputSrc.isDirectory() ? (String[])Arrays.stream(inputSrc.listFiles()).map(File::getAbsolutePath).toArray(String[]::new) : new String[]{fullName};
        try {
            String nonExistingZip = this.findNameForFile(zipname);
            File zip = this.getEnvironment().getZipHelper().createZip(nonExistingZip, inputFiles);
            return this.linkToFile(zip);
        }
        catch (IOException e) {
            throw new SlimFixtureException(true, "Unable to create zip. " + e.getMessage(), e);
        }
    }

    public String unzipAs(String zipname, String targetDir) {
        String zipfile = this.getFullName(zipname);
        try {
            String nonExistingTarget = this.findNameForFile(targetDir);
            this.getEnvironment().getZipHelper().unzip(zipfile, nonExistingTarget);
            return this.linkToFile(nonExistingTarget);
        }
        catch (IOException e) {
            throw new SlimFixtureException(true, "Unable to unzip. " + e.getMessage(), e);
        }
    }

    private String findNameForFile(String fileFromWiki) {
        String basename = FilenameUtils.getBaseName((String)fileFromWiki);
        String target = this.getFullName(basename);
        this.ensureParentExists(target);
        String targetExt = FilenameUtils.getExtension((String)fileFromWiki);
        return FileUtil.determineFilename(target, targetExt).getAbsolutePath();
    }

    public long numberOfFilesInZip(String zipname) {
        return this.applyOnZipEntries(zipname, Stream::count);
    }

    public ArrayList<String> namesOfFilesInZip(String zipname) {
        return this.applyOnZipEntries(zipname, s -> s.map(ZipEntry::getName).collect(Collectors.toCollection(ArrayList::new)));
    }

    protected <T> T applyOnZipEntries(String zipname, Function<Stream<ZipEntry>, T> function) {
        String zipfile = this.getFullName(zipname);
        try {
            List<ZipEntry> entries = this.getEnvironment().getZipHelper().getEntries(zipfile);
            return function.apply(entries.stream().filter(e -> !e.isDirectory()));
        }
        catch (IOException e2) {
            throw new SlimFixtureException(true, "Unable get zip entries. " + e2.getMessage(), e2);
        }
    }
}

