/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import nl.hsac.fitnesse.fixture.slim.SlimFixtureWithMap;

public class FreemarkerFixture
extends SlimFixtureWithMap {
    private final String defaultTemplate;
    private String targetLineEndings;

    public FreemarkerFixture() {
        this((String)null);
    }

    public FreemarkerFixture(String defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public String applyTemplate(String aTemplate) {
        String result = this.getEnvironment().processTemplate(aTemplate, this.getCurrentValues());
        result = this.postProcess(result);
        result = this.formatResult(aTemplate, result);
        return result;
    }

    protected String postProcess(String result) {
        if (this.targetLineEndings != null) {
            return this.getEnvironment().getLineEndingHelper().convertEndingsTo(result, this.targetLineEndings);
        }
        return result;
    }

    protected String formatResult(String aTemplate, String result) {
        try {
            if (aTemplate.contains(".xml")) {
                result = this.getEnvironment().getHtmlForXml(result);
            } else if (aTemplate.contains(".json")) {
                result = this.getEnvironment().getHtmlForJson(result);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String get(String requestedValue) {
        String result = this.defaultTemplate == null ? this.applyTemplate(requestedValue) : this.applyTemplate(this.defaultTemplate);
        return result;
    }

    public void convertTemplateLineEndingsToWindows() {
        this.targetLineEndings = "\r\n";
    }

    public void convertTemplateLineEndingsToUnix() {
        this.targetLineEndings = "\n";
    }

    public void doNotconvertTemplateLineEndings() {
        this.targetLineEndings = null;
    }
}

