/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import fit.exception.FitFailureException;
import freemarker.template.Template;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.fixture.slim.Base64Fixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureWithMap;
import nl.hsac.fitnesse.fixture.slim.StopTestException;
import nl.hsac.fitnesse.fixture.util.BinaryHttpResponse;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import nl.hsac.fitnesse.fixture.util.NonValidResponseReceivedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;

public class HttpTest
extends SlimFixtureWithMap {
    public static final String DEFAULT_POST_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=UTF-8";
    private String downloadBase;
    private final Map<String, Object> headerValues;
    private boolean stopTestOnException;
    private boolean storeCookies;
    private HttpResponse response;
    private String template;
    private boolean explicitContentTypeSet;
    private String contentType;
    private String lastUrl;
    private String lastMethod;
    private boolean throwExceptionOnHttpRequestFailure;
    private static final Pattern HEADER_KEY_PATTERN = Pattern.compile("header:\\s*(\\.+)");

    public HttpTest() {
        this.downloadBase = new File(this.filesDir, "downloads").getPath() + "/";
        this.headerValues = new LinkedHashMap<String, Object>();
        this.stopTestOnException = true;
        this.storeCookies = false;
        this.response = this.createResponse();
        this.explicitContentTypeSet = false;
        this.contentType = DEFAULT_POST_CONTENT_TYPE;
        this.lastUrl = null;
        this.lastMethod = null;
        this.throwExceptionOnHttpRequestFailure = false;
    }

    public void setThrowExceptionOnHttpRequestFailure(boolean throwException) {
        this.throwExceptionOnHttpRequestFailure = throwException;
    }

    public boolean getThrowExceptionOnHttpRequestFailure() {
        return this.throwExceptionOnHttpRequestFailure;
    }

    public boolean template(String aTemplate) {
        boolean result = false;
        Template t = this.getEnvironment().getTemplate(aTemplate);
        if (t != null) {
            this.template = aTemplate;
            result = true;
        }
        return result;
    }

    public void enableCompression() {
        this.getEnvironment().enableHttpClientCompression();
    }

    public void disableCompression() {
        this.getEnvironment().disableHttpClientCompression();
    }

    public void disableSSLVerification() {
        this.getEnvironment().disableHttpClientSSLVerification();
    }

    public void enableSSLVerification() {
        this.getEnvironment().enableHttpClientSSLVerification();
    }

    public void setValueForHeader(Object value, String name) {
        this.getMapHelper().setValueForIn(value, name, this.headerValues);
    }

    public boolean clearHeaderValue(String name) {
        String cleanName = this.cleanupValue(name);
        boolean result = this.headerValues.containsKey(cleanName);
        this.headerValues.remove(cleanName);
        return result;
    }

    public void clearHeaderValues() {
        this.headerValues.clear();
    }

    public void copyHeaderValuesFrom(Map<String, Object> map) {
        this.getMapHelper().copyValuesFromTo(map, this.headerValues);
    }

    protected Map<String, Object> getHeaderValues() {
        return this.headerValues;
    }

    @Override
    public void reset() {
        this.clearValues();
        this.clearHeaderValues();
    }

    @Override
    public void set(String key, Object value) {
        Matcher m = HEADER_KEY_PATTERN.matcher(key);
        if (m.matches()) {
            String headerKey = m.group(1);
            this.setValueForHeader(value, headerKey);
        } else {
            super.set(key, value);
        }
    }

    protected String createFileFromBase64(String baseName, String base64Content) {
        Base64Fixture base64Fixture = this.getBase64Fixture();
        return base64Fixture.createFrom(baseName, base64Content);
    }

    public boolean postTemplateTo(String serviceUrl) {
        return this.postTemplateTo(serviceUrl, this.getContentType());
    }

    public boolean postTemplateTo(String serviceUrl, String aContentType) {
        return this.sendTemplateTo(serviceUrl, aContentType, "POST");
    }

    public boolean postTo(String body, String serviceUrl) {
        String cleanedBody = this.cleanupBody(body);
        return this.postToImpl(cleanedBody, serviceUrl);
    }

    public boolean deleteWith(String serviceUrl, String body) {
        String cleanedBody = this.cleanupBody(body);
        return this.deleteToImpl(cleanedBody, serviceUrl);
    }

    public boolean postFileTo(String fileName, String serviceUrl) {
        return this.postFileToImpl(fileName, serviceUrl);
    }

    public boolean postValuesTo(String serviceUrl) {
        String body = this.urlEncodeCurrentValues();
        return this.postToImpl(body, serviceUrl);
    }

    protected boolean postToImpl(String body, String serviceUrl) {
        return this.sendToImpl(body, serviceUrl, this.getContentType(), "POST");
    }

    protected boolean deleteToImpl(String body, String serviceUrl) {
        return this.sendToImpl(body, serviceUrl, this.getContentType(), "DELETE");
    }

    protected boolean patchWithImpl(String body, String serviceUrl) {
        return this.sendToImpl(body, serviceUrl, this.getContentType(), "PATCH");
    }

    protected boolean sendToImpl(String body, String serviceUrl, String aContentType, String method) {
        this.resetResponse();
        this.response.setRequest(body);
        String url = this.getUrl(serviceUrl);
        try {
            this.storeLastCall(method, serviceUrl);
            switch (method) {
                case "POST": {
                    this.getEnvironment().doHttpPost(url, this.response, this.headerValues, aContentType);
                    break;
                }
                case "PUT": {
                    this.getEnvironment().doHttpPut(url, this.response, this.headerValues, aContentType);
                    break;
                }
                case "DELETE": {
                    this.getEnvironment().doDelete(url, this.response, this.headerValues, aContentType);
                    break;
                }
                case "PATCH": {
                    this.getEnvironment().doHttpPatch(url, this.response, this.headerValues, aContentType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported method: " + method);
                }
            }
        }
        catch (Throwable t) {
            this.handleCallException("Unable to get response from " + method + " to: " + url, t);
        }
        boolean result = this.postProcessResponse();
        return result;
    }

    protected boolean postFileToImpl(String fileName, String serviceUrl) {
        return this.sendFileImpl(fileName, serviceUrl, "POST");
    }

    public boolean putTemplateTo(String serviceUrl) {
        return this.sendTemplateTo(serviceUrl, this.getContentType(), "PUT");
    }

    public boolean deleteWithTemplate(String serviceUrl) {
        return this.sendTemplateTo(serviceUrl, this.getContentType(), "DELETE");
    }

    public boolean patchWithTemplate(String serviceUrl) {
        return this.sendTemplateTo(serviceUrl, this.getContentType(), "PATCH");
    }

    public boolean sendTemplateTo(String serviceUrl, String aContentType, String method) {
        this.resetResponse();
        if (this.template == null) {
            throw new StopTestException("No template available to use in " + method);
        }
        String url = this.getUrl(serviceUrl);
        try {
            this.storeLastCall(method, serviceUrl);
            switch (method) {
                case "POST": {
                    this.getEnvironment().doHttpPost(url, this.template, this.getCurrentValues(), this.response, this.headerValues, aContentType);
                    break;
                }
                case "PUT": {
                    this.getEnvironment().doHttpPut(url, this.template, this.getCurrentValues(), this.response, this.headerValues, aContentType);
                    break;
                }
                case "DELETE": {
                    this.getEnvironment().doDelete(url, this.template, this.getCurrentValues(), this.response, this.headerValues, aContentType);
                    break;
                }
                case "PATCH": {
                    this.getEnvironment().doHttpPatch(url, this.template, this.getCurrentValues(), this.response, this.headerValues, aContentType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported method: " + method);
                }
            }
        }
        catch (Throwable t) {
            this.handleCallException("Unable to get response from " + method + " to: " + url, t);
        }
        boolean result = this.postProcessResponse();
        return result;
    }

    public boolean putTo(String body, String serviceUrl) {
        String cleanedBody = this.cleanupBody(body);
        return this.putToImpl(cleanedBody, serviceUrl);
    }

    public boolean patchWith(String serviceUrl, String body) {
        String cleanedBody = this.cleanupBody(body);
        return this.patchWithImpl(cleanedBody, serviceUrl);
    }

    public boolean putValuesTo(String serviceUrl) {
        String body = this.urlEncodeCurrentValues();
        return this.putToImpl(body, serviceUrl);
    }

    protected boolean putToImpl(String body, String serviceUrl) {
        return this.sendToImpl(body, serviceUrl, this.getContentType(), "PUT");
    }

    public boolean putFileTo(String fileName, String serviceUrl) {
        return this.putFileToImpl(fileName, serviceUrl);
    }

    protected boolean putFileToImpl(String fileName, String serviceUrl) {
        return this.sendFileImpl(fileName, serviceUrl, "PUT");
    }

    protected boolean sendFileImpl(String fileName, String serviceUrl, String method) {
        this.resetResponse();
        String url = this.getUrl(serviceUrl);
        String filePath = this.getFilePathFromWikiUrl(fileName);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new StopTestException(false, "File " + filePath + " not found.");
        }
        try {
            this.response.setRequest(fileName);
            this.storeLastCall(method + "_FILE", serviceUrl);
            switch (method) {
                case "POST": {
                    this.getEnvironment().doHttpFilePost(url, this.response, this.headerValues, file);
                    break;
                }
                case "PUT": {
                    this.getEnvironment().doHttpFilePut(url, this.response, this.headerValues, file);
                }
            }
        }
        catch (Throwable t) {
            this.handleCallException("Unable to get response from " + method + " to: " + url, t);
        }
        boolean result = this.postProcessResponse();
        return result;
    }

    protected String cleanupBody(String body) {
        return this.getEnvironment().getHtmlCleaner().cleanupPreFormatted(body);
    }

    public boolean getFrom(String serviceUrl) {
        return this.getImpl(serviceUrl, true);
    }

    public boolean getFromNoRedirect(String serviceUrl) {
        return this.getImpl(serviceUrl, false);
    }

    protected boolean getImpl(String serviceUrl, boolean followRedirect) {
        this.resetResponse();
        String url = this.createUrlWithParams(serviceUrl);
        try {
            String method = followRedirect ? "GET" : "GET_NO_REDIRECT";
            this.storeLastCall(method, serviceUrl);
            this.getEnvironment().doGet(url, this.response, this.headerValues, followRedirect);
        }
        catch (Throwable t) {
            this.handleCallException("Unable to GET response from: " + url, t);
        }
        boolean result = this.postProcessResponse();
        return result;
    }

    public String getFileFrom(String serviceUrl) {
        String fileName;
        this.resetResponse();
        String url = this.createUrlWithParams(serviceUrl);
        BinaryHttpResponse resp = new BinaryHttpResponse();
        resp.setCookieStore(this.response.getCookieStore());
        this.getEnvironment().doGet(url, (HttpResponse)resp, this.headerValues);
        this.response.cloneValues(resp);
        byte[] content = resp.getResponseContent();
        if (content == null) {
            try {
                content = resp.getResponse().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((CharSequence)(fileName = resp.getFileName()))) {
            fileName = "download";
        }
        return this.createFile(this.downloadBase, fileName, content);
    }

    public boolean headFrom(String serviceUrl) {
        this.resetResponse();
        String url = this.createUrlWithParams(serviceUrl);
        try {
            this.storeLastCall("HEAD", serviceUrl);
            this.getEnvironment().doHead(url, this.response, this.headerValues);
        }
        catch (Throwable t) {
            this.handleCallException("Unable to HEAD: " + url, t);
        }
        boolean result = this.postProcessResponse();
        return result;
    }

    public boolean delete(String serviceUrl) {
        this.resetResponse();
        String url = this.createUrlWithParams(serviceUrl);
        try {
            this.storeLastCall("DELETE", serviceUrl);
            this.getEnvironment().doDelete(url, this.response, this.headerValues);
        }
        catch (Throwable t) {
            this.handleCallException("Unable to DELETE: " + url, t);
        }
        boolean result = this.postProcessResponse();
        return result;
    }

    protected void handleCallException(String msg, Throwable t) {
        if (this.stopTestOnException()) {
            throw new StopTestException(msg, t);
        }
        this.logger.warn(msg);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(msg, t);
        }
    }

    protected void resetResponse() {
        CookieStore cookieStore = null;
        if (this.storeCookies && (cookieStore = this.getResponse().getCookieStore()) == null) {
            cookieStore = new BasicCookieStore();
        }
        this.response = this.createResponse();
        if (this.storeCookies) {
            this.response.setCookieStore(cookieStore);
        }
    }

    protected String createUrlWithParams(String serviceUrl) {
        String baseUrl = this.getUrl(serviceUrl);
        if (!this.getCurrentValues().isEmpty()) {
            if (baseUrl.contains("?") && !baseUrl.endsWith("?")) {
                baseUrl = baseUrl + "&";
            }
            if (!baseUrl.contains("?")) {
                baseUrl = baseUrl + "?";
            }
            baseUrl = baseUrl + this.urlEncodeCurrentValuesForQueryString();
        }
        return baseUrl;
    }

    protected String urlEncodeCurrentValuesForQueryString() {
        return this.urlEncodeCurrentValues().replace("+", "%20");
    }

    protected String urlEncodeCurrentValues() {
        StringBuilder sb = new StringBuilder();
        this.addUrlEncodedKeyValues(sb, "", this.getCurrentValues());
        return sb.toString();
    }

    private void addUrlEncodedKeyValues(StringBuilder sb, String prefix, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = prefix + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                for (Object v : values) {
                    this.addEncodedKeyValue(sb, key, v);
                }
                continue;
            }
            if (value instanceof Map) {
                this.addUrlEncodedKeyValues(sb, key + ".", (Map)value);
                continue;
            }
            this.addEncodedKeyValue(sb, key, value);
        }
    }

    private void addEncodedKeyValue(StringBuilder sb, String key, Object value) {
        if (sb.length() != 0) {
            sb.append("&");
        }
        sb.append(this.urlEncode(key));
        if (value != null) {
            sb.append("=");
            sb.append(this.urlEncode(value.toString()));
        }
    }

    protected String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    protected boolean postProcessResponse() {
        return this.responseIsValid();
    }

    public boolean responseIsValid() {
        try {
            this.response.validResponse();
        }
        catch (FitFailureException | NonValidResponseReceivedException e) {
            if (this.throwExceptionOnHttpRequestFailure) {
                throw new SlimFixtureException(false, e.getMessage());
            }
            return false;
        }
        return true;
    }

    public String request() {
        return this.safeFormatValue(this.response.getRequest());
    }

    public String response() {
        return this.safeFormatValue(this.response.getResponse());
    }

    protected final String safeFormatValue(String value) {
        String result;
        try {
            result = this.formatValue(value);
        }
        catch (Exception e) {
            result = value;
        }
        return result;
    }

    protected String formatValue(String value) {
        return value;
    }

    public String htmlResponse() {
        String content = this.response.getResponse();
        content = "<div>" + content + "</div>";
        return content;
    }

    public long responseTime() {
        return this.getResponse().getResponseTime();
    }

    public int responseStatus() {
        return this.response.getStatusCode();
    }

    public Map<String, Object> responseHeaders() {
        return this.response.getResponseHeaders();
    }

    public Object responseHeader(String headerName) {
        return this.responseHeaders().get(headerName);
    }

    public void setStoreCookies(boolean storeCookies) {
        this.storeCookies = storeCookies;
    }

    public void copyBrowserCookies() {
        this.setStoreCookies(true);
        this.getEnvironment().addSeleniumCookies(this.getResponse());
    }

    public Map<String, String> cookieValues() {
        LinkedHashMap<String, String> result = null;
        CookieStore cookies = this.getResponse().getCookieStore();
        if (cookies != null) {
            result = new LinkedHashMap<String, String>();
            for (Cookie cookie : cookies.getCookies()) {
                result.put(cookie.getName(), cookie.getValue());
            }
        }
        return result;
    }

    public String cookieValue(String cookieName) {
        String result = null;
        Cookie cookie = this.getCookie(cookieName);
        if (cookie != null) {
            result = cookie.getValue();
        }
        return result;
    }

    public String cookieDomain(String cookieName) {
        String result = null;
        Cookie cookie = this.getCookie(cookieName);
        if (cookie != null) {
            result = cookie.getDomain();
        }
        return result;
    }

    public String cookiePath(String cookieName) {
        String result = null;
        Cookie cookie = this.getCookie(cookieName);
        if (cookie != null) {
            result = cookie.getPath();
        }
        return result;
    }

    public Boolean cookieIsPersistent(String cookieName) {
        Boolean result = null;
        Cookie cookie = this.getCookie(cookieName);
        if (cookie != null) {
            result = cookie.isPersistent();
        }
        return result;
    }

    public Boolean cookieIsSecure(String cookieName) {
        Boolean result = null;
        Cookie cookie = this.getCookie(cookieName);
        if (cookie != null) {
            result = cookie.isSecure();
        }
        return result;
    }

    public Boolean cookieIsHttpOnly(String cookieName) {
        return this.cookieAttribute(cookieName, "httponly") != null;
    }

    public String cookieAttribute(String cookieName, String attributeName) {
        String result = null;
        Cookie cookie = this.getCookie(cookieName);
        if (cookie instanceof BasicClientCookie) {
            result = ((BasicClientCookie)cookie).getAttribute(attributeName.toLowerCase(Locale.ENGLISH));
        }
        return result;
    }

    private Cookie getCookie(String cookieName) {
        return this.getResponse().getCookieNamed(cookieName);
    }

    public void clearCookies() {
        this.getResponse().getCookieStore().clear();
    }

    protected HttpResponse getResponse() {
        return this.response;
    }

    protected HttpResponse createResponse() {
        return new HttpResponse();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String aContentType) {
        this.explicitContentTypeSet = true;
        this.contentType = aContentType;
    }

    public void setBasicAuthorizationHeaderForUserAndPassword(String user, String password) {
        String credential = user + ":" + password;
        try {
            String base64credential = Base64.getEncoder().encodeToString(credential.getBytes("ISO-8859-1"));
            this.setValueForHeader("Basic " + base64credential, "Authorization");
        }
        catch (UnsupportedEncodingException e) {
            throw new SlimFixtureException("ISO-8859-1 encoding unavailable!", e);
        }
    }

    public boolean isExplicitContentTypeSet() {
        return this.explicitContentTypeSet;
    }

    public void setStopTestOnException(boolean stopTestOnException) {
        this.stopTestOnException = stopTestOnException;
    }

    public boolean stopTestOnException() {
        return this.stopTestOnException;
    }

    public boolean repeatUntilResponseStatusIs(final int expectedStatus) {
        return this.repeatUntil(new RepeatLastCall(){

            @Override
            public boolean isFinished() {
                return HttpTest.this.responseStatus() == expectedStatus;
            }
        });
    }

    public boolean repeatUntilResponseIs(final String expectedResponse) {
        RepeatLastCall completion = expectedResponse == null ? new RepeatLastCall(){

            @Override
            public boolean isFinished() {
                return HttpTest.this.response() == null;
            }
        } : new RepeatLastCall(){

            @Override
            public boolean isFinished() {
                String actual = HttpTest.this.response();
                return this.compareActualToExpected(expectedResponse, actual);
            }
        };
        return this.repeatUntil(completion);
    }

    public boolean repeatUntilHeaderIs(final String header, final Object expectedValue) {
        RepeatLastCall completion = expectedValue == null ? new RepeatLastCall(){

            @Override
            public boolean isFinished() {
                return HttpTest.this.responseHeader(header) == null;
            }
        } : new RepeatLastCall(){

            @Override
            public boolean isFinished() {
                Object actual = HttpTest.this.responseHeader(header);
                return this.compareActualToExpected(expectedValue, actual);
            }
        };
        return this.repeatUntil(completion);
    }

    protected void repeatLastCall() {
        if (this.lastMethod == null) {
            throw new SlimFixtureException(false, "First make a call before trying to repeat one.");
        }
        switch (this.lastMethod) {
            case "GET": {
                this.getImpl(this.lastUrl, true);
                break;
            }
            case "HEAD": {
                this.headFrom(this.lastUrl);
                break;
            }
            case "POST": {
                this.postToImpl(this.response.getRequest(), this.lastUrl);
                break;
            }
            case "PUT": {
                this.putToImpl(this.response.getRequest(), this.lastUrl);
                break;
            }
            case "PATCH": {
                this.patchWithImpl(this.response.getRequest(), this.lastUrl);
                break;
            }
            case "DELETE": {
                if (this.lastUrl.equals(this.response.getRequest())) {
                    this.delete(this.lastUrl);
                    break;
                }
                this.deleteToImpl(this.response.getRequest(), this.lastUrl);
                break;
            }
            case "GET_NO_REDIRECT": {
                this.getImpl(this.lastUrl, false);
                break;
            }
            case "POST_FILE": {
                this.postFileToImpl(this.response.getRequest(), this.lastUrl);
                break;
            }
            case "PUT_FILE": {
                this.putFileToImpl(this.response.getRequest(), this.lastUrl);
                break;
            }
            default: {
                throw new SlimFixtureException(false, "Repeat of method: " + this.lastMethod + " not configured.");
            }
        }
    }

    protected void storeLastCall(String method, String url) {
        this.lastMethod = method;
        this.lastUrl = url;
    }

    protected abstract class RepeatLastCall
    implements SlimFixture.RepeatCompletion {
        protected RepeatLastCall() {
        }

        protected boolean compareActualToExpected(Object expected, Object actual) {
            boolean result = actual == null ? expected.equals("null") : expected.equals(actual) || expected.toString().equals(actual.toString());
            return result;
        }

        @Override
        public void repeat() {
            HttpTest.this.repeatLastCall();
        }
    }
}

