/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.ArrayList;
import java.util.List;
import nl.hsac.fitnesse.fixture.slim.Base64Fixture;
import nl.hsac.fitnesse.fixture.slim.FileFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.DataUrlHelper;
import nl.hsac.fitnesse.fixture.util.JsonPathHelper;

public class JsonFixture
extends SlimFixture {
    private String content;

    public boolean loadFile(String filename) {
        this.content = this.getFileFixture().textIn(filename);
        return true;
    }

    public boolean load(String json) {
        this.content = this.cleanupValue(json);
        return true;
    }

    public String object() {
        String trimmed;
        String formatted = this.content;
        if (this.content != null && ((trimmed = this.content.trim()).startsWith("{") || trimmed.startsWith("["))) {
            formatted = this.getEnvironment().getHtmlForJson(trimmed);
        }
        return formatted;
    }

    public Object jsonPath(String path) {
        String jsonPath = this.getPathExpr(path);
        return this.getPathHelper().getJsonPath(this.content, jsonPath);
    }

    public String createFileFromBase64ContentOf(String baseName, String jsonPath) {
        Object base64Content = this.jsonPath(jsonPath);
        if (base64Content instanceof String) {
            String base64String = (String)base64Content;
            if ("".equals(base64Content)) {
                throw new SlimFixtureException(false, "No content from json path: '" + this.getPathExpr(jsonPath) + "'");
            }
            if (DataUrlHelper.isDataUrl(base64String)) {
                base64String = DataUrlHelper.getData(base64String);
            }
            return this.createFileFromBase64(baseName, base64String);
        }
        throw new SlimFixtureException(false, "Non string result from json path. '" + this.getPathExpr(jsonPath) + "' returned: " + base64Content);
    }

    public Object elementOfJsonPath(int index, String path) {
        ArrayList<Object> all = this.listJsonPathMatches(path);
        return all.get(index);
    }

    public int jsonPathCount(String path) {
        ArrayList<Object> all = this.listJsonPathMatches(path);
        return all.size();
    }

    public ArrayList<Object> listJsonPathMatches(String path) {
        String jsonPath = this.getPathExpr(path);
        List<Object> results = this.getPathHelper().getAllJsonPath(this.content, jsonPath);
        return results instanceof ArrayList ? (ArrayList<Object>)results : new ArrayList<Object>(results);
    }

    protected String getPathExpr(String path) {
        String jsonPath = path;
        if (!path.startsWith("$")) {
            jsonPath = path.startsWith("[") || path.startsWith(".") ? "$" + path : "$." + path;
        }
        return jsonPath;
    }

    public void setJsonPathTo(String path, Object value) {
        String newContent;
        Object cleanValue = this.cleanupValue(value);
        String jsonPath = this.getPathExpr(path);
        this.content = newContent = this.getPathHelper().updateJsonPathWithValue(this.content, jsonPath, cleanValue);
    }

    public boolean jsonPathExists(String path) {
        return this.getPathHelper().jsonPathExists(this.content, this.getPathExpr(path));
    }

    protected String getContent() {
        return this.content;
    }

    protected String createFileFromBase64(String baseName, String base64Content) {
        Base64Fixture base64Fixture = this.getBase64Fixture();
        return base64Fixture.createFrom(baseName, base64Content);
    }

    protected Base64Fixture getBase64Fixture() {
        return new Base64Fixture();
    }

    protected FileFixture getFileFixture() {
        return new FileFixture();
    }

    protected JsonPathHelper getPathHelper() {
        return this.getEnvironment().getJsonPathHelper();
    }
}

