/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.ArrayList;
import java.util.List;
import nl.hsac.fitnesse.fixture.slim.HttpTest;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.DataUrlHelper;
import nl.hsac.fitnesse.fixture.util.JsonPathHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.json.JSONObject;

public class JsonHttpTest
extends HttpTest {
    public static final String JSON_CONTENT_TYPE = ContentType.APPLICATION_JSON.toString();

    public boolean postValuesAsJsonTo(String serviceUrl) {
        return this.sendToImpl(this.jsonEncodeCurrentValues(), serviceUrl, this.getContentTypeForJson(), "POST");
    }

    public boolean putValuesAsJsonTo(String serviceUrl) {
        return this.sendToImpl(this.jsonEncodeCurrentValues(), serviceUrl, this.getContentTypeForJson(), "PUT");
    }

    public boolean deleteWithValuesAsJson(String serviceUrl) {
        return this.sendToImpl(this.jsonEncodeCurrentValues(), serviceUrl, this.getContentTypeForJson(), "DELETE");
    }

    protected String jsonEncodeCurrentValues() {
        return new JSONObject(this.getCurrentValues()).toString();
    }

    protected String getContentTypeForJson() {
        String contentType = this.isExplicitContentTypeSet() ? this.getContentType() : JSON_CONTENT_TYPE;
        return contentType;
    }

    @Override
    protected String formatValue(String value) {
        String trimmed;
        String formatted = super.formatValue(value);
        if (value != null && ((trimmed = value.trim()).startsWith("{") || trimmed.startsWith("["))) {
            formatted = this.getEnvironment().getHtmlForJson(trimmed);
        }
        return formatted;
    }

    public Object jsonPath(String path) {
        String responseString = this.getResponseBody();
        String jsonPath = this.getPathExpr(path);
        return this.getPathHelper().getJsonPath(responseString, jsonPath);
    }

    public String createFileFromBase64ContentOf(String baseName, String jsonPath) {
        Object base64Content = this.jsonPath(jsonPath);
        if (base64Content instanceof String) {
            if ("".equals(base64Content)) {
                throw new SlimFixtureException(false, "No content from json path: '" + this.getPathExpr(jsonPath) + "'");
            }
            return this.createFileFromBase64(baseName, (String)base64Content);
        }
        throw new SlimFixtureException(false, "Non string result from json path. '" + this.getPathExpr(jsonPath) + "' returned: " + base64Content);
    }

    @Override
    protected String createFileFromBase64(String baseName, String base64Content) {
        if (DataUrlHelper.isDataUrl(base64Content)) {
            base64Content = DataUrlHelper.getData(base64Content);
        }
        return super.createFileFromBase64(baseName, base64Content);
    }

    public Object elementOfJsonPath(int index, String path) {
        ArrayList<Object> all = this.listJsonPathMatches(path);
        return all.get(index);
    }

    public int jsonPathCount(String path) {
        ArrayList<Object> all = this.listJsonPathMatches(path);
        return all.size();
    }

    public ArrayList<Object> listJsonPathMatches(String path) {
        String responseString = this.getResponseBody();
        String jsonPath = this.getPathExpr(path);
        List<Object> results = this.getPathHelper().getAllJsonPath(responseString, jsonPath);
        return results instanceof ArrayList ? (ArrayList<Object>)results : new ArrayList<Object>(results);
    }

    protected String getResponseBody() {
        String responseString = this.getResponse().getResponse();
        if (StringUtils.isEmpty((CharSequence)responseString)) {
            throw new SlimFixtureException(false, "No response body available");
        }
        return responseString;
    }

    public String allJsonPathMatches(String expr) {
        String result = null;
        ArrayList<Object> allJsonPath = this.listJsonPathMatches(expr);
        if (allJsonPath != null && !allJsonPath.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<div><ul>");
            for (Object e : allJsonPath) {
                sb.append("<li>");
                sb.append(e);
                sb.append("</li>");
            }
            sb.append("</ul></div>");
            result = sb.toString();
        }
        return result;
    }

    public void setJsonPathTo(String path, String value) {
        String jsonStr = this.getResponseBody();
        String jsonPath = this.getPathExpr(path);
        String newResponse = this.getPathHelper().updateJsonPathWithValue(jsonStr, jsonPath, value);
        this.getResponse().setResponse(newResponse);
    }

    public boolean repeatUntilJsonPathIs(final String jsonPath, final Object expectedValue) {
        HttpTest.RepeatLastCall completion = expectedValue == null ? new HttpTest.RepeatLastCall(){

            @Override
            public boolean isFinished() {
                return JsonHttpTest.this.jsonPath(jsonPath) == null;
            }
        } : new HttpTest.RepeatLastCall(){

            @Override
            public boolean isFinished() {
                Object actual = JsonHttpTest.this.jsonPath(jsonPath);
                return this.compareActualToExpected(expectedValue, actual);
            }
        };
        return this.repeatUntil(completion);
    }

    public boolean jsonPathExists(String path) {
        return this.getPathHelper().jsonPathExists(this.getResponseBody(), this.getPathExpr(path));
    }

    protected String getPathExpr(String path) {
        String jsonPath = path;
        if (!path.startsWith("$")) {
            jsonPath = path.startsWith("[") || path.startsWith(".") ? "$" + path : "$." + path;
        }
        return jsonPath;
    }

    protected JsonPathHelper getPathHelper() {
        return this.getEnvironment().getJsonPathHelper();
    }
}

