/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import fitnesse.slim.converters.ConverterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.slim.converter.NumberedListConverter;

public class ListFixture
extends SlimFixture {
    private final ArrayList<Object> list = new ArrayList();

    public void displayListsNumbered() {
        NumberedListConverter.register();
    }

    public void displayListsStandard() {
        ConverterRegistry.resetToStandardConverters();
    }

    public void add(Object value) {
        this.addTo(value, this.list);
    }

    public void setValueAt(Object value, int index) {
        this.setValueAtIn(value, index, this.list);
    }

    public Object valueAt(int index) {
        return this.valueAtIn(index, this.list);
    }

    public int indexOf(Object element) {
        return this.indexOfIn(element, this.list);
    }

    public boolean elementIsPresent(Object element) {
        return this.elementIsPresentIn(element, this.list);
    }

    public ArrayList<Object> copyList() {
        return this.copyList(this.list);
    }

    public void copyValuesFrom(Collection<Object> source) {
        this.copyValuesFromTo(source, this.list);
    }

    public int size() {
        return this.sizeOf(this.list);
    }

    public void addTo(Object value, List aList) {
        Object cleanValue = this.cleanupValue(value);
        aList.add(cleanValue);
    }

    public void setValueAtIn(Object value, int index, List aList) {
        Object cleanValue = this.cleanupValue(value);
        while (aList.size() <= index) {
            aList.add(null);
        }
        aList.set(index, cleanValue);
    }

    public Object valueAtIn(int index, List aList) {
        if (aList.size() > index) {
            return aList.get(index);
        }
        throw new SlimFixtureException(false, "list only has " + aList.size() + " elements");
    }

    public int indexOfIn(Object element, List aList) {
        return aList.indexOf(element);
    }

    public boolean elementIsPresentIn(Object element, List aList) {
        return aList.contains(element);
    }

    public void copyValuesFromTo(Collection<Object> source, List<Object> target) {
        target.addAll(source);
    }

    public ArrayList<Object> copyList(List aList) {
        return new ArrayList<Object>(aList);
    }

    public int sizeOf(List aList) {
        return aList.size();
    }

    public void reset() {
        this.list.clear();
    }

    public void set(int index, Object value) {
        this.setValueAt(value, index);
    }

    public ArrayList<Object> get(String headerName) {
        return this.copyList();
    }
}

