/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import fitnesse.slim.SlimSymbol;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import nl.hsac.fitnesse.fixture.slim.SlimTableFixture;
import org.apache.commons.lang3.StringUtils;

public class MapOfMapsFixture
extends SlimTableFixture {
    private Map<String, Map<String, Object>> maps;

    public MapOfMapsFixture() {
        this(true);
    }

    public MapOfMapsFixture(boolean expandPeriodsInNamesToNestedMaps) {
        this.expandPeriodsInNamesToNestedMaps(expandPeriodsInNamesToNestedMaps);
    }

    @Override
    protected List<List<String>> doTableImpl(List<List<String>> table) {
        int numberOfRows = table.size();
        ArrayList<List<String>> result = new ArrayList<List<String>>(numberOfRows);
        if (!table.isEmpty()) {
            List<String> header = table.get(0);
            int colCount = header.size();
            this.maps = new LinkedHashMap<String, Map<String, Object>>();
            for (List<String> row : table) {
                int rowCounter = result.size();
                ArrayList<String> resultRow = new ArrayList<String>(colCount);
                if (rowCounter == 0) {
                    this.handleHeader(resultRow, header);
                } else if (rowCounter == numberOfRows - 1) {
                    this.handleBottomRow(resultRow, header, row);
                } else {
                    this.handleRow(resultRow, header, row);
                }
                result.add(resultRow);
            }
        }
        return result;
    }

    protected Map<String, Map<String, Object>> getMaps() {
        return this.maps;
    }

    protected void handleHeader(List<String> resultRow, List<String> header) {
        String firstCell = header.get(0);
        for (int i = 1; i < header.size(); ++i) {
            String headerCell = header.get(i);
            LinkedHashMap<String, String> nestedMap = new LinkedHashMap<String, String>();
            this.maps.put(headerCell, nestedMap);
            if (!StringUtils.isNotEmpty((CharSequence)firstCell)) continue;
            nestedMap.put(firstCell, headerCell);
        }
    }

    protected void handleBottomRow(List<String> resultRow, List<String> header, List<String> row) {
        String firstCell = row.get(0);
        if (StringUtils.isEmpty((CharSequence)firstCell)) {
            resultRow.add("");
        } else if (this.assignSymbolIfApplicable(firstCell, this.maps)) {
            resultRow.add("pass");
        }
        if (resultRow.isEmpty()) {
            this.handleRow(resultRow, header, row);
        } else {
            for (int i = 1; i < header.size() && i < row.size(); ++i) {
                String columnName;
                Map<String, Object> map;
                String cell = row.get(i);
                if (this.assignSymbolIfApplicable(cell, map = this.maps.get(columnName = header.get(i)))) {
                    resultRow.add("pass");
                    continue;
                }
                resultRow.add("fail:expected symbol assignment");
            }
        }
    }

    protected void handleRow(List<String> resultRow, List<String> header, List<String> row) {
        String key = null;
        for (int i = 0; i < row.size(); ++i) {
            if (i == 0) {
                key = row.get(i);
                continue;
            }
            String headerCell = header.get(i);
            Map<String, Object> map = this.maps.get(headerCell);
            String cell = row.get(i);
            Object value = cell;
            if (StringUtils.isNotEmpty((CharSequence)cell)) {
                Matcher symbolMatcher = SlimSymbol.SYMBOL_PATTERN.matcher(cell);
                value = symbolMatcher.matches() ? this.getSymbolValue(symbolMatcher) : this.replaceSymbolsInString(cell);
            }
            this.getMapHelper().setValueForIn(value, key, map);
        }
    }
}

