/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.Arrays;
import java.util.List;
import nl.hsac.fitnesse.fixture.slim.MockXmlServerSetup;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;
import org.apache.commons.lang3.StringUtils;

public class MockServerMessageReport
extends SlimFixture {
    private static final String CSS_RED = "diff";
    private static final String CSS_GREEN = "green";
    private final String path;

    public MockServerMessageReport() {
        this("/FitNesseMock");
    }

    public MockServerMessageReport(String aPath) {
        this.path = aPath;
    }

    /*
     * WARNING - void declaration
     */
    public List doTable(List<List<String>> table) {
        List<List<String>> result;
        List<? extends XmlHttpResponse> responses;
        try {
            responses = MockXmlServerSetup.getResponses(this.path);
        }
        catch (SlimFixtureException e) {
            responses = null;
        }
        if (responses == null || responses.isEmpty()) {
            result = this.createResult("ignore", "No requests expected or received at: " + this.path);
        } else {
            void var9_14;
            String header;
            boolean allPass = true;
            int failCounter = 0;
            int counter = 1;
            StringBuilder builder = new StringBuilder("<table><tbody>");
            for (XmlHttpResponse xmlHttpResponse : responses) {
                boolean rowPass = this.addRowForResponse(counter, builder, xmlHttpResponse);
                if (!rowPass) {
                    ++failCounter;
                }
                allPass &= rowPass;
                ++counter;
            }
            builder.append("</tbody></table>");
            int responseCount = responses.size();
            if (allPass) {
                String string = "pass";
                header = String.format("Expected and received %s requests", responseCount);
            } else {
                String string = "fail";
                header = String.format("%s (of %s) request(s) did not match expectation", failCounter, responseCount);
            }
            String resultCell = this.createScenario(!allPass, (String)var9_14, header, builder.toString());
            result = this.createResult("report", resultCell);
        }
        return result;
    }

    protected boolean addRowForResponse(int counter, StringBuilder builder, XmlHttpResponse response) {
        builder.append("<tr>");
        boolean result = this.requestPass(response);
        this.addMessageNoCell(result, builder, counter);
        this.addRequestCell(result, builder, response);
        this.addResponseCell(result, builder, response);
        builder.append("</tr>");
        return result;
    }

    protected void addMessageNoCell(boolean result, StringBuilder builder, int counter) {
        builder.append("<td class=\"");
        builder.append(result ? CSS_GREEN : CSS_RED);
        builder.append("\">");
        builder.append(counter);
        builder.append("</td>");
    }

    protected boolean requestPass(XmlHttpResponse response) {
        return StringUtils.isNotEmpty((CharSequence)response.getResponse()) && StringUtils.isNotEmpty((CharSequence)response.getRequest());
    }

    protected void addRequestCell(boolean result, StringBuilder builder, XmlHttpResponse response) {
        String requestBody = response.getRequest();
        builder.append("<td>");
        if (requestBody == null) {
            builder.append("No request received");
        } else {
            String reqTitle = this.getRequestTitle(response);
            String req = this.formatBody(requestBody);
            builder.append(this.createCollapsible(!result, reqTitle, req));
        }
        builder.append("</td>");
    }

    protected void addResponseCell(boolean result, StringBuilder builder, XmlHttpResponse response) {
        String responseBody = response.getResponse();
        builder.append("<td>");
        if (responseBody == null || "".equals(responseBody)) {
            builder.append("Unexpected request, no response set up");
        } else {
            String respTitle = this.getResponseTitle(response);
            String resp = this.formatBody(responseBody);
            builder.append(this.createCollapsible(false, respTitle, resp));
        }
        builder.append("</td>");
    }

    protected String getRequestTitle(XmlHttpResponse response) {
        return "request";
    }

    protected String getResponseTitle(XmlHttpResponse response) {
        return "response";
    }

    protected String formatBody(String xml) {
        try {
            return this.getEnvironment().getHtmlForXml(xml);
        }
        catch (Exception e) {
            return xml;
        }
    }

    protected List<List<String>> createResult(String status, String result) {
        return Arrays.asList(Arrays.asList(status + ":" + result));
    }

    protected String createScenario(String status, String header, String detail) {
        return this.createScenario("fail".equals(status), status, header, detail);
    }

    protected String createScenario(boolean open, String status, String header, String detail) {
        String scenarioClosed = " closed";
        String detailClosed = " closed-detail";
        if (open) {
            scenarioClosed = "";
            detailClosed = "";
        }
        String cssClass = status.equals("pass") ? CSS_GREEN : CSS_RED;
        return String.format("<table><tbody><tr class=\"scenario%s\"><td class=\"%s\">%s</td></tr><tr class=\"scenario-detail%s\"><td>%s</td></tr></tbody></table>", scenarioClosed, cssClass, header, detailClosed, detail);
    }

    protected String createCollapsible(boolean open, String title, String body) {
        String closed = " closed";
        if (open) {
            closed = "";
        }
        return String.format("<div class=\"collapsible%s\"><p class=\"title\">%s</p><div>%s</div></div>", closed, title, body);
    }
}

