/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.HttpServer;
import nl.hsac.fitnesse.fixture.util.MockXmlHttpResponseSequence;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;

public class MockXmlServerSetup
extends SlimFixture {
    private static final Map<String, HttpServer<? extends MockXmlHttpResponseSequence>> SERVERS = new HashMap<String, HttpServer<? extends MockXmlHttpResponseSequence>>();
    public static final String DEFAULT_PATH = "/FitNesseMock";
    private final String path;
    private final HttpServer<? extends MockXmlHttpResponseSequence> mockServer;

    public static HttpServer<? extends MockXmlHttpResponseSequence> getMockServer(String aPath) {
        HttpServer<? extends MockXmlHttpResponseSequence> server = SERVERS.get(aPath);
        if (server == null) {
            throw new SlimFixtureException(false, "No server created at path: " + aPath);
        }
        return server;
    }

    public static void removeMockServer(String aPath) {
        HttpServer<? extends MockXmlHttpResponseSequence> server = SERVERS.remove(aPath);
        if (server != null) {
            server.stopServer();
        }
    }

    public static List<? extends XmlHttpResponse> getResponses(String aPath) {
        return MockXmlServerSetup.getMockServer(aPath).getResponse().getResponseList();
    }

    public MockXmlServerSetup() {
        this(DEFAULT_PATH);
    }

    public MockXmlServerSetup(String aPath) {
        this(aPath, () -> MockXmlServerSetup.createMockServer(aPath));
    }

    public MockXmlServerSetup(String host, String ports, String aPath) {
        this(aPath, () -> MockXmlServerSetup.createMockServer(host, ports, aPath));
    }

    public MockXmlServerSetup(String aPath, Supplier<HttpServer<? extends MockXmlHttpResponseSequence>> creator) {
        this.path = this.cleanupValue(aPath);
        if (SERVERS.containsKey(this.path)) {
            this.mockServer = MockXmlServerSetup.getMockServer(this.path);
        } else {
            this.mockServer = creator.get();
            SERVERS.put(this.path, this.mockServer);
        }
    }

    public static HttpServer<? extends MockXmlHttpResponseSequence> createMockServer(String host, String ports, String aPath) {
        InetAddress h = MockXmlServerSetup.getInetAddress(host);
        int[] portRange = MockXmlServerSetup.getPortRange(ports);
        return new HttpServer<MockXmlHttpResponseSequence>(h, portRange[0], portRange[1], aPath, MockXmlServerSetup.createResponse());
    }

    public static int[] getPortRange(String ports) {
        int[] portRange;
        String[] portBoundaries = ports.split("-");
        portRange = new int[]{MockXmlServerSetup.parseInt(portBoundaries[0]), portBoundaries.length == 1 ? portRange[0] : MockXmlServerSetup.parseInt(portBoundaries[1])};
        return portRange;
    }

    private static int parseInt(String s) {
        return Integer.parseInt(s.trim());
    }

    public static InetAddress getInetAddress(String host) {
        try {
            return host == null || "null".equalsIgnoreCase(host) ? InetAddress.getLocalHost() : InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new SlimFixtureException(false, "Unable to resolve address: " + host);
        }
    }

    public static HttpServer<? extends MockXmlHttpResponseSequence> createMockServer(String aPath) {
        HttpServer<MockXmlHttpResponseSequence> mockServer;
        MockXmlHttpResponseSequence response = MockXmlServerSetup.createResponse();
        try {
            mockServer = new HttpServer<MockXmlHttpResponseSequence>(InetAddress.getLocalHost(), 8000, 65535, aPath, response);
        }
        catch (RuntimeException | UnknownHostException e) {
            mockServer = new HttpServer<MockXmlHttpResponseSequence>(InetAddress.getLoopbackAddress(), 8000, 65535, aPath, response);
        }
        return mockServer;
    }

    protected static MockXmlHttpResponseSequence createResponse() {
        return new MockXmlHttpResponseSequence();
    }

    public void addResponseFor(String aResponse, String aRequest) {
        this.addResponseImpl(aResponse, aRequest, null);
    }

    public void addResponse(String aResponse) {
        this.addResponseImpl(aResponse, null, null);
    }

    public void addResponseWithStatus(String aResponse, int aStatusCode) {
        XmlHttpResponse response = this.addResponseImpl(aResponse, null, null);
        response.setStatusCode(aStatusCode);
    }

    public void addResponseWithHeaders(String aResponse, Map<String, Object> headers) {
        this.addResponseImpl(aResponse, null, headers);
    }

    public void addResponseWithStatusAndHeaders(String aResponse, int aStatusCode, Map<String, Object> headers) {
        XmlHttpResponse response = this.addResponseImpl(aResponse, null, headers);
        response.setStatusCode(aStatusCode);
    }

    public void addResponseFile(String aResponseFile) {
        String fileContent = this.loadResponseFromFile(aResponseFile);
        this.addResponse(fileContent);
    }

    public void addResponseFileWithStatus(String aResponseFile, int aStatusCode) {
        String fileContent = this.loadResponseFromFile(aResponseFile);
        this.addResponseWithStatus(fileContent, aStatusCode);
    }

    protected String loadResponseFromFile(String aResponseFile) {
        String fileContent;
        String filePath = this.getFilePathFromWikiUrl(aResponseFile);
        try {
            fileContent = MockXmlServerSetup.readFile(filePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            fileContent = "Response file not found for: " + aResponseFile;
        }
        return fileContent;
    }

    protected XmlHttpResponse addResponseImpl(String aResponse, String aRequest, Map<String, Object> headers) {
        String responseBody = this.cleanupBody(aResponse);
        String request = this.cleanupValue(aRequest);
        XmlHttpResponse response = this.getResponse().addResponse(responseBody, request);
        if (headers != null) {
            response.getResponseHeaders().putAll(headers);
        }
        return response;
    }

    protected String cleanupBody(String body) {
        return this.getEnvironment().getHtmlCleaner().cleanupPreFormatted(body);
    }

    public String getMockServerUrl() {
        return this.mockServer.getURL();
    }

    public boolean verifyAllResponsesServed() {
        String not = this.getResponse().getMissingRequestsMessage();
        if (not != null) {
            throw new SlimFixtureException(false, not);
        }
        return true;
    }

    public boolean verifyNoExtraRequests() {
        String extra = this.getResponse().getExtraRequestsMessage();
        if (extra != null) {
            throw new SlimFixtureException(false, extra);
        }
        return true;
    }

    public void stop() {
        MockXmlServerSetup.removeMockServer(this.path);
    }

    protected List<? extends XmlHttpResponse> getResponseList() {
        return this.getResponse().getResponseList();
    }

    protected MockXmlHttpResponseSequence getResponse() {
        return this.mockServer.getResponse();
    }

    protected static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

