/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.internal.runtime.ECMAException;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureWithMap;

public class ScriptLanguageFixture
extends SlimFixtureWithMap {
    private static final ScriptEngineManager ENGINE_MANAGER = new ScriptEngineManager();
    private ScriptEngine engine;

    public ScriptLanguageFixture() {
        this("JavaScript");
    }

    public ScriptLanguageFixture(String shortName) {
        this.setEngine(shortName);
    }

    public Object evaluate(String expression) {
        expression = this.cleanupValue(expression);
        this.putAllValues();
        try {
            return this.getEngine().eval(expression);
        }
        catch (ScriptException e) {
            throw this.getExceptionToThrow(e);
        }
    }

    public Object invokeFunction(String functionName) {
        return this.invokeFunctionWithArguments(functionName, new Object[0]);
    }

    public Object invokeFunctionWithArgument(String functionName, Object argument) {
        return this.invokeFunctionWithArguments(functionName, argument);
    }

    public Object invokeFunctionWithArguments(String functionName, Object ... arguments) {
        this.putAllValues();
        try {
            return ((Invocable)((Object)this.getEngine())).invokeFunction(functionName, arguments);
        }
        catch (ScriptException e) {
            throw this.getExceptionToThrow(e);
        }
        catch (NoSuchMethodException e) {
            throw new SlimFixtureException(false, "No function found for this name and these arguments", e);
        }
    }

    public Object invokeMethodOn(String methodName, Object obj) {
        return this.invokeMethodOnWithArguments(methodName, obj, new Object[0]);
    }

    public Object invokeMethodOnWithArgument(String methodName, Object obj, Object argument) {
        return this.invokeMethodOnWithArguments(methodName, obj, argument);
    }

    public Object invokeMethodOnWithArguments(String methodName, Object obj, Object ... arguments) {
        if (obj instanceof String) {
            Object o = this.value((String)obj);
            if (o == null) {
                throw new SlimFixtureException(false, "No object found called: " + obj);
            }
            obj = o;
        }
        this.putAllValues();
        try {
            return ((Invocable)((Object)this.getEngine())).invokeMethod(obj, methodName, arguments);
        }
        catch (ScriptException e) {
            throw this.getExceptionToThrow(e);
        }
        catch (NoSuchMethodException e) {
            throw new SlimFixtureException(false, "No method found for this name and these arguments", e);
        }
        catch (IllegalArgumentException e) {
            throw new SlimFixtureException(false, obj + " is not a valid object to call a method on", e);
        }
    }

    @Override
    public Object value(String key) {
        Bindings context = this.getEngine().getBindings(100);
        return this.getMapHelper().getValue(context, key);
    }

    @Override
    public boolean clearValue(String name) {
        this.getEngine().put(name, null);
        return super.clearValue(name);
    }

    @Override
    public void clearValues() {
        ScriptEngine e = this.getEngine();
        e.setBindings(e.createBindings(), 100);
        super.clearValues();
    }

    public Object get(String headerName) {
        return this.value(headerName);
    }

    public void setEngine(String shortName) {
        this.engine = ENGINE_MANAGER.getEngineByName(shortName);
    }

    protected ScriptEngine getEngine() {
        return this.engine;
    }

    public Map<String, Map<String, Object>> availableEngines() {
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        List<ScriptEngineFactory> factories = ENGINE_MANAGER.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            LinkedHashMap<String, Object> f = new LinkedHashMap<String, Object>();
            String engName = factory.getEngineName();
            String engVersion = factory.getEngineVersion();
            List<String> engNames = factory.getNames();
            String langName = factory.getLanguageName();
            String langVersion = factory.getLanguageVersion();
            result.put(engName, f);
            f.put("language name", langName);
            f.put("language version", langVersion);
            f.put("aliases", engNames);
            f.put("version", engVersion);
        }
        return result;
    }

    protected RuntimeException getExceptionToThrow(ScriptException e) {
        Throwable cause = e.getCause();
        String message = cause instanceof ECMAException ? cause.toString() : e.getMessage();
        return new SlimFixtureException(false, message, e);
    }

    protected void putAllValues() {
        ScriptEngine e = this.getEngine();
        this.getCurrentValues().forEach((k, v) -> e.put((String)k, v));
    }
}

