/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import fit.exception.FitFailureException;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import fitnesse.slim.fixtureInteraction.InteractionAwareFixture;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import nl.hsac.fitnesse.slim.interaction.ExceptionHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlimFixture
implements InteractionAwareFixture {
    protected final Logger logger;
    private Environment environment = Environment.getInstance();
    private int repeatInterval = 100;
    private int repeatMaxCount = 30000;
    private StopWatch repeatTimer = new StopWatch();
    private int repeatCount = 0;
    private long repeatTime = 0L;
    protected final String filesDir = this.getEnvironment().getFitNesseFilesSectionDir();

    public SlimFixture() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public Object aroundSlimInvoke(FixtureInteraction interaction, Method method, Object ... arguments) throws InvocationTargetException, IllegalAccessException {
        Object result;
        try {
            this.beforeInvoke(method, arguments);
            result = this.invoke(interaction, method, arguments);
        }
        catch (Throwable t) {
            Throwable realEx = ExceptionHelper.stripReflectionException(t);
            Throwable toThrow = this.handleException(method, arguments, realEx);
            if (toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            if (toThrow instanceof Error) {
                throw (Error)toThrow;
            }
            throw ExceptionHelper.wrapInReflectionException(toThrow);
        }
        result = this.afterCompletion(method, arguments, result);
        return result;
    }

    protected void beforeInvoke(Method method, Object[] arguments) {
    }

    protected Object invoke(FixtureInteraction interaction, Method method, Object[] arguments) throws Throwable {
        return interaction.methodInvoke(method, (Object)this, arguments);
    }

    protected Throwable handleException(Method method, Object[] arguments, Throwable t) {
        if (t instanceof FitFailureException) {
            String m = t.getMessage();
            t = new SlimFixtureException(false, "<div>" + m + "</div>");
        }
        return t;
    }

    protected Object afterCompletion(Method method, Object[] arguments, Object result) {
        return result;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected String getUrl(String htmlLink) {
        return this.getEnvironment().getHtmlCleaner().getUrl(htmlLink);
    }

    public void setGlobalValueTo(String symbolName, String value) {
        this.getEnvironment().setSymbol(symbolName, value);
    }

    public String globalValue(String symbolName) {
        return this.getEnvironment().getSymbol(symbolName);
    }

    protected <T> T cleanupValue(T rawValue) {
        return this.getEnvironment().getHtmlCleaner().cleanupValue(rawValue);
    }

    public boolean waitSeconds(int i) {
        return this.waitMilliseconds(i * 1000);
    }

    public boolean waitMilliseconds(int i) {
        boolean result;
        try {
            Thread.sleep(i);
            result = true;
        }
        catch (InterruptedException e) {
            result = false;
        }
        return result;
    }

    public void setRepeatIntervalToMilliseconds(int milliseconds) {
        this.repeatInterval = milliseconds;
    }

    public long repeatInterval() {
        return this.repeatInterval;
    }

    public void repeatAtMostTimes(int maxCount) {
        this.repeatMaxCount = maxCount;
    }

    public int repeatAtMostTimes() {
        return this.repeatMaxCount;
    }

    public int repeatCount() {
        return this.repeatCount;
    }

    public long timeSpentRepeating() {
        return this.repeatTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean repeatUntil(RepeatCompletion repeat) {
        this.repeatTime = 0L;
        this.repeatTimer.start();
        StopWatch loopTimer = new StopWatch();
        loopTimer.start();
        boolean result = false;
        try {
            try {
                result = repeat.isFinished();
            }
            catch (RuntimeException e) {
                this.logger.warn("Error while checking we can stop repeating before starting loop", (Throwable)e);
            }
            this.repeatCount = 0;
            while (!result && this.repeatCount < this.repeatMaxCount) {
                int nextInterval = this.getNextInterval(loopTimer);
                this.waitMilliseconds(nextInterval);
                loopTimer.start();
                repeat.repeat();
                try {
                    result = repeat.isFinished();
                }
                catch (RuntimeException e) {
                    this.logger.warn("Error while checking whether we can stop repeating, loop count {} of {}", new Object[]{this.repeatCount, this.repeatMaxCount, e});
                }
                ++this.repeatCount;
            }
        }
        finally {
            this.repeatTime = this.repeatTimer.getTime();
            this.repeatTimer.reset();
        }
        return result;
    }

    private int getNextInterval(StopWatch loopTimer) {
        long loopTime = loopTimer.getTime();
        int nextInterval = Math.max(0, (int)((long)this.repeatInterval - loopTime));
        loopTimer.reset();
        return nextInterval;
    }

    protected boolean repeatUntilNot(RepeatCompletion repeat) {
        return this.repeatUntil(new Negate(repeat));
    }

    protected String createFile(String dir, String fileName, byte[] content) {
        String baseName = FilenameUtils.getBaseName((String)fileName);
        String ext = FilenameUtils.getExtension((String)fileName);
        String downloadedFile = FileUtil.saveToFile(dir + baseName, ext, content);
        return this.linkToFile(downloadedFile);
    }

    protected String getWikiUrl(String filePath) {
        return this.getEnvironment().getWikiUrl(filePath);
    }

    protected String linkToFile(String f) {
        return this.linkToFile(new File(f));
    }

    protected String linkToFile(File f) {
        String url = this.getWikiUrl(f.getAbsolutePath());
        if (url == null) {
            url = f.toURI().toString();
        }
        return String.format("<a href=\"%s\" target=\"_blank\">%s</a>", url, f.getName());
    }

    protected String getFilePathFromWikiUrl(String wikiUrl) {
        return this.getEnvironment().getFilePathFromWikiUrl(wikiUrl);
    }

    public static class FunctionalCompletion
    implements RepeatCompletion {
        private Supplier<Boolean> isFinishedSupplier;
        private Runnable repeater;

        public FunctionalCompletion() {
        }

        public FunctionalCompletion(Supplier<Boolean> isFinishedSupplier) {
            this(isFinishedSupplier, null);
        }

        public FunctionalCompletion(Supplier<Boolean> isFinishedSupplier, Runnable repeater) {
            this.setIsFinishedSupplier(isFinishedSupplier);
            this.setRepeater(repeater);
        }

        @Override
        public boolean isFinished() {
            return Boolean.TRUE.equals(this.isFinishedSupplier.get());
        }

        @Override
        public void repeat() {
            if (this.repeater != null) {
                this.repeater.run();
            }
        }

        public void setIsFinishedSupplier(Supplier<Boolean> isFinishedSupplier) {
            this.isFinishedSupplier = isFinishedSupplier;
        }

        public void setRepeater(Runnable repeater) {
            this.repeater = repeater;
        }
    }

    public class Negate
    implements RepeatCompletion {
        private final RepeatCompletion nested;

        public Negate(RepeatCompletion nested) {
            this.nested = nested;
        }

        @Override
        public boolean isFinished() {
            return !this.nested.isFinished();
        }

        @Override
        public void repeat() {
            this.nested.repeat();
        }
    }

    public static interface RepeatCompletion {
        public boolean isFinished();

        public void repeat();
    }
}

