/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.hsac.fitnesse.fixture.slim.Base64Fixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureWithMapHelper;
import org.apache.commons.io.IOUtils;

public class SlimFixtureWithMap
extends SlimFixtureWithMapHelper {
    private final Map<String, Object> currentValues;

    public SlimFixtureWithMap() {
        this(new LinkedHashMap<String, Object>());
    }

    public SlimFixtureWithMap(Map<String, Object> map) {
        this.currentValues = map;
    }

    public void setIntValueFor(int value, String name) {
        this.setValueFor(value, name);
    }

    public void setDoubleValueFor(double value, String name) {
        this.setValueFor(value, name);
    }

    public void setBooleanValueFor(boolean value, String name) {
        this.setValueFor(value, name);
    }

    public void setValueFor(Object value, String name) {
        this.getMapHelper().setValueForIn(value, name, this.getCurrentValues());
    }

    public void addValueTo(Object value, String name) {
        this.getMapHelper().addValueToIn(value, name, this.getCurrentValues());
    }

    public void copyValuesFrom(Map<String, Object> map) {
        this.getMapHelper().copyValuesFromTo(map, this.getCurrentValues());
    }

    public void setValuesFor(String values, String name) {
        this.getMapHelper().setValuesForIn(values, name, this.getCurrentValues());
    }

    public void setContentOfAsValueFor(String file, String key) {
        String filePath = this.getFilePathFromWikiUrl(file);
        try {
            byte[] content = IOUtils.toByteArray((InputStream)new FileInputStream(filePath));
            this.setValueFor(content, key);
        }
        catch (IOException e) {
            throw new SlimFixtureException("Unable to read: " + filePath, e);
        }
    }

    public void setBase64EncodedContentOfAsValueFor(String file, String key) {
        Base64Fixture base64Fixture = this.getBase64Fixture();
        String base64 = base64Fixture.encode(file);
        this.setValueFor(base64, key);
    }

    protected Base64Fixture getBase64Fixture() {
        return new Base64Fixture();
    }

    public boolean clearValue(String name) {
        String cleanName = this.cleanupValue(name);
        boolean result = this.getCurrentValues().containsKey(cleanName);
        this.getCurrentValues().remove(cleanName);
        return result;
    }

    public void clearValues() {
        this.getCurrentValues().clear();
    }

    protected Map<String, Object> getCurrentValues() {
        return this.currentValues;
    }

    public Object value(String name) {
        return this.getMapHelper().getValue(this.getCurrentValues(), name);
    }

    public void reset() {
        this.clearValues();
    }

    public void set(String key, Object value) {
        this.setValueFor(value, key);
    }
}

