/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import org.apache.commons.lang3.StringUtils;

public class StringFixture
extends SlimFixture {
    public String valueOf(String value) {
        return value;
    }

    public int lengthOf(String value) {
        int length = 0;
        if (value != null) {
            length = value.length();
        }
        return length;
    }

    public boolean valueDiffersFrom(String value1, String value2) {
        return !this.valueEquals(value1, value2);
    }

    public boolean valueEquals(String value1, String value2) {
        return StringUtils.equals((CharSequence)value1, (CharSequence)value2);
    }

    public boolean textContains(String value, String expectedSubstring) {
        boolean result = false;
        if (value != null) {
            result = value.contains(expectedSubstring);
        }
        return result;
    }

    public String convertToUpperCase(String value) {
        String result = null;
        if (value != null) {
            result = value.toUpperCase();
        }
        return result;
    }

    public String convertToLowerCase(String value) {
        String result = null;
        if (value != null) {
            result = value.toLowerCase();
        }
        return result;
    }

    public Integer convertToInt(String value) {
        Integer result = null;
        if (value != null) {
            result = Integer.valueOf(value);
        }
        return result;
    }

    public Double convertToDouble(String value) {
        Double result = null;
        if (value != null) {
            result = Double.valueOf(value);
        }
        return result;
    }

    public String removeWhitespace(String value) {
        String result = null;
        if (value != null) {
            result = this.replaceAllInWith("\\s+", value, "");
        }
        return result;
    }

    public String normalizeWhitespace(String value) {
        String result = null;
        if (value != null) {
            value = value.trim();
            result = this.replaceAllInWith("\\s+", value, " ");
        }
        return result;
    }

    public String replaceAllInWith(String regEx, String value, String replace) {
        String result = null;
        if (value != null) {
            if (replace == null) {
                replace = "";
            }
            result = this.getMatcher(regEx, value).replaceAll(replace);
        }
        return result;
    }

    public Integer extractIntFromUsingGroup(String value, String regEx, int groupIndex) {
        Matcher matcher;
        Integer result = null;
        if (value != null && (matcher = this.getMatcher(regEx, value)).matches()) {
            String intStr = matcher.group(groupIndex);
            result = this.convertToInt(intStr);
        }
        return result;
    }

    protected Matcher getMatcher(String regEx, String value) {
        return Pattern.compile(regEx, 32).matcher(value);
    }

    public String convertLineEndingsToWindows(String input) {
        return this.getEnvironment().getLineEndingHelper().convertEndingsTo(input, "\r\n");
    }

    public String convertLineEndingsToUnix(String input) {
        return this.getEnvironment().getLineEndingHelper().convertEndingsTo(input, "\n");
    }
}

