/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import org.apache.commons.lang3.time.StopWatch;

public class TimerFixture
extends SlimFixture {
    private static final Map<String, StopWatch> STOP_WATCHES = new LinkedHashMap<String, StopWatch>();
    private static final String DEFAULT_STOP_WATCH = "default";

    public void startTimer() {
        this.startTimer(DEFAULT_STOP_WATCH);
    }

    public void startTimer(String name) {
        StopWatch sw = new StopWatch();
        sw.start();
        STOP_WATCHES.put(name, sw);
    }

    public long stopTimer() {
        return this.stopTimer(DEFAULT_STOP_WATCH);
    }

    public long stopTimer(String name) {
        StopWatch sw = this.getStopWatch(name);
        sw.stop();
        STOP_WATCHES.remove(name);
        return sw.getTime();
    }

    public long timeOnTimer() {
        return this.timeOnTimer(DEFAULT_STOP_WATCH);
    }

    public long timeOnTimer(String name) {
        return this.getStopWatch(name).getTime();
    }

    public long pauseTimer() {
        return this.pauseTimer(DEFAULT_STOP_WATCH);
    }

    public long pauseTimer(String name) {
        StopWatch sw = this.getStopWatch(name);
        sw.suspend();
        return sw.getTime();
    }

    public void resumeTimer() {
        this.resumeTimer(DEFAULT_STOP_WATCH);
    }

    public void resumeTimer(String name) {
        StopWatch sw = this.getStopWatch(name);
        sw.resume();
    }

    public Map<String, Long> allTimerTimes() {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (Map.Entry<String, StopWatch> entry : STOP_WATCHES.entrySet()) {
            String key = entry.getKey();
            long time = entry.getValue().getTime();
            result.put(key, time);
        }
        return result;
    }

    public Map<String, Long> stopAllTimers() {
        Map<String, Long> result = this.allTimerTimes();
        STOP_WATCHES.clear();
        return result;
    }

    protected StopWatch getStopWatch(String name) {
        StopWatch stopWatch = STOP_WATCHES.get(name);
        if (stopWatch == null) {
            throw new SlimFixtureException(false, "No timer found with name: " + name);
        }
        return stopWatch;
    }

    public String currentSystemTime() {
        return this.currentSystemTimeAs("HH:mm:ss.SSS");
    }

    public String currentSystemTimeAs(String format) {
        Locale locale = Locale.getDefault();
        return this.formatCurrentSystemTime(format, locale);
    }

    public String currentSystemTimeAsIn(String format, String languageTag) {
        Locale locale = Locale.forLanguageTag(languageTag);
        return this.formatCurrentSystemTime(format, locale);
    }

    private String formatCurrentSystemTime(String format, Locale locale) {
        Date now = new Date();
        try {
            return new SimpleDateFormat(format, locale).format(now);
        }
        catch (IllegalArgumentException e) {
            throw new SlimFixtureException(false, "Bad date format: " + format);
        }
    }
}

