/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import nl.hsac.fitnesse.fixture.slim.Base64Fixture;
import nl.hsac.fitnesse.fixture.slim.FileFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.XMLValidator;
import nl.hsac.fitnesse.fixture.util.XPathHelper;
import org.apache.commons.lang3.StringUtils;

public class XmlFixture
extends SlimFixture {
    private NamespaceContext namespaceContext = this.getEnvironment().getNamespaceContext();
    private XPathHelper xPathHelper = this.getEnvironment().getXPathHelper();
    private String content;

    public boolean loadFile(String filename) {
        this.content = this.getFileFixture().textIn(filename);
        return true;
    }

    public boolean load(String xml) {
        this.content = this.cleanupValue(xml);
        return true;
    }

    public String document() {
        String formatted = this.content;
        if (this.content != null && this.content.trim().startsWith("<")) {
            formatted = this.getEnvironment().getHtmlForXml(this.content);
        }
        return formatted;
    }

    public void registerPrefixForNamespace(String prefix, String namespace) {
        this.getEnvironment().registerNamespace(prefix, this.getUrl(namespace));
    }

    public String xPath(String xPathExpr) {
        String xPathValue = this.xPathHelper.getXPath(this.namespaceContext, this.content, xPathExpr);
        if ("".equals(xPathValue)) {
            xPathValue = null;
        }
        return xPathValue;
    }

    public ArrayList<String> listXPathMatches(String xPathExpr) {
        List<String> results = this.xPathHelper.getAllXPath(this.namespaceContext, this.content, xPathExpr);
        return results instanceof ArrayList ? (ArrayList<Object>)results : new ArrayList<String>(results);
    }

    public String createFileFromBase64ContentOf(String baseName, String xPath) {
        String base64Content = this.xPath(xPath);
        if (StringUtils.isEmpty((CharSequence)base64Content)) {
            throw new SlimFixtureException(false, "No content from xPath: " + xPath);
        }
        return this.createFileFromBase64(baseName, base64Content);
    }

    public boolean validateAgainstXsdFile(String xsdFileName) {
        String xsdContent = new FileFixture().textIn(xsdFileName);
        return new XMLValidator().validateAgainst(this.content, xsdContent);
    }

    public boolean validateAgainstXsd(String xsdSchema) {
        String xsdContent = this.cleanupValue(xsdSchema);
        return new XMLValidator().validateAgainst(this.content, xsdContent);
    }

    protected String getContent() {
        return this.content;
    }

    protected String createFileFromBase64(String baseName, String base64Content) {
        Base64Fixture base64Fixture = this.getBase64Fixture();
        return base64Fixture.createFrom(baseName, base64Content);
    }

    protected Base64Fixture getBase64Fixture() {
        return new Base64Fixture();
    }

    protected FileFixture getFileFixture() {
        return new FileFixture();
    }
}

