/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.ArrayList;
import java.util.List;
import nl.hsac.fitnesse.fixture.slim.FileFixture;
import nl.hsac.fitnesse.fixture.slim.HttpTest;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.XMLValidator;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;
import org.apache.commons.lang3.StringUtils;

public class XmlHttpTest
extends HttpTest {
    public XmlHttpTest() {
        this.setContentType("text/xml; charset=UTF-8");
    }

    public void registerPrefixForNamespace(String prefix, String namespace) {
        this.getEnvironment().registerNamespace(prefix, this.getUrl(namespace));
    }

    @Override
    protected String formatValue(String value) {
        String formatted = super.formatValue(value);
        if (value != null && value.trim().startsWith("<")) {
            formatted = this.getEnvironment().getHtmlForXml(value);
        }
        return formatted;
    }

    public String allXPathMatches(String xPathExpr) {
        String result = null;
        ArrayList<String> allXPath = this.listXPathMatches(xPathExpr);
        if (allXPath != null && !allXPath.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<div><ul>");
            for (String match : allXPath) {
                sb.append("<li>");
                sb.append(match);
                sb.append("</li>");
            }
            sb.append("</ul></div>");
            result = sb.toString();
        }
        return result;
    }

    public ArrayList<String> listXPathMatches(String xPathExpr) {
        List<String> results = this.getResponse().getAllXPath(xPathExpr, new Object[0]);
        return results instanceof ArrayList ? (ArrayList<Object>)results : new ArrayList<String>(results);
    }

    public String rawXPath(String xPathExpr) {
        return this.getResponse().getRawXPath(xPathExpr, new Object[0]);
    }

    public String xPath(String xPathExpr) {
        return this.getResponse().getXPath(xPathExpr, new Object[0]);
    }

    public Double xPathDouble(String xPathExpr) {
        return this.getResponse().getXPathDouble(xPathExpr, new Object[0]);
    }

    public Double xPathInt(String xPathExpr) {
        return this.getResponse().getXPathDouble(xPathExpr, new Object[0]);
    }

    public String createFileFromBase64ContentOf(String baseName, String xPath) {
        String base64Content = this.xPath(xPath);
        if (StringUtils.isEmpty((CharSequence)base64Content)) {
            throw new SlimFixtureException(false, "No content from xPath: " + xPath);
        }
        return this.createFileFromBase64(baseName, base64Content);
    }

    public boolean validateResponseAgainstXsdFile(String xsdFileName) {
        String xsdContent = new FileFixture().textIn(xsdFileName);
        return new XMLValidator().validateAgainst(this.getResponse().getResponse(), xsdContent);
    }

    public boolean validateResponseAgainstXsd(String xsdSchema) {
        String xsdContent = this.cleanupValue(xsdSchema);
        return new XMLValidator().validateAgainst(this.getResponse().getResponse(), xsdContent);
    }

    @Override
    protected boolean postProcessResponse() {
        this.getEnvironment().setContext(this.getResponse());
        boolean result = super.postProcessResponse();
        return result;
    }

    public boolean repeatUntilXPathIs(final String xPath, final String expectedValue) {
        HttpTest.RepeatLastCall completion = expectedValue == null ? new HttpTest.RepeatLastCall(){

            @Override
            public boolean isFinished() {
                return XmlHttpTest.this.xPath(xPath) == null;
            }
        } : new HttpTest.RepeatLastCall(){

            @Override
            public boolean isFinished() {
                String actual = XmlHttpTest.this.xPath(xPath);
                return this.compareActualToExpected(expectedValue, actual);
            }
        };
        return this.repeatUntil(completion);
    }

    @Override
    public XmlHttpResponse getResponse() {
        return (XmlHttpResponse)super.getResponse();
    }

    @Override
    protected XmlHttpResponse createResponse() {
        return new XmlHttpResponse();
    }
}

