/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim;

import java.util.Map;
import nl.hsac.fitnesse.fixture.slim.ValuesFileFixture;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFileFixture
extends ValuesFileFixture {
    private final Yaml yaml = new Yaml();

    @Override
    public boolean loadValuesFrom(String filename) {
        String yamlStr = this.textIn(filename);
        Object y = this.yaml.load(yamlStr);
        if (y instanceof Map) {
            this.getCurrentValues().putAll((Map)y);
        } else {
            this.getCurrentValues().put("elements", y);
        }
        return true;
    }

    @Override
    protected String createContaining(String filename, Map<String, Object> map) {
        String yamlStr = this.yaml.dumpAsMap(map);
        return this.createContaining(filename, yamlStr);
    }

    @Override
    public String createContaining(String filename, Object data) {
        String file;
        if (data instanceof Map || data instanceof byte[] || data instanceof String) {
            file = this.valuesFileCreateContaining(filename, data);
        } else {
            String yamlStr = this.yaml.dumpAs(data, null, DumperOptions.FlowStyle.BLOCK);
            file = this.createContaining(filename, yamlStr);
        }
        return file;
    }

    protected String valuesFileCreateContaining(String filename, Object data) {
        return super.createContaining(filename, data);
    }

    @Override
    public String createContainingBase64Value(String filename, String key) {
        String file;
        Object value = this.value(key);
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            file = this.createContaining(filename, bytes);
        } else {
            file = super.createContainingBase64Value(filename, key);
        }
        return file;
    }
}

