/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim.web;

import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.fixture.slim.HttpTest;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.slim.StopTestException;
import nl.hsac.fitnesse.fixture.slim.web.NgBrowserTest;
import nl.hsac.fitnesse.fixture.slim.web.TimeoutStopTestException;
import nl.hsac.fitnesse.fixture.slim.web.annotation.TimeoutPolicy;
import nl.hsac.fitnesse.fixture.slim.web.annotation.WaitUntil;
import nl.hsac.fitnesse.fixture.util.ReflectionHelper;
import nl.hsac.fitnesse.fixture.util.selenium.AllFramesDecorator;
import nl.hsac.fitnesse.fixture.util.selenium.PageSourceSaver;
import nl.hsac.fitnesse.fixture.util.selenium.SelectHelper;
import nl.hsac.fitnesse.fixture.util.selenium.SeleniumHelper;
import nl.hsac.fitnesse.fixture.util.selenium.StaleContextException;
import nl.hsac.fitnesse.fixture.util.selenium.by.AltBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.ContainerBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.GridBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.ListItemBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.OptionBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.SingleElementOrNullBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.XPathBy;
import nl.hsac.fitnesse.slim.interaction.ExceptionHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class BrowserTest<T extends WebElement>
extends SlimFixture {
    private final List<String> currentSearchContextPath = new ArrayList<String>();
    private SeleniumHelper<T> seleniumHelper = this.getEnvironment().getSeleniumHelper();
    private ReflectionHelper reflectionHelper = this.getEnvironment().getReflectionHelper();
    private NgBrowserTest ngBrowserTest;
    private boolean implicitWaitForAngular = false;
    private boolean implicitFindInFrames = true;
    private boolean scrollElementToCenter = false;
    private int secondsBeforeTimeout;
    private int secondsBeforePageLoadTimeout;
    private int waitAfterScroll = 150;
    private String screenshotBase = new File(this.filesDir, "screenshots").getPath() + "/";
    private String screenshotHeight = "200";
    private String pageSourceBase = new File(this.filesDir, "pagesources").getPath() + "/";
    private boolean sendCommandForControlOnMac = false;
    private boolean trimOnNormalize = true;
    private static final String CHROME_HIDDEN_BY_OTHER_ELEMENT_ERROR = "Other element would receive the click";
    private static final String EDGE_HIDDEN_BY_OTHER_ELEMENT_ERROR = "Element is obscured";
    private static final Pattern FIREFOX_HIDDEN_BY_OTHER_ELEMENT_ERROR_PATTERN = Pattern.compile("Element.+is not clickable.+because another element.+obscures it");
    protected int minStaleContextRefreshCount = 5;

    protected List<String> getCurrentSearchContextPath() {
        return this.currentSearchContextPath;
    }

    @Override
    protected void beforeInvoke(Method method, Object[] arguments) {
        super.beforeInvoke(method, arguments);
        this.waitForAngularIfNeeded(method);
    }

    @Override
    protected Object invoke(FixtureInteraction interaction, Method method, Object[] arguments) throws Throwable {
        try {
            WaitUntil waitUntil = this.reflectionHelper.getAnnotation(WaitUntil.class, method);
            Object result = waitUntil == null ? this.superInvoke(interaction, method, arguments) : this.invokedWrappedInWaitUntil(waitUntil, interaction, method, arguments);
            return result;
        }
        catch (StaleContextException e) {
            if (this.getCurrentSearchContextPath().isEmpty()) {
                throw e;
            }
            this.refreshSearchContext();
            return this.invoke(interaction, method, arguments);
        }
    }

    protected Object invokedWrappedInWaitUntil(WaitUntil waitUntil, FixtureInteraction interaction, Method method, Object[] arguments) {
        Object result;
        ExpectedCondition<T> condition = webDriver -> {
            try {
                return this.superInvoke(interaction, method, arguments);
            }
            catch (Throwable e) {
                Throwable realEx = ExceptionHelper.stripReflectionException(e);
                if (realEx instanceof RuntimeException) {
                    throw (RuntimeException)realEx;
                }
                if (realEx instanceof Error) {
                    throw (Error)realEx;
                }
                throw new RuntimeException(realEx);
            }
        };
        condition = this.wrapConditionForFramesIfNeeded(condition);
        switch (waitUntil.value()) {
            case STOP_TEST: {
                result = this.waitUntilOrStop(condition);
                break;
            }
            case RETURN_NULL: {
                result = this.waitUntilOrNull(condition);
                break;
            }
            case RETURN_FALSE: {
                result = this.waitUntilOrNull(condition) != null;
                break;
            }
            default: {
                result = this.waitUntil(condition);
            }
        }
        return result;
    }

    protected Object superInvoke(FixtureInteraction interaction, Method method, Object[] arguments) throws Throwable {
        return super.invoke(interaction, method, arguments);
    }

    protected void waitForAngularIfNeeded(Method method) {
        if (this.isImplicitWaitForAngularEnabled()) {
            try {
                if (this.ngBrowserTest == null) {
                    this.ngBrowserTest = new NgBrowserTest(this.secondsBeforeTimeout());
                    this.ngBrowserTest.secondsBeforePageLoadTimeout(this.secondsBeforePageLoadTimeout());
                }
                if (this.ngBrowserTest.requiresWaitForAngular(method) && this.currentSiteUsesAngular()) {
                    try {
                        this.ngBrowserTest.waitForAngularRequestsToFinish();
                    }
                    catch (Exception e) {
                        System.err.print("Found Angular, but encountered an error while waiting for it to be ready. ");
                        e.printStackTrace();
                    }
                }
            }
            catch (UnhandledAlertException e) {
                System.err.println("Cannot determine whether Angular is present while alert is active.");
            }
            catch (Exception e) {
                System.err.print("Error while determining whether Angular is present. ");
                e.printStackTrace();
            }
        }
    }

    protected boolean currentSiteUsesAngular() {
        Object windowHasAngular = this.getSeleniumHelper().executeJavascript("return window.angular?1:0;", new Object[0]);
        return Long.valueOf(1L).equals(windowHasAngular);
    }

    @Override
    protected Throwable handleException(Method method, Object[] arguments, Throwable t) {
        Throwable result;
        if (t instanceof UnhandledAlertException) {
            UnhandledAlertException e = (UnhandledAlertException)t;
            String alertText = e.getAlertText();
            if (alertText == null) {
                alertText = this.alertText();
            }
            String msgBase = "Unhandled alert: alert must be confirmed or dismissed before test can continue. Alert text: " + alertText;
            String msg = this.getSlimFixtureExceptionMessage("alertException", msgBase, e);
            result = new StopTestException(false, msg, t);
        } else if (t instanceof SlimFixtureException) {
            result = super.handleException(method, arguments, t);
        } else {
            String msg = this.getSlimFixtureExceptionMessage("exception", null, t);
            result = new SlimFixtureException(false, msg, t);
        }
        return result;
    }

    public BrowserTest() {
        this.secondsBeforeTimeout(this.getEnvironment().getSeleniumDriverManager().getDefaultTimeoutSeconds());
        if (!this.ensureActiveTabIsNotClosed()) {
            this.confirmAlertIfAvailable();
        }
    }

    public BrowserTest(int secondsBeforeTimeout) {
        this(secondsBeforeTimeout, true);
    }

    public BrowserTest(int secondsBeforeTimeout, boolean confirmAlertIfAvailable) {
        this.secondsBeforeTimeout(secondsBeforeTimeout);
        if (!this.ensureActiveTabIsNotClosed() && confirmAlertIfAvailable) {
            this.confirmAlertIfAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(String address) {
        String url = this.getUrl(address);
        try {
            this.getNavigation().to(url);
        }
        catch (TimeoutException e) {
            this.handleTimeoutException(e);
        }
        finally {
            this.switchToDefaultContent();
        }
        this.waitUntil(webDriver -> {
            boolean done;
            String readyState = this.getSeleniumHelper().executeJavascript("return document.readyState", new Object[0]).toString();
            boolean bl = done = "complete".equalsIgnoreCase(readyState) || "loaded".equalsIgnoreCase(readyState);
            if (!done) {
                System.err.printf("Open of %s returned while document.readyState was %s", url, readyState);
                System.err.println();
            }
            return done;
        });
        return true;
    }

    public String location() {
        return this.driver().getCurrentUrl();
    }

    public boolean back() {
        this.getNavigation().back();
        this.switchToDefaultContent();
        this.waitMilliseconds(500);
        T element = this.findElement(By.id((String)"errorTryAgain"));
        if (element != null) {
            element.click();
            this.getSeleniumHelper().getAlert().accept();
        }
        return true;
    }

    public boolean forward() {
        this.getNavigation().forward();
        this.switchToDefaultContent();
        return true;
    }

    public boolean refresh() {
        this.getNavigation().refresh();
        this.switchToDefaultContent();
        return true;
    }

    private WebDriver.Navigation getNavigation() {
        return this.getSeleniumHelper().navigate();
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String alertText() {
        Alert alert = this.getAlert();
        String text = null;
        if (alert != null) {
            text = alert.getText();
        }
        return text;
    }

    @WaitUntil
    public boolean confirmAlert() {
        Alert alert = this.getAlert();
        boolean result = false;
        if (alert != null) {
            alert.accept();
            this.onAlertHandled(true);
            result = true;
        }
        return result;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean confirmAlertIfAvailable() {
        return this.confirmAlert();
    }

    @WaitUntil
    public boolean dismissAlert() {
        Alert alert = this.getAlert();
        boolean result = false;
        if (alert != null) {
            alert.dismiss();
            this.onAlertHandled(false);
            result = true;
        }
        return result;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean dismissAlertIfAvailable() {
        return this.dismissAlert();
    }

    protected void onAlertHandled(boolean accepted) {
        this.getSeleniumHelper().resetFrameDepthOnAlertError();
    }

    protected Alert getAlert() {
        return this.getSeleniumHelper().getAlert();
    }

    public boolean openInNewTab(String url) {
        String cleanUrl = this.getUrl(url);
        int tabCount = this.tabCount();
        this.getSeleniumHelper().executeJavascript("window.open('%s', '_blank')", cleanUrl);
        this.waitUntil(webDriver -> this.tabCount() > tabCount);
        return this.switchToNextTab();
    }

    @WaitUntil
    public boolean switchToNextTab() {
        boolean result = false;
        List<String> tabs = this.getTabHandles();
        if (tabs.size() > 1) {
            int currentTab = this.getCurrentTabIndex(tabs);
            int nextTab = currentTab + 1;
            if (nextTab == tabs.size()) {
                nextTab = 0;
            }
            this.goToTab(tabs, nextTab);
            result = true;
        }
        return result;
    }

    @WaitUntil
    public boolean switchToPreviousTab() {
        boolean result = false;
        List<String> tabs = this.getTabHandles();
        if (tabs.size() > 1) {
            int currentTab = this.getCurrentTabIndex(tabs);
            int nextTab = currentTab - 1;
            if (nextTab < 0) {
                nextTab = tabs.size() - 1;
            }
            this.goToTab(tabs, nextTab);
            result = true;
        }
        return result;
    }

    public boolean closeTab() {
        boolean result = false;
        List<String> tabs = this.getTabHandles();
        int currentTab = this.getCurrentTabIndex(tabs);
        int tabToGoTo = -1;
        if (currentTab > 0) {
            tabToGoTo = currentTab - 1;
        } else if (tabs.size() > 1) {
            tabToGoTo = 1;
        }
        if (tabToGoTo > -1) {
            WebDriver driver = this.driver();
            driver.close();
            this.goToTab(tabs, tabToGoTo);
            result = true;
        }
        return result;
    }

    public void ensureOnlyOneTab() {
        this.ensureActiveTabIsNotClosed();
        int tabCount = this.tabCount();
        for (int i = 1; i < tabCount; ++i) {
            this.closeTab();
        }
    }

    public boolean ensureActiveTabIsNotClosed() {
        boolean result = false;
        List<String> tabHandles = this.getTabHandles();
        int currentTab = this.getCurrentTabIndex(tabHandles);
        if (currentTab < 0) {
            result = true;
            this.goToTab(tabHandles, 0);
        }
        return result;
    }

    public int tabCount() {
        return this.getTabHandles().size();
    }

    public int currentTabIndex() {
        return this.getCurrentTabIndex(this.getTabHandles()) + 1;
    }

    protected int getCurrentTabIndex(List<String> tabHandles) {
        return this.getSeleniumHelper().getCurrentTabIndex(tabHandles);
    }

    protected void goToTab(List<String> tabHandles, int indexToGoTo) {
        this.getSeleniumHelper().goToTab(tabHandles, indexToGoTo);
    }

    protected List<String> getTabHandles() {
        return this.getSeleniumHelper().getTabHandles();
    }

    public void switchToDefaultContent() {
        this.getSeleniumHelper().switchToDefaultContent();
        this.clearSearchContext();
    }

    public boolean switchToFrame(String technicalSelector) {
        boolean result = false;
        T iframe = this.getElement(technicalSelector);
        if (iframe != null) {
            this.getSeleniumHelper().switchToFrame(iframe);
            result = true;
        }
        return result;
    }

    public void switchToParentFrame() {
        this.getSeleniumHelper().switchToParentFrame();
    }

    public String pageTitle() {
        return this.getSeleniumHelper().getPageTitle();
    }

    public String pageContentType() {
        String result = null;
        Object ct = this.getSeleniumHelper().executeJavascript("return document.contentType;", new Object[0]);
        if (ct != null) {
            result = ct.toString();
        }
        return result;
    }

    @WaitUntil
    public boolean enterAs(String value, String place) {
        return this.enterAsIn(value, place, null);
    }

    @WaitUntil
    public boolean enterAsIn(String value, String place, String container) {
        return this.enter(value, place, container, true);
    }

    @WaitUntil
    public boolean enterFor(String value, String place) {
        return this.enterForIn(value, place, null);
    }

    @WaitUntil
    public boolean enterForIn(String value, String place, String container) {
        return this.enter(value, place, container, false);
    }

    protected boolean enter(String value, String place, boolean shouldClear) {
        return this.enter(value, place, null, shouldClear);
    }

    protected boolean enter(String value, String place, String container, boolean shouldClear) {
        T element = this.getElementToSendValue(place, container);
        return this.enter((WebElement)element, value, shouldClear);
    }

    protected boolean enter(WebElement element, String value, boolean shouldClear) {
        boolean result;
        boolean bl = result = element != null && this.isInteractable(element);
        if (result) {
            if (this.isSelect(element)) {
                result = this.clickSelectOption(element, value);
            } else {
                if (shouldClear) {
                    result = this.clear(element);
                }
                if (result) {
                    this.sendValue(element, value);
                }
            }
        }
        return result;
    }

    @WaitUntil
    public boolean enterDateAs(String date, String place) {
        boolean result;
        T element = this.getElementToSendValue(place);
        boolean bl = result = element != null && this.isInteractable((WebElement)element);
        if (result) {
            this.getSeleniumHelper().fillDateInput((WebElement)element, date);
        }
        return result;
    }

    protected T getElementToSendValue(String place) {
        return this.getElementToSendValue(place, null);
    }

    protected T getElementToSendValue(String place, String container) {
        return this.getElement(place, container);
    }

    public boolean pressTab() {
        return this.sendKeysToActiveElement(new CharSequence[]{Keys.TAB});
    }

    public boolean pressEnter() {
        return this.sendKeysToActiveElement(new CharSequence[]{Keys.ENTER});
    }

    public boolean pressEsc() {
        return this.sendKeysToActiveElement(new CharSequence[]{Keys.ESCAPE});
    }

    public boolean type(String text) {
        String value = this.cleanupValue(text);
        return this.sendKeysToActiveElement(value);
    }

    public boolean press(String key) {
        CharSequence s;
        String[] parts = key.split("\\s*\\+\\s*");
        if (parts.length > 1 && !"".equals(parts[0]) && !"".equals(parts[1])) {
            CharSequence[] sequence = new CharSequence[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                sequence[i] = this.parseKey(parts[i]);
            }
            s = Keys.chord((CharSequence[])sequence);
        } else {
            s = this.parseKey(key);
        }
        return this.sendKeysToActiveElement(s);
    }

    protected CharSequence parseKey(String key) {
        Object s;
        try {
            s = Keys.valueOf((String)key.toUpperCase());
            if (Keys.CONTROL.equals(s) && this.sendCommandForControlOnMac) {
                s = this.getSeleniumHelper().getControlOrCommand();
            }
        }
        catch (IllegalArgumentException e) {
            s = key;
        }
        return s;
    }

    protected boolean sendKeysToActiveElement(CharSequence ... keys) {
        boolean result = false;
        T element = this.getSeleniumHelper().getActiveElement();
        if (element != null) {
            element.sendKeys(keys);
            result = true;
        }
        return result;
    }

    protected void sendValue(WebElement element, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            String keys = this.cleanupValue(value);
            element.sendKeys(new CharSequence[]{keys});
        }
    }

    @WaitUntil
    public boolean selectAs(String value, String place) {
        Select select;
        T element = this.getElementToSelectFor(place);
        if (element != null && (select = new Select(element)).isMultiple()) {
            select.deselectAll();
        }
        return this.clickSelectOption((WebElement)element, value);
    }

    @WaitUntil
    public boolean selectAsIn(String value, String place, String container) {
        return Boolean.TRUE.equals(this.doInContainer((T)container, (Supplier)() -> this.selectAs(value, place)));
    }

    @WaitUntil
    public boolean selectFor(String value, String place) {
        T element = this.getElementToSelectFor(place);
        return this.clickSelectOption((WebElement)element, value);
    }

    @WaitUntil
    public boolean selectForIn(String value, String place, String container) {
        return Boolean.TRUE.equals(this.doInContainer((T)container, (Supplier)() -> this.selectFor(value, place)));
    }

    @WaitUntil
    public boolean enterForHidden(String value, String idOrName) {
        return this.getSeleniumHelper().setHiddenInputValue(idOrName, value);
    }

    protected T getElementToSelectFor(String selectPlace) {
        return this.getElement(selectPlace);
    }

    protected boolean clickSelectOption(WebElement element, String optionValue) {
        boolean result = false;
        if (element != null && this.isSelect(element)) {
            optionValue = this.cleanupValue(optionValue);
            OptionBy optionBy = new OptionBy(optionValue);
            WebElement option = optionBy.findElement((SearchContext)element);
            result = this.clickSelectOption(element, option);
        }
        return result;
    }

    protected boolean clickSelectOption(WebElement element, WebElement option) {
        boolean result = false;
        if (option != null) {
            this.scrollIfNotOnScreen(element);
            if (this.isInteractable(option)) {
                option.click();
                result = true;
            }
        }
        return result;
    }

    @WaitUntil
    public boolean click(String place) {
        return this.clickImp(place, null);
    }

    public void clickAtOffsetXY(String place, Integer xOffset, Integer yOffset) {
        block2: {
            place = this.cleanupValue(place);
            try {
                T element = this.getElementToClick(place);
                this.getSeleniumHelper().clickAtOffsetXY((WebElement)element, xOffset, yOffset);
            }
            catch (WebDriverException e) {
                if (this.clickExceptionIsAboutHiddenByOtherElement((Exception)((Object)e))) break block2;
                throw e;
            }
        }
    }

    public void doubleClickAtOffsetXY(String place, Integer xOffset, Integer yOffset) {
        block2: {
            place = this.cleanupValue(place);
            try {
                T element = this.getElementToClick(place);
                this.getSeleniumHelper().doubleClickAtOffsetXY((WebElement)element, xOffset, yOffset);
            }
            catch (WebDriverException e) {
                if (this.clickExceptionIsAboutHiddenByOtherElement((Exception)((Object)e))) break block2;
                throw e;
            }
        }
    }

    public void rightClickAtOffsetXY(String place, Integer xOffset, Integer yOffset) {
        block2: {
            place = this.cleanupValue(place);
            try {
                T element = this.getElementToClick(place);
                this.getSeleniumHelper().rightClickAtOffsetXY((WebElement)element, xOffset, yOffset);
            }
            catch (WebDriverException e) {
                if (this.clickExceptionIsAboutHiddenByOtherElement((Exception)((Object)e))) break block2;
                throw e;
            }
        }
    }

    public void dragAndDropToOffsetXY(String place, Integer xOffset, Integer yOffset) {
        block2: {
            place = this.cleanupValue(place);
            try {
                T element = this.getElementToClick(place);
                this.getSeleniumHelper().dragAndDropToOffsetXY((WebElement)element, xOffset, yOffset);
            }
            catch (WebDriverException e) {
                if (this.clickExceptionIsAboutHiddenByOtherElement((Exception)((Object)e))) break block2;
                throw e;
            }
        }
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean clickIfAvailable(String place) {
        return this.clickIfAvailableIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean clickIfAvailableIn(String place, String container) {
        return this.clickImp(place, container);
    }

    @WaitUntil
    public boolean clickIn(String place, String container) {
        return this.clickImp(place, container);
    }

    protected boolean clickImp(String place, String container) {
        boolean result;
        block2: {
            result = false;
            place = this.cleanupValue(place);
            try {
                T element = this.getElementToClick(place, container);
                result = this.clickElement((WebElement)element);
            }
            catch (WebDriverException e) {
                if (this.clickExceptionIsAboutHiddenByOtherElement((Exception)((Object)e))) break block2;
                throw e;
            }
        }
        return result;
    }

    protected boolean clickExceptionIsAboutHiddenByOtherElement(Exception e) {
        String msg = e.getMessage();
        return msg != null && (msg.contains(CHROME_HIDDEN_BY_OTHER_ELEMENT_ERROR) || msg.contains(EDGE_HIDDEN_BY_OTHER_ELEMENT_ERROR) || FIREFOX_HIDDEN_BY_OTHER_ELEMENT_ERROR_PATTERN.matcher(msg).find());
    }

    @WaitUntil
    public boolean doubleClick(String place) {
        return this.doubleClickIn(place, null);
    }

    @WaitUntil
    public boolean doubleClickIn(String place, String container) {
        place = this.cleanupValue(place);
        T element = this.getElementToClick(place, container);
        return this.doubleClick((WebElement)element);
    }

    protected boolean doubleClick(WebElement element) {
        return this.doIfInteractable(element, () -> this.getSeleniumHelper().doubleClick(element));
    }

    @WaitUntil
    public boolean rightClick(String place) {
        return this.rightClickIn(place, null);
    }

    @WaitUntil
    public boolean rightClickIn(String place, String container) {
        place = this.cleanupValue(place);
        T element = this.getElementToClick(place, container);
        return this.rightClick((WebElement)element);
    }

    protected boolean rightClick(WebElement element) {
        return this.doIfInteractable(element, () -> this.getSeleniumHelper().rightClick(element));
    }

    @WaitUntil
    public boolean shiftClick(String place) {
        return this.shiftClickIn(place, null);
    }

    @WaitUntil
    public boolean shiftClickIn(String place, String container) {
        place = this.cleanupValue(place);
        T element = this.getElementToClick(place, container);
        return this.shiftClick((WebElement)element);
    }

    protected boolean shiftClick(WebElement element) {
        return this.doIfInteractable(element, () -> this.getSeleniumHelper().clickWithKeyDown(element, (CharSequence)Keys.SHIFT));
    }

    @WaitUntil
    public boolean controlClick(String place) {
        return this.controlClickIn(place, null);
    }

    @WaitUntil
    public boolean controlClickIn(String place, String container) {
        place = this.cleanupValue(place);
        T element = this.getElementToClick(place, container);
        return this.controlClick((WebElement)element);
    }

    protected boolean controlClick(WebElement element) {
        return this.doIfInteractable(element, () -> this.getSeleniumHelper().clickWithKeyDown(element, (CharSequence)this.controlKey()));
    }

    public void setSendCommandForControlOnMacTo(boolean sendCommand) {
        this.sendCommandForControlOnMac = sendCommand;
    }

    public boolean sendCommandForControlOnMac() {
        return this.sendCommandForControlOnMac;
    }

    protected Keys controlKey() {
        return this.sendCommandForControlOnMac ? this.getSeleniumHelper().getControlOrCommand() : Keys.CONTROL;
    }

    @WaitUntil
    public boolean dragAndDropTo(String source, String destination) {
        return this.dragAndDropImpl(source, destination, false);
    }

    @WaitUntil
    public boolean html5DragAndDropTo(String source, String destination) {
        return this.dragAndDropImpl(source, destination, true);
    }

    protected boolean dragAndDropImpl(String source, String destination, boolean html5) {
        boolean result = false;
        source = this.cleanupValue(source);
        T sourceElement = this.getElementToClick(source);
        destination = this.cleanupValue(destination);
        T destinationElement = this.getElementToClick(destination);
        if (sourceElement != null && destinationElement != null) {
            this.scrollIfNotOnScreen((WebElement)sourceElement);
            if (this.isInteractable((WebElement)sourceElement) && destinationElement.isDisplayed()) {
                if (html5 || sourceElement.getAttribute("draggable").equalsIgnoreCase("true")) {
                    try {
                        this.getSeleniumHelper().html5DragAndDrop((WebElement)sourceElement, (WebElement)destinationElement);
                    }
                    catch (IOException e) {
                        throw new SlimFixtureException(false, "The drag and drop simulator javascript could not be found.", e);
                    }
                } else {
                    this.getSeleniumHelper().dragAndDrop((WebElement)sourceElement, (WebElement)destinationElement);
                }
                result = true;
            }
        }
        return result;
    }

    protected T getElementToClick(String place) {
        return this.getSeleniumHelper().getElementToClick(place);
    }

    protected T getElementToClick(String place, String container) {
        return (T)this.doInContainer((T)container, (Supplier)() -> this.getElementToClick(place));
    }

    protected T findFirstInContainer(String container, String place, Supplier<? extends T> ... suppliers) {
        return (T)this.doInContainer((T)container, (Supplier)() -> this.getSeleniumHelper().findByTechnicalSelectorOr(place, suppliers));
    }

    protected <R> R doInContainer(String container, Supplier<R> action) {
        R result = null;
        if (container == null) {
            result = action.get();
        } else {
            String cleanContainer = this.cleanupValue(container);
            result = this.doInContainer((T)((Supplier<WebElement>)() -> this.getContainerElement(cleanContainer)), action);
        }
        return result;
    }

    protected <R> R doInContainer(Supplier<T> containerSupplier, Supplier<R> action) {
        R result = null;
        int retryCount = this.minStaleContextRefreshCount;
        do {
            try {
                WebElement containerElement = (WebElement)containerSupplier.get();
                if (containerElement != null) {
                    result = this.doInContainer(containerElement, action);
                }
                retryCount = 0;
            }
            catch (StaleContextException e) {
                if (--retryCount >= 1) continue;
                throw e;
            }
        } while (retryCount > 0);
        return result;
    }

    protected <R> R doInContainer(T container, Supplier<R> action) {
        return this.getSeleniumHelper().doInContext((SearchContext)container, action);
    }

    @WaitUntil
    public boolean setSearchContextTo(String container) {
        container = this.cleanupValue(container);
        T containerElement = this.getContainerElement(container);
        boolean result = false;
        if (containerElement != null) {
            this.getCurrentSearchContextPath().add(container);
            this.setSearchContextTo((SearchContext)containerElement);
            result = true;
        }
        return result;
    }

    protected void setSearchContextTo(SearchContext containerElement) {
        this.getSeleniumHelper().setCurrentContext(containerElement);
    }

    public void clearSearchContext() {
        this.getCurrentSearchContextPath().clear();
        this.getSeleniumHelper().setCurrentContext(null);
    }

    protected T getContainerElement(String container) {
        return (T)this.findByTechnicalSelectorOr(container, this::getContainerImpl);
    }

    protected T getContainerImpl(String container) {
        return this.findElement(ContainerBy.heuristic(container));
    }

    protected boolean clickElement(WebElement element) {
        return this.doIfInteractable(element, () -> element.click());
    }

    protected boolean doIfInteractable(WebElement element, Runnable action) {
        boolean result = false;
        if (element != null) {
            this.scrollIfNotOnScreen(element);
            if (this.isInteractable(element)) {
                action.run();
                result = true;
            }
        }
        return result;
    }

    protected boolean isInteractable(WebElement element) {
        return this.getSeleniumHelper().isInteractable(element);
    }

    @WaitUntil(value=TimeoutPolicy.STOP_TEST)
    public boolean waitForPage(String pageName) {
        return this.pageTitle().equals(pageName);
    }

    public boolean waitForTagWithText(String tagName, String expectedText) {
        return this.waitForElementWithText(By.tagName((String)tagName), expectedText);
    }

    public boolean waitForClassWithText(String cssClassName, String expectedText) {
        return this.waitForElementWithText(By.className((String)cssClassName), expectedText);
    }

    protected boolean waitForElementWithText(By by, String expectedText) {
        String textToLookFor = this.cleanExpectedValue(expectedText);
        return (Boolean)this.waitUntilOrStop(webDriver -> {
            boolean ok;
            block1: {
                WebElement element;
                ok = false;
                List elements = webDriver.findElements(by);
                if (elements == null) break block1;
                Iterator iterator = elements.iterator();
                while (iterator.hasNext() && !(ok = this.hasText(element = (WebElement)iterator.next(), textToLookFor))) {
                }
            }
            return ok;
        });
    }

    protected String cleanExpectedValue(String expectedText) {
        return this.cleanupValue(expectedText);
    }

    protected boolean hasText(WebElement element, String textToLookFor) {
        boolean ok;
        String actual = this.getElementText(element);
        if (textToLookFor == null) {
            ok = actual == null;
        } else {
            String value;
            if (StringUtils.isEmpty((CharSequence)actual) && !StringUtils.isEmpty((CharSequence)(value = element.getAttribute("value")))) {
                actual = value;
            }
            if (actual != null) {
                actual = actual.trim();
            }
            ok = textToLookFor.equals(actual);
        }
        return ok;
    }

    @WaitUntil(value=TimeoutPolicy.STOP_TEST)
    public boolean waitForClass(String cssClassName) {
        boolean ok = false;
        T element = this.findElement(By.className((String)cssClassName));
        if (element != null) {
            ok = true;
        }
        return ok;
    }

    @WaitUntil(value=TimeoutPolicy.STOP_TEST)
    public boolean waitForVisible(String place) {
        return this.waitForVisibleIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.STOP_TEST)
    public boolean waitForVisibleIn(String place, String container) {
        Boolean result = Boolean.FALSE;
        T element = this.getElementToCheckVisibility(place, container);
        if (element != null) {
            this.scrollIfNotOnScreen((WebElement)element);
            result = element.isDisplayed();
        }
        return result;
    }

    @Deprecated
    public boolean waitForXPathVisible(String xPath) {
        By by = By.xpath((String)xPath);
        return this.waitForVisible(by);
    }

    @Deprecated
    protected boolean waitForVisible(By by) {
        return (Boolean)this.waitUntilOrStop(webDriver -> {
            Boolean result = Boolean.FALSE;
            T element = this.findElement(by);
            if (element != null) {
                this.scrollIfNotOnScreen((WebElement)element);
                result = element.isDisplayed();
            }
            return result;
        });
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueOf(String place) {
        return this.valueFor(place);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueFor(String place) {
        return this.valueForIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueOfIn(String place, String container) {
        return this.valueForIn(place, container);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueForIn(String place, String container) {
        T element = this.getElementToRetrieveValue(place, container);
        return this.valueFor((WebElement)element);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String normalizedValueOf(String place) {
        return this.normalizedValueFor(place);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String normalizedValueFor(String place) {
        return this.normalizedValueForIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String normalizedValueOfIn(String place, String container) {
        return this.normalizedValueForIn(place, container);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String normalizedValueForIn(String place, String container) {
        String value = this.valueForIn(place, container);
        return this.normalizeValue(value);
    }

    protected ArrayList<String> normalizeValues(ArrayList<String> values) {
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                String normalized = this.normalizeValue(value);
                values.set(i, normalized);
            }
        }
        return values;
    }

    protected String normalizeValue(String value) {
        String text = XPathBy.getNormalizedText(value);
        if (text != null && this.trimOnNormalize) {
            text = text.trim();
        }
        return text;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String tooltipFor(String place) {
        return this.tooltipForIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String tooltipForIn(String place, String container) {
        return this.valueOfAttributeOnIn("title", place, container);
    }

    @WaitUntil
    public String targetOfLink(String place) {
        T linkElement = this.getSeleniumHelper().getLink(place);
        return this.getLinkTarget((WebElement)linkElement);
    }

    protected String getLinkTarget(WebElement linkElement) {
        String target = null;
        if (linkElement != null && (target = linkElement.getAttribute("href")) == null) {
            target = linkElement.getAttribute("src");
        }
        return target;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueOfAttributeOn(String attribute, String place) {
        return this.valueOfAttributeOnIn(attribute, place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueOfAttributeOnIn(String attribute, String place, String container) {
        String result = null;
        T element = this.getElementToRetrieveValue(place, container);
        if (element != null) {
            result = element.getAttribute(attribute);
        }
        return result;
    }

    protected T getElementToRetrieveValue(String place, String container) {
        return this.getElement(place, container);
    }

    protected String valueFor(By by) {
        T element = this.getSeleniumHelper().findElement(by);
        return this.valueFor((WebElement)element);
    }

    protected String valueFor(WebElement element) {
        String result = null;
        if (element != null) {
            if (this.isSelect(element)) {
                WebElement selected = this.getFirstSelectedOption(element);
                result = this.getElementText(selected);
            } else {
                String elementType = element.getAttribute("type");
                if ("checkbox".equals(elementType) || "radio".equals(elementType)) {
                    result = String.valueOf(element.isSelected());
                } else if ("li".equalsIgnoreCase(element.getTagName())) {
                    result = this.getElementText(element);
                } else {
                    result = element.getAttribute("value");
                    if (result == null) {
                        result = this.getElementText(element);
                    }
                }
            }
        }
        return result;
    }

    protected WebElement getFirstSelectedOption(WebElement selectElement) {
        SelectHelper s = new SelectHelper(selectElement);
        return s.getFirstSelectedOption();
    }

    protected List<WebElement> getSelectedOptions(WebElement selectElement) {
        SelectHelper s = new SelectHelper(selectElement);
        return s.getAllSelectedOptions();
    }

    protected boolean isSelect(WebElement element) {
        return SelectHelper.isSelect(element);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> valuesOf(String place) {
        return this.valuesFor(place);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> valuesOfIn(String place, String container) {
        return this.valuesForIn(place, container);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> valuesFor(String place) {
        return this.valuesForIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> valuesForIn(String place, String container) {
        ArrayList<String> values = null;
        T element = this.getElementToRetrieveValue(place, container);
        if (element != null) {
            values = new ArrayList<String>();
            String tagName = element.getTagName();
            if ("ul".equalsIgnoreCase(tagName) || "ol".equalsIgnoreCase(tagName)) {
                List items = element.findElements(By.tagName((String)"li"));
                for (WebElement item : items) {
                    if (!item.isDisplayed()) continue;
                    values.add(this.getElementText(item));
                }
            } else if (this.isSelect((WebElement)element)) {
                List<WebElement> options = this.getSelectedOptions((WebElement)element);
                for (WebElement item : options) {
                    values.add(this.getElementText(item));
                }
            } else {
                values.add(this.valueFor((WebElement)element));
            }
        }
        return values;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> normalizedValuesOf(String place) {
        return this.normalizedValuesFor(place);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> normalizedValuesOfIn(String place, String container) {
        return this.normalizedValuesForIn(place, container);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> normalizedValuesFor(String place) {
        return this.normalizedValuesForIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> normalizedValuesForIn(String place, String container) {
        ArrayList<String> values = this.valuesForIn(place, container);
        return this.normalizeValues(values);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public Integer numberFor(String place) {
        Integer number = null;
        T element = this.findElement(ListItemBy.numbered(place));
        if (element != null) {
            this.scrollIfNotOnScreen((WebElement)element);
            number = this.getSeleniumHelper().getNumberFor((WebElement)element);
        }
        return number;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public Integer numberForIn(String place, String container) {
        return this.doInContainer((T)container, (Supplier)() -> this.numberFor(place));
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> availableOptionsFor(String place) {
        ArrayList<String> result = null;
        T element = this.getElementToSelectFor(place);
        if (element != null) {
            this.scrollIfNotOnScreen((WebElement)element);
            result = this.getSeleniumHelper().getAvailableOptions((WebElement)element);
        }
        return result;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public ArrayList<String> normalizedAvailableOptionsFor(String place) {
        return this.normalizeValues(this.availableOptionsFor(place));
    }

    @WaitUntil
    public boolean clear(String place) {
        return this.clearIn(place, null);
    }

    @WaitUntil
    public boolean clearIn(String place, String container) {
        boolean result = false;
        T element = this.getElementToClear(place, container);
        if (element != null) {
            result = this.clear((WebElement)element);
        }
        return result;
    }

    protected boolean clear(WebElement element) {
        boolean result = false;
        String tagName = element.getTagName();
        if ("input".equalsIgnoreCase(tagName) || "textarea".equalsIgnoreCase(tagName)) {
            element.clear();
            result = true;
        }
        return result;
    }

    protected T getElementToClear(String place, String container) {
        return this.getElementToSendValue(place, container);
    }

    @WaitUntil
    public boolean enterAsInRowWhereIs(String value, String requestedColumnName, String selectOnColumn, String selectOnValue) {
        SingleElementOrNullBy cellBy = GridBy.columnInRowWhereIs(requestedColumnName, selectOnColumn, selectOnValue);
        T element = this.findElement(cellBy);
        return this.enter((WebElement)element, value, true);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueOfColumnNumberInRowNumber(int columnIndex, int rowIndex) {
        SingleElementOrNullBy by = GridBy.coordinates(columnIndex, rowIndex);
        return this.valueFor(by);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueOfInRowNumber(String requestedColumnName, int rowIndex) {
        SingleElementOrNullBy by = GridBy.columnInRow(requestedColumnName, rowIndex);
        return this.valueFor(by);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String valueOfInRowWhereIs(String requestedColumnName, String selectOnColumn, String selectOnValue) {
        SingleElementOrNullBy by = GridBy.columnInRowWhereIs(requestedColumnName, selectOnColumn, selectOnValue);
        return this.valueFor(by);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String normalizedValueOfColumnNumberInRowNumber(int columnIndex, int rowIndex) {
        return this.normalizeValue(this.valueOfColumnNumberInRowNumber(columnIndex, rowIndex));
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String normalizedValueOfInRowNumber(String requestedColumnName, int rowIndex) {
        return this.normalizeValue(this.valueOfInRowNumber(requestedColumnName, rowIndex));
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    public String normalizedValueOfInRowWhereIs(String requestedColumnName, String selectOnColumn, String selectOnValue) {
        return this.normalizeValue(this.valueOfInRowWhereIs(requestedColumnName, selectOnColumn, selectOnValue));
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean rowExistsWhereIs(String selectOnColumn, String selectOnValue) {
        return this.findElement(GridBy.rowWhereIs(selectOnColumn, selectOnValue)) != null;
    }

    @WaitUntil
    public boolean clickInRowNumber(String place, int rowIndex) {
        XPathBy rowBy = GridBy.rowNumber(rowIndex);
        return this.clickInRow(rowBy, place);
    }

    @WaitUntil
    public boolean clickInRowWhereIs(String place, String selectOnColumn, String selectOnValue) {
        XPathBy rowBy = GridBy.rowWhereIs(selectOnColumn, selectOnValue);
        return this.clickInRow(rowBy, place);
    }

    protected boolean clickInRow(By rowBy, String place) {
        return Boolean.TRUE.equals(this.doInContainer((T)((Supplier<WebElement>)() -> this.findElement(rowBy)), (Supplier)() -> this.click(place)));
    }

    @WaitUntil
    public String downloadFromRowNumber(String place, int rowNumber) {
        return this.downloadFromRow(GridBy.linkInRow(place, rowNumber));
    }

    @WaitUntil
    public String downloadFromRowWhereIs(String place, String selectOnColumn, String selectOnValue) {
        return this.downloadFromRow(GridBy.linkInRowWhereIs(place, selectOnColumn, selectOnValue));
    }

    protected String downloadFromRow(By linkBy) {
        String result = null;
        T element = this.findElement(linkBy);
        if (element != null) {
            result = this.downloadLinkTarget((WebElement)element);
        }
        return result;
    }

    protected T getElement(String place) {
        return this.getSeleniumHelper().getElement(place);
    }

    protected T getElement(String place, String container) {
        return (T)this.doInContainer((T)container, (Supplier)() -> this.getElement(place));
    }

    @WaitUntil
    @Deprecated
    public boolean clickByXPath(String xPath) {
        T element = this.findByXPath(xPath, new String[0]);
        return this.clickElement((WebElement)element);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    @Deprecated
    public String textByXPath(String xPath) {
        return this.getTextByXPath(xPath, new String[0]);
    }

    protected String getTextByXPath(String xpathPattern, String ... params) {
        T element = this.findByXPath(xpathPattern, params);
        return this.getElementText((WebElement)element);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_NULL)
    @Deprecated
    public String textByClassName(String className) {
        return this.getTextByClassName(className);
    }

    protected String getTextByClassName(String className) {
        T element = this.findByClassName(className);
        return this.getElementText((WebElement)element);
    }

    protected T findByClassName(String className) {
        By by = By.className((String)className);
        return this.findElement(by);
    }

    protected T findByXPath(String xpathPattern, String ... params) {
        return this.getSeleniumHelper().findByXPath(xpathPattern, params);
    }

    protected T findByCss(String cssPattern, String ... params) {
        By by = this.getSeleniumHelper().byCss(cssPattern, params);
        return this.findElement(by);
    }

    protected T findByJavascript(String script, Object ... parameters) {
        By by = this.getSeleniumHelper().byJavascript(script, parameters);
        return this.findElement(by);
    }

    protected List<T> findAllByXPath(String xpathPattern, String ... params) {
        By by = this.getSeleniumHelper().byXpath(xpathPattern, params);
        return this.findElements(by);
    }

    protected List<T> findAllByCss(String cssPattern, String ... params) {
        By by = this.getSeleniumHelper().byCss(cssPattern, params);
        return this.findElements(by);
    }

    protected List<T> findAllByJavascript(String script, Object ... parameters) {
        By by = this.getSeleniumHelper().byJavascript(script, parameters);
        return this.findElements(by);
    }

    public void waitMilliSecondAfterScroll(int msToWait) {
        this.waitAfterScroll = msToWait;
    }

    protected int getWaitAfterScroll() {
        return this.waitAfterScroll;
    }

    protected String getElementText(WebElement element) {
        String result = null;
        if (element != null) {
            this.scrollIfNotOnScreen(element);
            result = this.getSeleniumHelper().getText(element);
        }
        return result;
    }

    @WaitUntil
    public boolean scrollTo(String place) {
        return this.scrollToIn(place, null);
    }

    @WaitUntil
    public boolean scrollToIn(String place, String container) {
        boolean result = false;
        T element = this.getElementToScrollTo(place, container);
        if (element != null) {
            this.scrollTo((WebElement)element);
            result = true;
        }
        return result;
    }

    protected T getElementToScrollTo(String place, String container) {
        return this.getElementToCheckVisibility(place, container);
    }

    protected void scrollTo(WebElement element) {
        this.getSeleniumHelper().scrollTo(element, this.scrollElementToCenter);
        this.waitAfterScroll(this.waitAfterScroll);
    }

    protected void waitAfterScroll(int msToWait) {
        if (msToWait > 0) {
            this.waitMilliseconds(msToWait);
        }
    }

    protected void scrollIfNotOnScreen(WebElement element) {
        if (!element.isDisplayed() || !this.isElementOnScreen(element)) {
            this.scrollTo(element);
        }
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isEnabled(String place) {
        return this.isEnabledIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isEnabledIn(String place, String container) {
        boolean result = false;
        T element = this.getElementToCheckVisibility(place, container);
        if (element != null) {
            T labelTarget;
            if ("label".equalsIgnoreCase(element.getTagName()) && (labelTarget = this.getSeleniumHelper().getLabelledElement(element)) != null) {
                element = labelTarget;
            }
            result = element.isEnabled();
        }
        return result;
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isDisabled(String place) {
        return this.isDisabledIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isDisabledIn(String place, String container) {
        return !this.isEnabledIn(place, container);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isVisible(String place) {
        return this.isVisibleIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isVisibleIn(String place, String container) {
        return this.isVisibleImpl(place, container, true);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isVisibleOnPage(String place) {
        return this.isVisibleOnPageIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isVisibleOnPageIn(String place, String container) {
        return this.isVisibleImpl(place, container, false);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isNotVisible(String place) {
        return this.isNotVisibleIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isNotVisibleIn(String place, String container) {
        return !this.isVisibleImpl(place, container, true);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isNotVisibleOnPage(String place) {
        return this.isNotVisibleOnPageIn(place, null);
    }

    @WaitUntil(value=TimeoutPolicy.RETURN_FALSE)
    public boolean isNotVisibleOnPageIn(String place, String container) {
        return !this.isVisibleImpl(place, container, false);
    }

    protected boolean isVisibleImpl(String place, String container, boolean checkOnScreen) {
        T element = this.getElementToCheckVisibility(place, container);
        return this.getSeleniumHelper().checkVisible((WebElement)element, checkOnScreen);
    }

    public int numberOfTimesIsVisible(String text) {
        return this.numberOfTimesIsVisibleInImpl(text, true);
    }

    public int numberOfTimesIsVisibleOnPage(String text) {
        return this.numberOfTimesIsVisibleInImpl(text, false);
    }

    public int numberOfTimesIsVisibleIn(String text, String container) {
        return this.intValueOf(this.doInContainer((T)container, (Supplier)() -> this.numberOfTimesIsVisible(text)));
    }

    public int numberOfTimesIsVisibleOnPageIn(String text, String container) {
        return this.intValueOf(this.doInContainer((T)container, (Supplier)() -> this.numberOfTimesIsVisibleOnPage(text)));
    }

    protected int intValueOf(Integer count) {
        if (count == null) {
            count = 0;
        }
        return count;
    }

    protected int numberOfTimesIsVisibleInImpl(String text, boolean checkOnScreen) {
        int result;
        SeleniumHelper helper = this.getSeleniumHelper();
        if (this.implicitFindInFrames) {
            AtomicInteger count = new AtomicInteger();
            new AllFramesDecorator<Integer>(helper).apply(() -> count.addAndGet(helper.countVisibleOccurrences(text, checkOnScreen)));
            result = count.get();
        } else {
            result = helper.countVisibleOccurrences(text, checkOnScreen);
        }
        return result;
    }

    protected T getElementToCheckVisibility(String place) {
        return this.getSeleniumHelper().getElementToCheckVisibility(place);
    }

    protected T getElementToCheckVisibility(String place, String container) {
        return (T)this.doInContainer((T)container, (Supplier)() -> this.findByTechnicalSelectorOr(place, this::getElementToCheckVisibility));
    }

    protected boolean isElementOnScreen(WebElement element) {
        Boolean onScreen = this.getSeleniumHelper().isElementOnScreen(element);
        return onScreen == null || onScreen != false;
    }

    @WaitUntil
    public boolean hoverOver(String place) {
        return this.hoverOverIn(place, null);
    }

    @WaitUntil
    public boolean hoverOverIn(String place, String container) {
        T element = this.getElementToClick(place, container);
        return this.hoverOver((WebElement)element);
    }

    protected boolean hoverOver(WebElement element) {
        boolean result = false;
        if (element != null) {
            this.scrollIfNotOnScreen(element);
            if (element.isDisplayed()) {
                this.getSeleniumHelper().hoverOver(element);
                result = true;
            }
        }
        return result;
    }

    public void secondsBeforeTimeout(int timeout) {
        this.secondsBeforeTimeout = timeout;
        this.secondsBeforePageLoadTimeout(timeout);
        int timeoutInMs = timeout * 1000;
        this.getSeleniumHelper().setScriptWait(timeoutInMs);
    }

    public int secondsBeforeTimeout() {
        return this.secondsBeforeTimeout;
    }

    public void secondsBeforePageLoadTimeout(int timeout) {
        this.secondsBeforePageLoadTimeout = timeout;
        int timeoutInMs = timeout * 1000;
        this.getSeleniumHelper().setPageLoadWait(timeoutInMs);
    }

    public int secondsBeforePageLoadTimeout() {
        return this.secondsBeforePageLoadTimeout;
    }

    public void clearSessionStorage() {
        this.getSeleniumHelper().executeJavascript("sessionStorage.clear();", new Object[0]);
    }

    public void clearLocalStorage() {
        this.getSeleniumHelper().executeJavascript("localStorage.clear();", new Object[0]);
    }

    public void deleteAllCookies() {
        this.getSeleniumHelper().deleteAllCookies();
    }

    public void screenshotBaseDirectory(String directory) {
        this.screenshotBase = directory.equals("") || directory.endsWith("/") || directory.endsWith("\\") ? directory : directory + "/";
    }

    public void screenshotShowHeight(String height) {
        this.screenshotHeight = height;
    }

    public String pageSource() {
        String html = this.getSeleniumHelper().getHtml();
        return this.getEnvironment().getHtml(html);
    }

    public String savePageSource() {
        String fileName = this.getSeleniumHelper().getResourceNameFromLocation();
        return this.savePageSource(fileName, fileName + ".html");
    }

    protected String savePageSource(String fileName, String linkText) {
        PageSourceSaver saver = this.getSeleniumHelper().getPageSourceSaver(this.pageSourceBase);
        String url = saver.savePageSource(fileName);
        return String.format("<a href=\"%s\" target=\"_blank\">%s</a>", url, linkText);
    }

    public String takeScreenshot(String basename) {
        try {
            String screenshotFile = this.createScreenshot(basename);
            if (screenshotFile == null) {
                throw new SlimFixtureException(false, "Unable to take screenshot: does the webdriver support it?");
            }
            screenshotFile = this.getScreenshotLink(screenshotFile);
            return screenshotFile;
        }
        catch (UnhandledAlertException e) {
            return String.format("<div><strong>Unable to take screenshot</strong>, alert is active. Alert text:<br/>'<span>%s</span>'</div>", StringEscapeUtils.escapeHtml4((String)this.alertText()));
        }
    }

    private String getScreenshotLink(String screenshotFile) {
        String wikiUrl = this.getWikiUrl(screenshotFile);
        if (wikiUrl != null) {
            wikiUrl = "".equals(this.screenshotHeight) ? String.format("<a href=\"%s\" target=\"_blank\">%s</a>", wikiUrl, screenshotFile) : String.format("<a href=\"%1$s\" target=\"_blank\"><img src=\"%1$s\" title=\"%2$s\" height=\"%3$s\"/></a>", wikiUrl, screenshotFile, this.screenshotHeight);
            screenshotFile = wikiUrl;
        }
        return screenshotFile;
    }

    private String createScreenshot(String basename) {
        String name = this.getScreenshotBasename(basename);
        return this.getSeleniumHelper().takeScreenshot(name);
    }

    private String createScreenshot(String basename, Throwable t) {
        String screenshotFile;
        byte[] screenshotInException = this.getSeleniumHelper().findScreenshot(t);
        if (screenshotInException == null || screenshotInException.length == 0) {
            screenshotFile = this.createScreenshot(basename);
        } else {
            String name = this.getScreenshotBasename(basename);
            screenshotFile = this.getSeleniumHelper().writeScreenshot(name, screenshotInException);
        }
        return screenshotFile;
    }

    private String getScreenshotBasename(String basename) {
        return this.screenshotBase + basename;
    }

    protected <T> T waitUntil(ExpectedCondition<T> condition) {
        try {
            return this.waitUntilImpl(condition);
        }
        catch (TimeoutException e) {
            String message = this.getTimeoutMessage(e);
            return this.lastAttemptBeforeThrow(condition, new SlimFixtureException(false, message, e));
        }
    }

    protected <T> T waitUntilOrStop(ExpectedCondition<T> condition) {
        try {
            return this.waitUntilImpl(condition);
        }
        catch (TimeoutException e) {
            try {
                return this.handleTimeoutException(e);
            }
            catch (TimeoutStopTestException tste) {
                return this.lastAttemptBeforeThrow(condition, tste);
            }
        }
    }

    protected <T> T lastAttemptBeforeThrow(ExpectedCondition<T> condition, SlimFixtureException e) {
        Object lastAttemptResult = null;
        try {
            lastAttemptResult = condition.apply((Object)this.getSeleniumHelper().driver());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (lastAttemptResult == null || Boolean.FALSE.equals(lastAttemptResult)) {
            throw e;
        }
        return (T)lastAttemptResult;
    }

    protected <T> T waitUntilOrNull(ExpectedCondition<T> condition) {
        try {
            return this.waitUntilImpl(condition);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    protected <T> T waitUntilImpl(ExpectedCondition<T> condition) {
        return this.getSeleniumHelper().waitUntil(this.secondsBeforeTimeout(), condition);
    }

    public boolean refreshSearchContext() {
        ArrayList<String> fullPath = new ArrayList<String>(this.getCurrentSearchContextPath());
        return this.refreshSearchContext(fullPath, Math.min(fullPath.size(), this.minStaleContextRefreshCount));
    }

    protected boolean refreshSearchContext(List<String> fullPath, int maxRetries) {
        this.clearSearchContext();
        for (String container : fullPath) {
            try {
                this.setSearchContextTo(container);
            }
            catch (RuntimeException se) {
                if (maxRetries < 1 || !(se instanceof WebDriverException) || !this.getSeleniumHelper().isStaleElementException((WebDriverException)((Object)se))) {
                    this.clearSearchContext();
                    throw new SlimFixtureException("Search context is 'stale' and could not be refreshed. Context was: " + fullPath + ". Error when trying to refresh: " + container, se);
                }
                return this.refreshSearchContext(fullPath, maxRetries - 1);
            }
        }
        return true;
    }

    protected <T> T handleTimeoutException(TimeoutException e) {
        String message = this.getTimeoutMessage(e);
        throw new TimeoutStopTestException(false, message, e);
    }

    private String getTimeoutMessage(TimeoutException e) {
        String messageBase = String.format("Timed-out waiting (after %ss)", this.secondsBeforeTimeout());
        return this.getSlimFixtureExceptionMessage("timeouts", "timeout", messageBase, e);
    }

    protected void handleRequiredElementNotFound(String toFind) {
        this.handleRequiredElementNotFound(toFind, null);
    }

    protected void handleRequiredElementNotFound(String toFind, Throwable t) {
        String messageBase = String.format("Unable to find: %s", toFind);
        String message = this.getSlimFixtureExceptionMessage("notFound", toFind, messageBase, t);
        throw new SlimFixtureException(false, message, t);
    }

    protected String getSlimFixtureExceptionMessage(String screenshotFolder, String screenshotFile, String messageBase, Throwable t) {
        String screenshotBaseName = String.format("%s/%s/%s", screenshotFolder, this.getClass().getSimpleName(), screenshotFile);
        return this.getSlimFixtureExceptionMessage(screenshotBaseName, messageBase, t);
    }

    protected String getSlimFixtureExceptionMessage(String screenshotBaseName, String messageBase, Throwable t) {
        String exceptionMsg = this.getExceptionMessageText(messageBase, t);
        String screenshotTag = this.getExceptionScreenshotTag(screenshotBaseName, messageBase, t);
        String label = this.getExceptionPageSourceTag(screenshotBaseName, messageBase, t);
        String message = String.format("<div><div>%s.</div><div>%s:%s</div></div>", exceptionMsg, label, screenshotTag);
        return message;
    }

    protected String getExceptionMessageText(String messageBase, Throwable t) {
        String message = messageBase;
        if (message == null) {
            message = t == null ? "" : ExceptionUtils.getStackTrace((Throwable)t);
        }
        return this.formatExceptionMsg(message);
    }

    protected String getExceptionScreenshotTag(String screenshotBaseName, String messageBase, Throwable t) {
        String screenshotTag = "(Screenshot not available)";
        try {
            String screenShotFile = this.createScreenshot(screenshotBaseName, t);
            screenshotTag = this.getScreenshotLink(screenShotFile);
        }
        catch (UnhandledAlertException e) {
            System.err.println("Unable to take screenshot while alert is present for exception: " + messageBase);
        }
        catch (Exception sse) {
            System.err.println("Unable to take screenshot for exception: " + messageBase);
            sse.printStackTrace();
        }
        return screenshotTag;
    }

    protected String getExceptionPageSourceTag(String screenshotBaseName, String messageBase, Throwable t) {
        String label = "Page content";
        try {
            String fileName = t != null ? t.getClass().getName() : (screenshotBaseName != null ? screenshotBaseName : "exception");
            label = this.savePageSource(fileName, label);
        }
        catch (UnhandledAlertException e) {
            System.err.println("Unable to capture page source while alert is present for exception: " + messageBase);
        }
        catch (Exception e) {
            System.err.println("Unable to capture page source for exception: " + messageBase);
            e.printStackTrace();
        }
        return label;
    }

    protected String formatExceptionMsg(String value) {
        return StringEscapeUtils.escapeHtml4((String)value);
    }

    private WebDriver driver() {
        return this.getSeleniumHelper().driver();
    }

    private WebDriverWait waitDriver() {
        return this.getSeleniumHelper().waitDriver();
    }

    protected SeleniumHelper<T> getSeleniumHelper() {
        return this.seleniumHelper;
    }

    protected void setSeleniumHelper(SeleniumHelper<T> helper) {
        this.seleniumHelper = helper;
    }

    public int currentBrowserWidth() {
        return this.getWindowSize().getWidth();
    }

    public int currentBrowserHeight() {
        return this.getWindowSize().getHeight();
    }

    public void setBrowserWidth(int newWidth) {
        int currentHeight = this.currentBrowserHeight();
        this.setBrowserSizeToBy(newWidth, currentHeight);
    }

    public void setBrowserHeight(int newHeight) {
        int currentWidth = this.currentBrowserWidth();
        this.setBrowserSizeToBy(currentWidth, newHeight);
    }

    public void setBrowserSizeToBy(int newWidth, int newHeight) {
        this.getSeleniumHelper().setWindowSize(newWidth, newHeight);
        Dimension actualSize = this.getWindowSize();
        if (actualSize.getHeight() != newHeight || actualSize.getWidth() != newWidth) {
            String message = String.format("Unable to change size to: %s x %s; size is: %s x %s", newWidth, newHeight, actualSize.getWidth(), actualSize.getHeight());
            throw new SlimFixtureException(false, message);
        }
    }

    protected Dimension getWindowSize() {
        return this.getSeleniumHelper().getWindowSize();
    }

    public void setBrowserSizeToMaximum() {
        this.getSeleniumHelper().setWindowSizeToMaximum();
    }

    @WaitUntil
    public String download(String place) {
        WebElement element = this.getElementToDownload(place);
        return this.downloadLinkTarget(element);
    }

    protected WebElement getElementToDownload(String place) {
        SeleniumHelper helper = this.getSeleniumHelper();
        return helper.findByTechnicalSelectorOr(place, () -> helper.getLink(place), () -> helper.findElement(AltBy.exact(place)), () -> helper.findElement(AltBy.partial(place)));
    }

    @WaitUntil
    public String downloadIn(String place, String container) {
        return this.doInContainer((T)container, (Supplier)() -> this.download(place));
    }

    protected T findElement(By selector) {
        return this.getSeleniumHelper().findElement(selector);
    }

    protected List<T> findElements(By by) {
        return this.getSeleniumHelper().findElements(by);
    }

    public T findByTechnicalSelectorOr(String place, Function<String, ? extends T> supplierF) {
        return this.getSeleniumHelper().findByTechnicalSelectorOr(place, () -> (WebElement)supplierF.apply(place));
    }

    protected String downloadLinkTarget(WebElement element) {
        String href = this.getLinkTarget(element);
        if (href == null) {
            throw new SlimFixtureException(false, "Could not determine url to download from");
        }
        String result = this.downloadContentFrom(href);
        return result;
    }

    public String downloadContentFrom(String urlOrLink) {
        String result = null;
        if (urlOrLink != null) {
            HttpTest httpTest = new HttpTest();
            httpTest.copyBrowserCookies();
            result = httpTest.getFileFrom(urlOrLink);
        }
        return result;
    }

    @WaitUntil
    public boolean selectFile(String fileName) {
        return this.selectFileFor(fileName, "css=input[type='file']");
    }

    @WaitUntil
    public boolean selectFileFor(String fileName, String place) {
        return this.selectFileForIn(fileName, place, null);
    }

    @WaitUntil
    public boolean selectFileForIn(String fileName, String place, String container) {
        boolean result = false;
        if (fileName != null) {
            String fullPath = this.getFilePathFromWikiUrl(fileName);
            if (new File(fullPath).exists()) {
                T element = this.getElementToSelectFile(place, container);
                if (element != null) {
                    element.sendKeys(new CharSequence[]{fullPath});
                    result = true;
                }
            } else {
                throw new SlimFixtureException(false, "Unable to find file: " + fullPath);
            }
        }
        return result;
    }

    protected T getElementToSelectFile(String place, String container) {
        T result = null;
        T element = this.getElement(place, container);
        if (element != null && "input".equalsIgnoreCase(element.getTagName()) && "file".equalsIgnoreCase(element.getAttribute("type"))) {
            result = element;
        }
        return result;
    }

    public String cookieValue(String cookieName) {
        String result = null;
        Cookie cookie = this.getSeleniumHelper().getCookie(cookieName);
        if (cookie != null) {
            result = cookie.getValue();
        }
        return result;
    }

    public boolean refreshUntilValueOfIs(String place, String expectedValue) {
        return this.repeatUntil(this.getRefreshUntilValueIs(place, expectedValue));
    }

    public boolean refreshUntilValueOfIsNot(String place, String expectedValue) {
        return this.repeatUntilNot(this.getRefreshUntilValueIs(place, expectedValue));
    }

    protected SlimFixture.RepeatCompletion getRefreshUntilValueIs(String place, String expectedValue) {
        return new ConditionBasedRepeatUntil(false, (ExpectedCondition<? extends Object>)((ExpectedCondition)d -> this.refresh()), true, (ExpectedCondition<Boolean>)((ExpectedCondition)d -> this.checkValueIs(place, expectedValue)));
    }

    public boolean refreshUntilIsVisibleOnPage(String place) {
        return this.repeatUntil(this.getRefreshUntilIsVisibleOnPage(place));
    }

    public boolean refreshUntilIsNotVisibleOnPage(String place) {
        return this.repeatUntilNot(this.getRefreshUntilIsVisibleOnPage(place));
    }

    protected SlimFixture.RepeatCompletion getRefreshUntilIsVisibleOnPage(String place) {
        return new ConditionBasedRepeatUntil(false, (ExpectedCondition<? extends Object>)((ExpectedCondition)d -> this.refresh()), true, (ExpectedCondition<Boolean>)((ExpectedCondition)d -> this.isVisibleOnPage(place)));
    }

    public boolean clickUntilValueOfIs(String clickPlace, String checkPlace, String expectedValue) {
        return this.repeatUntil(this.getClickUntilValueIs(clickPlace, checkPlace, expectedValue));
    }

    public boolean clickUntilValueOfIsNot(String clickPlace, String checkPlace, String expectedValue) {
        return this.repeatUntilNot(this.getClickUntilValueIs(clickPlace, checkPlace, expectedValue));
    }

    public boolean executeJavascriptUntilIs(String script, String place, String value) {
        return this.repeatUntil(this.getExecuteScriptUntilValueIs(script, place, value));
    }

    public boolean executeJavascriptUntilIsNot(String script, String place, String value) {
        return this.repeatUntilNot(this.getExecuteScriptUntilValueIs(script, place, value));
    }

    protected SlimFixture.RepeatCompletion getExecuteScriptUntilValueIs(String script, String place, String expectedValue) {
        return new ConditionBasedRepeatUntil(false, (ExpectedCondition<? extends Object>)((ExpectedCondition)d -> {
            Object r = this.executeScript(script);
            return r != null ? r : Boolean.valueOf(true);
        }), true, (ExpectedCondition<Boolean>)((ExpectedCondition)d -> this.checkValueIs(place, expectedValue)));
    }

    protected SlimFixture.RepeatCompletion getClickUntilValueIs(String clickPlace, String checkPlace, String expectedValue) {
        String place = this.cleanupValue(clickPlace);
        return this.getClickUntilCompletion(place, checkPlace, expectedValue);
    }

    protected SlimFixture.RepeatCompletion getClickUntilCompletion(String place, String checkPlace, String expectedValue) {
        return new ConditionBasedRepeatUntil(true, (ExpectedCondition<? extends Object>)((ExpectedCondition)d -> this.click(place)), (ExpectedCondition<Boolean>)((ExpectedCondition)d -> this.checkValueIs(checkPlace, expectedValue)));
    }

    protected boolean repeatUntil(ExpectedCondition<Object> actionCondition, ExpectedCondition<Boolean> finishCondition) {
        return this.repeatUntil(new ConditionBasedRepeatUntil(true, actionCondition, finishCondition));
    }

    protected boolean repeatUntilIsNot(ExpectedCondition<Object> actionCondition, ExpectedCondition<Boolean> finishCondition) {
        return this.repeatUntilNot(new ConditionBasedRepeatUntil(true, actionCondition, finishCondition));
    }

    protected <T> ExpectedCondition<T> wrapConditionForFramesIfNeeded(ExpectedCondition<T> condition) {
        if (this.implicitFindInFrames) {
            condition = this.getSeleniumHelper().conditionForAllFrames(condition);
        }
        return condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean repeatUntil(SlimFixture.RepeatCompletion repeat) {
        int previousTimeout = this.secondsBeforeTimeout();
        int pageLoadTimeout = this.secondsBeforePageLoadTimeout();
        try {
            int timeoutDuringRepeat = Math.max(Math.toIntExact(this.repeatInterval() / 1000L), 1);
            this.secondsBeforeTimeout(timeoutDuringRepeat);
            this.secondsBeforePageLoadTimeout(pageLoadTimeout);
            boolean bl = super.repeatUntil(repeat);
            return bl;
        }
        finally {
            this.secondsBeforeTimeout(previousTimeout);
            this.secondsBeforePageLoadTimeout(pageLoadTimeout);
        }
    }

    protected boolean checkValueIs(String place, String expectedValue) {
        String actual = this.valueOf(place);
        boolean match = expectedValue == null ? actual == null : this.cleanExpectedValue(expectedValue).equals(actual);
        return match;
    }

    protected Object waitForJavascriptCallback(String statement, Object ... parameters) {
        try {
            return this.getSeleniumHelper().waitForJavascriptCallback(statement, parameters);
        }
        catch (TimeoutException e) {
            return this.handleTimeoutException(e);
        }
    }

    public NgBrowserTest getNgBrowserTest() {
        return this.ngBrowserTest;
    }

    public void setNgBrowserTest(NgBrowserTest ngBrowserTest) {
        this.ngBrowserTest = ngBrowserTest;
    }

    public boolean isImplicitWaitForAngularEnabled() {
        return this.implicitWaitForAngular;
    }

    public void setImplicitWaitForAngularTo(boolean implicitWaitForAngular) {
        this.implicitWaitForAngular = implicitWaitForAngular;
    }

    public void setImplicitFindInFramesTo(boolean implicitFindInFrames) {
        this.implicitFindInFrames = implicitFindInFrames;
    }

    public Object executeScript(String script) {
        String statement = this.cleanupValue(script);
        return this.getSeleniumHelper().executeJavascript(statement, new Object[0]);
    }

    @WaitUntil
    public boolean selectAll() {
        return this.getSeleniumHelper().selectAll();
    }

    @WaitUntil
    public boolean copy() {
        return this.getSeleniumHelper().copy();
    }

    @WaitUntil
    public boolean cut() {
        return this.getSeleniumHelper().cut();
    }

    @WaitUntil
    public boolean paste() {
        return this.getSeleniumHelper().paste();
    }

    public String getSelectionText() {
        return this.getSeleniumHelper().getSelectionText();
    }

    public boolean trimOnNormalize() {
        return this.trimOnNormalize;
    }

    public void setTrimOnNormalize(boolean trimOnNormalize) {
        this.trimOnNormalize = trimOnNormalize;
    }

    public void scrollElementsToCenterOfViewport(boolean scrollElementsToCenterOfViewport) {
        this.scrollElementToCenter = scrollElementsToCenterOfViewport;
    }

    public boolean scrollElementsToCenterOfViewport() {
        return this.scrollElementToCenter;
    }

    protected class ConditionBasedRepeatUntil
    extends SlimFixture.FunctionalCompletion {
        public ConditionBasedRepeatUntil(boolean wrapIfNeeded, ExpectedCondition<? extends Object> repeatCondition, ExpectedCondition<Boolean> finishedCondition) {
            this(wrapIfNeeded, repeatCondition, wrapIfNeeded, finishedCondition);
        }

        public ConditionBasedRepeatUntil(boolean wrapRepeatIfNeeded, ExpectedCondition<? extends Object> repeatCondition, boolean wrapFinishedIfNeeded, ExpectedCondition<Boolean> finishedCondition) {
            if (wrapRepeatIfNeeded) {
                repeatCondition = BrowserTest.this.wrapConditionForFramesIfNeeded(repeatCondition);
            }
            ExpectedCondition<? extends Object> finalRepeatCondition = repeatCondition;
            if (wrapFinishedIfNeeded) {
                finishedCondition = BrowserTest.this.wrapConditionForFramesIfNeeded(finishedCondition);
            }
            ExpectedCondition<Boolean> finalFinishedCondition = finishedCondition;
            this.setIsFinishedSupplier(() -> (Boolean)BrowserTest.this.waitUntilOrNull(finalFinishedCondition));
            this.setRepeater(() -> BrowserTest.this.waitUntil(finalRepeatCondition));
        }
    }
}

