/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim.web;

import com.galenframework.api.Galen;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.HtmlReportBuilder;
import com.galenframework.reports.TestReport;
import com.galenframework.reports.TestStatistic;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.Spec;
import com.galenframework.utils.GalenUtils;
import com.galenframework.validation.ValidationError;
import com.galenframework.validation.ValidationObject;
import com.galenframework.validation.ValidationResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureWithMap;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import org.openqa.selenium.WebDriver;

public class LayoutTest
extends SlimFixtureWithMap {
    private static final String REPORT_OVERVIEW_SYMBOL = "GALEN_TOP_LEVEL_REPORT_INDEX";
    private static final String REPORT_SUBDIR = String.valueOf(new Date().getTime());
    private static final List<GalenTestInfo> ALL_TESTS = new LinkedList<GalenTestInfo>();
    private String reportBase;
    private List<String> includedTags;
    private List<String> excludedTags;
    private String layoutCheckName;
    private LayoutReport layoutReport;
    private TestStatistic testStatistic;

    public LayoutTest() {
        this.reportBase = new File(this.filesDir, "galen-reports/" + REPORT_SUBDIR).getPath();
        this.includedTags = Collections.emptyList();
        this.excludedTags = Collections.emptyList();
        this.layoutReport = new LayoutReport();
        this.testStatistic = new TestStatistic();
    }

    public String verifyLayoutUsing(String specFile) throws IOException {
        String specPath = this.getFilePathFromWikiUrl(specFile);
        GalenTestInfo test = this.createGalenTestInfo();
        this.checkLayout(specPath, test);
        return this.report();
    }

    protected void checkLayout(String specPath, GalenTestInfo test) throws IOException {
        String reportTitle = this.getReportTitle(specPath, this.includedTags(), this.excludedTags());
        SectionFilter sectionFilter = new SectionFilter(this.includedTags(), this.excludedTags());
        this.checkLayout(specPath, test, reportTitle, sectionFilter, new Properties(), this.getCurrentValues());
    }

    protected void checkLayout(String specPath, GalenTestInfo test, String reportTitle, SectionFilter sectionFilter, Properties properties, Map<String, Object> jsVariables) throws IOException {
        TestReport report = test.getReport();
        this.testStatistic = new TestStatistic();
        this.layoutReport = Galen.checkLayout((WebDriver)this.getDriver(), (String)specPath, (SectionFilter)sectionFilter, (Properties)properties, jsVariables);
        report.layout(this.layoutReport, reportTitle);
        this.testStatistic = report.fetchStatistic();
        ALL_TESTS.add(test);
        this.setLayoutCheckName(null);
    }

    protected String getReportTitle(String specPath, List<String> includedTags, List<String> excludedTags) {
        String tagsMsg = "";
        if (includedTags != null && !includedTags.isEmpty()) {
            tagsMsg = tagsMsg + "; including " + includedTags;
        }
        if (excludedTags != null && !excludedTags.isEmpty()) {
            tagsMsg = tagsMsg + "; excluding " + excludedTags;
        }
        return String.format("Layout check using: %s%s", specPath, tagsMsg);
    }

    protected GalenTestInfo createGalenTestInfo() {
        String name = this.getGalenTestInfoName();
        return GalenTestInfo.fromString((String)name);
    }

    protected String getGalenTestInfoName() {
        String name = this.layoutCheckName();
        return name == null ? String.format("FitNesse%s%s", this.getClass().getSimpleName(), ALL_TESTS.size()) : name;
    }

    public int verifiedSpecCount() {
        return this.getTestStatistic().getTotal();
    }

    public int passedSpecCount() {
        return this.getTestStatistic().getPassed();
    }

    public int specErrorCount() {
        return this.getTestStatistic().getErrors();
    }

    public int specWarningCount() {
        return this.getTestStatistic().getWarnings();
    }

    public Object layoutCheckMessages() {
        List errorResults = this.getLayoutReport().getValidationErrorResults();
        return this.formatResultsForWiki(errorResults);
    }

    protected Map<List<String>, Map<String, List<String>>> formatResultsForWiki(List<ValidationResult> errorResults) {
        LinkedHashMap<List<String>, Map<String, List<String>>> result = new LinkedHashMap<List<String>, Map<String, List<String>>>();
        for (ValidationResult errorResult : errorResults) {
            List<String> key = this.formatValidationObjectsForWiki(errorResult.getValidationObjects());
            Map<String, List<String>> value = this.formatErrorForWiki(errorResult.getSpec(), errorResult.getError());
            if (result.containsKey(key)) {
                Map currentValue = (Map)result.get(key);
                this.addAllCurrentValues(value, currentValue);
            }
            result.put(key, value);
        }
        return result;
    }

    protected List<String> formatValidationObjectsForWiki(List<ValidationObject> validationObjects) {
        ArrayList<String> names = new ArrayList<String>();
        for (ValidationObject error : validationObjects) {
            names.add(error.getName());
        }
        return names;
    }

    protected Map<String, List<String>> formatErrorForWiki(Spec spec, ValidationError error) {
        String key = error.isOnlyWarn() ? "warning" : "error";
        key = key + " on: " + spec.toText();
        LinkedHashMap<String, List<String>> messageMap = new LinkedHashMap<String, List<String>>();
        List messages = error.getMessages();
        messageMap.put(key, new ArrayList(messages));
        return messageMap;
    }

    protected void addAllCurrentValues(Map<String, List<String>> value, Map<String, List<String>> currentValue) {
        for (Map.Entry<String, List<String>> currentEntries : currentValue.entrySet()) {
            String currentKey = currentEntries.getKey();
            List<String> currentValues = currentEntries.getValue();
            List<String> newValues = value.get(currentKey);
            if (newValues == null) {
                value.put(currentKey, currentValues);
                continue;
            }
            newValues.addAll(currentValues);
        }
    }

    public List<String> includedTags() {
        return this.includedTags;
    }

    public void setIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
    }

    public List<String> excludedTags() {
        return this.excludedTags;
    }

    public void setExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
    }

    public void setLayoutCheckName(String testName) {
        this.layoutCheckName = testName;
    }

    protected String layoutCheckName() {
        return this.layoutCheckName;
    }

    protected String report() throws IOException {
        this.generateHtmlReports();
        int testCount = ALL_TESTS.size();
        GalenTestInfo last = ALL_TESTS.get(testCount - 1);
        return this.createLinkToGalenReport(testCount, last);
    }

    protected String createLinkToGalenReport(int testCount, GalenTestInfo last) {
        String baseName = GalenUtils.convertToFileName((String)last.getName());
        String fileName = String.format("%s-%s.html", testCount, baseName);
        String testPath = new File(this.getReportBase(), fileName).getPath();
        return String.format("<a href=\"%s\">%s</a>", this.getWikiUrl(testPath), fileName);
    }

    protected void generateHtmlReports() throws IOException {
        String dir = this.getReportBase();
        new HtmlReportBuilder().build(ALL_TESTS, dir);
        String link = this.createRelativeLinkToOverallReport(dir);
        this.getEnvironment().setSymbol(REPORT_OVERVIEW_SYMBOL, link);
    }

    protected String createRelativeLinkToOverallReport(String dir) {
        String report = new File(dir, "report.html").getPath();
        String rootDir = this.getEnvironment().getFitNesseRootDir();
        return FileUtil.getRelativePath(rootDir, report);
    }

    protected LayoutReport getLayoutReport() {
        return this.layoutReport;
    }

    protected TestStatistic getTestStatistic() {
        return this.testStatistic;
    }

    protected String getReportBase() {
        return this.reportBase;
    }

    protected WebDriver getDriver() {
        return this.getEnvironment().getSeleniumHelper().driver();
    }

    public static String getOverallReportLink() {
        String file = Environment.getInstance().getSymbol(REPORT_OVERVIEW_SYMBOL);
        return file == null ? null : String.format("<a href=\"%s\">Layout Test's Galen Reports</a>", file);
    }
}

