/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.hsac.fitnesse.fixture.slim.web.NgBrowserTestBase;
import nl.hsac.fitnesse.fixture.slim.web.annotation.WaitUntil;
import nl.hsac.fitnesse.fixture.util.selenium.by.GridBy;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class NgBrowserTest
extends NgBrowserTestBase {
    public NgBrowserTest() {
        super("var rootSelector = arguments[0];\nvar el = document.querySelector(rootSelector);\n\n  try {\n    if (!window.angular) {\n      throw new Error('angular could not be found on the window');\n    }\n    if (angular.getTestability) {\n      angular.getTestability(el).whenStable(callback);\n    } else {\n      if (!angular.element(el).injector()) {\n        throw new Error('root element (' + rootSelector + ') has no injector.' +\n           ' this may mean it is not inside ng-app.');\n      }\n      angular.element(el).injector().get('$browser').\n          notifyWhenNoOutstandingRequests(callback);\n    }\n  } catch (err) {\n    callback(err.message);\n  }");
        this.setAngularRoot("[ng-app], [ng_app], [data-ng-app], [x-ng-app], [ng\\:app]");
    }

    public NgBrowserTest(int secondsBeforeTimeout) {
        super(secondsBeforeTimeout, "var rootSelector = arguments[0];\nvar el = document.querySelector(rootSelector);\n\n  try {\n    if (!window.angular) {\n      throw new Error('angular could not be found on the window');\n    }\n    if (angular.getTestability) {\n      angular.getTestability(el).whenStable(callback);\n    } else {\n      if (!angular.element(el).injector()) {\n        throw new Error('root element (' + rootSelector + ') has no injector.' +\n           ' this may mean it is not inside ng-app.');\n      }\n      angular.element(el).injector().get('$browser').\n          notifyWhenNoOutstandingRequests(callback);\n    }\n  } catch (err) {\n    callback(err.message);\n  }");
        this.setAngularRoot("[ng-app], [ng_app], [data-ng-app], [x-ng-app], [ng\\:app]");
    }

    @Override
    public void waitForAngularRequestsToFinish() {
        String root = this.getAngularRoot();
        if (root == null) {
            this.setAngularRoot("body");
        }
        super.waitForAngularRequestsToFinish();
    }

    @Override
    public String valueFor(String place) {
        WebElement element = this.findByTechnicalSelectorOr(place, this::getAngularElement);
        String result = element == null ? super.valueFor(place) : this.valueFor(element);
        return result;
    }

    @Override
    public boolean selectFor(String value, String place) {
        WebElement element = this.findByTechnicalSelectorOr(place, this::findSelect);
        boolean result = element == null ? super.selectFor(value, place) : this.clickSelectOption(element, value);
        return result;
    }

    @Override
    public boolean enterAs(String value, String place) {
        WebElement input = this.findByTechnicalSelectorOr(place, this::getAngularElementToEnterIn);
        boolean result = input == null ? super.enterAs(value, place) : this.enter(input, value, true);
        return result;
    }

    public int numberOf(String repeater) {
        return this.findRepeaterRows(repeater).size();
    }

    @WaitUntil
    public String valueOfColumnNumberInRowNumberOf(int columnIndex, int rowIndex, String repeater) {
        return this.getTextInRepeaterColumn(Integer.toString(columnIndex), rowIndex, repeater);
    }

    @WaitUntil
    public String valueOfInRowNumberOf(String columnName, int rowIndex, String repeater) {
        String columnIndex = this.getXPathForColumnIndex(columnName);
        return this.getTextInRepeaterColumn(columnIndex, rowIndex, repeater);
    }

    @WaitUntil
    public String valueOfInRowWhereIsOf(String requestedColumnName, String selectOnColumn, String selectOnValue, String repeater) {
        String result = null;
        String compareIndex = this.getXPathForColumnIndex(selectOnColumn);
        List<WebElement> rows = this.findRepeaterRows(repeater);
        for (WebElement row : rows) {
            String compareValue = this.getColumnText(row, compareIndex);
            if ((selectOnValue != null || compareValue != null) && (selectOnValue == null || !selectOnValue.equals(compareValue))) continue;
            String requestedIndex = this.getXPathForColumnIndex(requestedColumnName);
            result = this.getColumnText(row, requestedIndex);
            break;
        }
        return result;
    }

    protected String getXPathForColumnIndex(String columnName) {
        return GridBy.getXPathForColumnIndex(columnName);
    }

    protected String getTextInRepeaterColumn(String columnIndexXPath, int rowIndex, String repeater) {
        String result = null;
        List<WebElement> rows = this.findRepeaterRows(repeater);
        if (rows.size() >= rowIndex) {
            WebElement row = rows.get(rowIndex - 1);
            result = this.getColumnText(row, columnIndexXPath);
        }
        return result;
    }

    private String getColumnText(WebElement row, String columnIndexXPath) {
        By xPath = this.getSeleniumHelper().byXpath("td[%s]", columnIndexXPath);
        WebElement cell = row.findElement(xPath);
        return this.getElementText(cell);
    }

    protected WebElement getAngularElementToEnterIn(String place) {
        return this.findElement(place);
    }

    protected WebElement getAngularElement(String place) {
        WebElement element = this.findBinding(place);
        if (element == null) {
            element = this.findElement(place);
        }
        return element;
    }

    protected WebElement findBinding(String place) {
        return this.findNgElementByJavascript("var rootSelector = arguments[3];\nvar using = arguments[2];\nvar exactMatch = arguments[1];\nvar binding = arguments[0];\n  var root = document.querySelector(rootSelector || 'body');\n  using = using || document;\n  if (angular.getTestability) {\n    return angular.getTestability(root).\n        findBindings(using, binding, exactMatch);\n  }\n  var bindings = using.getElementsByClassName('ng-binding');\n  var matches = [];\n  for (var i = 0; i < bindings.length; ++i) {\n    var dataBinding = angular.element(bindings[i]).data('$binding');\n    if (dataBinding) {\n      var bindingName = dataBinding.exp || dataBinding[0].exp || dataBinding;\n      if (exactMatch) {\n        var matcher = new RegExp('({|\\\\s|^|\\\\|)' + binding + '(}|\\\\s|$|\\\\|)');\n        if (matcher.test(bindingName)) {\n          matches.push(bindings[i]);\n        }\n      } else {\n        if (bindingName.indexOf(binding) != -1) {\n          matches.push(bindings[i]);\n        }\n      }\n\n    }\n  }\n  return matches; /* Return the whole array for webdriver.findElements. */\n", place, true, null);
    }

    protected WebElement findSelect(String place) {
        return this.findByJavascript("var using = arguments[1] || document;\nvar model = arguments[0];\nvar prefixes = ['ng-', 'ng_', 'data-ng-', 'x-ng-', 'ng\\\\:'];\nfor (var p = 0; p < prefixes.length; ++p) {\n    var selector = 'select[' + prefixes[p] + 'model=\"' + model + '\"]';\n    var inputs = using.querySelectorAll(selector);\n    if (inputs.length) {\n        return inputs;\n    }\n}", place);
    }

    protected WebElement findElement(String place) {
        return this.findNgElementByJavascript("var using = arguments[1] || document;\nvar model = arguments[0];\nvar rootSelector = arguments[2];\nvar root = document.querySelector(rootSelector || 'body');\n  using = using || document;\n\n  if (angular.getTestability) {\n    return angular.getTestability(root).\n        findModels(using, model, true);\n  }\n  var prefixes = ['ng-', 'ng_', 'data-ng-', 'x-ng-', 'ng\\\\:'];\n  for (var p = 0; p < prefixes.length; ++p) {\n    var selector = '[' + prefixes[p] + 'model=\"' + model + '\"]';\n    var elements = using.querySelectorAll(selector);\n    if (elements.length) {\n      return elements;\n    }\n  }", place, null);
    }

    protected List<WebElement> findRepeaterRows(String repeater) {
        return this.findAllByJavascript("var using = arguments[2] || document;\nvar exact = arguments[1];\nvar repeater = arguments[0];\n  function repeaterMatch(ngRepeat, repeater, exact) {\n    if (exact) {\n      return ngRepeat.split(' track by ')[0].split(' as ')[0].split('|')[0].\n          trim() == repeater;\n    } else {\n      return ngRepeat.indexOf(repeater) != -1;\n    }\n  }\n\n  using = using || document;\n\n  var rows = [];\n  var prefixes = ['ng-', 'ng_', 'data-ng-', 'x-ng-', 'ng\\\\:'];\n  for (var p = 0; p < prefixes.length; ++p) {\n    var attr = prefixes[p] + 'repeat';\n    var repeatElems = using.querySelectorAll('[' + attr + ']');\n    attr = attr.replace(/\\\\/g, '');\n    for (var i = 0; i < repeatElems.length; ++i) {\n      if (repeaterMatch(repeatElems[i].getAttribute(attr), repeater, exact)) {\n        rows.push(repeatElems[i]);\n      }\n    }\n  }\n  for (var p = 0; p < prefixes.length; ++p) {\n    var attr = prefixes[p] + 'repeat-start';\n    var repeatElems = using.querySelectorAll('[' + attr + ']');\n    attr = attr.replace(/\\\\/g, '');\n    for (var i = 0; i < repeatElems.length; ++i) {\n      if (repeaterMatch(repeatElems[i].getAttribute(attr), repeater, exact)) {\n        var elem = repeatElems[i];\n        while (elem.nodeType != 8 ||\n            !repeaterMatch(elem.nodeValue, repeater, exact)) {\n          if (elem.nodeType == 1) {\n            rows.push(elem);\n          }\n          elem = elem.nextSibling;\n        }\n      }\n    }\n  }\n  return rows;", repeater, true);
    }

    protected List<WebElement> findNgElementsByJavascript(String script, Object ... parameters) {
        Object[] arguments = this.getFindArguments(parameters);
        return this.findAllByJavascript(script, arguments);
    }

    protected WebElement findNgElementByJavascript(String script, Object ... parameters) {
        Object[] arguments = this.getFindArguments(parameters);
        return this.findByJavascript(script, arguments);
    }

    private Object[] getFindArguments(Object[] parameters) {
        ArrayList<Object> params = new ArrayList<Object>(parameters.length + 1);
        params.addAll(Arrays.asList(parameters));
        params.add(this.getAngularRoot());
        return params.toArray();
    }
}

