/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim.web;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import nl.hsac.fitnesse.fixture.slim.StopTestException;
import nl.hsac.fitnesse.fixture.slim.web.BrowserTest;
import nl.hsac.fitnesse.fixture.slim.web.annotation.NoNgWait;
import nl.hsac.fitnesse.slim.interaction.ReflectionHelper;
import org.openqa.selenium.WebElement;

public abstract class NgBrowserTestBase
extends BrowserTest<WebElement> {
    private static final Set<String> METHODS_NO_WAIT = ReflectionHelper.validateMethodNames(NgBrowserTestBase.class, "open", "takeScreenshot", "location", "back", "forward", "refresh", "alertText", "confirmAlert", "dismissAlert", "openInNewTab", "ensureActiveTabIsNotClosed", "currentTabIndex", "tabCount", "ensureOnlyOneTab", "closeTab", "setAngularRoot", "switchToNextTab", "switchToPreviousTab", "switchToDefaultContent", "switchToFrame", "switchToParentFrame", "waitForAngularRequestsToFinish", "secondsBeforeTimeout", "secondsBeforePageLoadTimeout", "waitForPage", "waitForTagWithText", "waitForClassWithText", "waitForClass", "waitForVisible", "waitSeconds", "waitMilliseconds", "waitMilliSecondAfterScroll", "screenshotBaseDirectory", "screenshotShowHeight", "setBrowserWidth", "setBrowserHeight", "setBrowserSizeToBy", "setBrowserSizeToMaximum", "setGlobalValueTo", "setSendCommandForControlOnMacTo", "sendCommandForControlOnMac", "isImplicitWaitForAngularEnabled", "setImplicitWaitForAngularTo", "globalValue", "clearSearchContext", "setAngularRoot", "getAngularRoot", "executeScript", "secondsBeforeTimeout", "secondsBeforePageLoadTimeout", "trimOnNormalize", "setImplicitFindInFramesTo", "setTrimOnNormalize", "setRepeatIntervalToMilliseconds", "repeatAtMostTimes", "repeatAtMostTimes", "timeSpentRepeating");
    private final String waitForAngularScript;
    private String angularRoot;

    public NgBrowserTestBase(String waitForAngular) {
        this.setImplicitWaitForAngularTo(true);
        this.waitForAngularScript = waitForAngular;
    }

    public NgBrowserTestBase(int secondsBeforeTimeout, String waitForAngular) {
        super(secondsBeforeTimeout);
        this.setImplicitWaitForAngularTo(true);
        this.waitForAngularScript = waitForAngular;
    }

    @Override
    protected void waitForAngularIfNeeded(Method method) {
        if (this.isImplicitWaitForAngularEnabled() && this.requiresWaitForAngular(method)) {
            this.waitForAngularRequestsToFinish();
        }
    }

    protected boolean requiresWaitForAngular(Method method) {
        String methodName = method.getName();
        return !METHODS_NO_WAIT.contains(methodName) && !this.hasNoWaitAnnotation(method);
    }

    protected boolean hasNoWaitAnnotation(Method method) {
        return method.isAnnotationPresent(NoNgWait.class);
    }

    @Override
    public boolean open(String address) {
        boolean result = super.open(address);
        if (result && this.isImplicitWaitForAngularEnabled()) {
            this.waitForAngularRequestsToFinish();
        }
        return result;
    }

    public void waitForAngularRequestsToFinish() {
        String root = this.getAngularRoot();
        try {
            this.waitForAngularRequestsToFinish(root);
        }
        catch (RuntimeException e) {
            this.handleExceptionWhileWaiting(root, e);
        }
    }

    protected void waitForAngularRequestsToFinish(String root) {
        Object result = this.waitForJavascriptCallback(this.waitForAngularScript, root);
        if (result != null && !(result instanceof Boolean)) {
            String msg = this.getSlimFixtureExceptionMessage("angular", result.toString(), null);
            throw new StopTestException(false, msg);
        }
    }

    protected void handleExceptionWhileWaiting(String rootSelector, RuntimeException e) {
        List roots;
        try {
            roots = this.findAllByCss(rootSelector, new String[0]);
        }
        catch (RuntimeException ex) {
            System.err.print("Problem using rootSelector: " + rootSelector);
            ex.printStackTrace();
            throw e;
        }
        if (roots.isEmpty()) {
            System.err.println("Unable to locate Angular root element. Please configure it explicitly using setAngularRoot(selector)");
        } else if (roots.size() == 1) {
            System.err.println("Found Angular. Single root element found, but error while waiting for requests to finish.");
        } else {
            System.err.println("Found Angular. Multiple root elements seem to be present: " + roots.size() + " using root selector: " + rootSelector);
        }
        System.err.println("Retrying once");
        this.waitForAngularRequestsToFinish(rootSelector);
    }

    public String getAngularRoot() {
        return this.angularRoot;
    }

    public void setAngularRoot(String anAngularRoot) {
        this.angularRoot = anAngularRoot;
    }
}

