/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim.web;

import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.slim.web.BrowserTest;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.ScriptTimeoutException;
import org.openqa.selenium.WebElement;

public class RichFacesTest
extends BrowserTest<WebElement> {
    protected static final String RICH_FACES_AJAX_CALL = "RichFaces.ajax(";
    private final List<String> eventsThatMayRequireWaiting = new ArrayList<String>(Arrays.asList("onchange", "onclick"));
    private boolean ajaxStartWithOnly = false;
    private boolean ignoreImplicitAjaxWaitTimeouts = true;
    private boolean shouldWaitForAjax = false;
    private String previousLocation = null;

    public RichFacesTest() {
    }

    public RichFacesTest(int secondsBeforeTimeout) {
        super(secondsBeforeTimeout);
    }

    public boolean onlyWaitIfEventHandlerStartsWithAjaxCall() {
        return this.ajaxStartWithOnly;
    }

    public void setOnlyWaitIfEventHandlerStartsWithAjaxCall(boolean newValue) {
        this.ajaxStartWithOnly = newValue;
    }

    @Override
    protected void beforeInvoke(Method method, Object[] arguments) {
        this.setShouldWaitForAjax(false);
        super.beforeInvoke(method, arguments);
    }

    @Override
    protected Object invoke(FixtureInteraction interaction, Method method, Object[] arguments) throws Throwable {
        Object result = super.invoke(interaction, method, arguments);
        if (this.shouldWaitForAjax()) {
            try {
                this.waitForJsfAjaxImpl(true);
            }
            catch (ScriptTimeoutException e) {
                if (this.ignoreImplicitAjaxWaitTimeouts) {
                    System.err.println("Timeout while waiting for ajax call after: " + method.getName() + " with arguments: " + Arrays.toString(arguments));
                    String msg = this.createAjaxTimeoutMessage(e);
                    System.err.println("Exception not forwarded to wiki: " + msg);
                }
                throw this.createAjaxTimeout(e);
            }
        }
        return result;
    }

    @Override
    protected void sendValue(WebElement element, String value) {
        boolean triggersAjax = this.willTriggerAjax(element);
        super.sendValue(element, value);
        if (triggersAjax) {
            this.pressTab();
            this.setShouldWaitForAjax(true);
        }
    }

    @Override
    protected boolean clickSelectOption(WebElement element, String optionValue) {
        boolean triggersAjax = this.willTriggerAjax(element);
        boolean result = super.clickSelectOption(element, optionValue);
        if (triggersAjax && result) {
            this.setShouldWaitForAjax(true);
        }
        return result;
    }

    @Override
    protected boolean clickElement(WebElement element) {
        boolean triggersAjax = this.willTriggerAjax(element);
        boolean result = super.clickElement(element);
        if (triggersAjax && result) {
            this.setShouldWaitForAjax(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean repeatUntil(SlimFixture.RepeatCompletion repeat) {
        boolean previousWaitForAjax = this.shouldWaitForAjax();
        this.setShouldWaitForAjax(true);
        try {
            boolean bl = super.repeatUntil(repeat);
            return bl;
        }
        finally {
            this.setShouldWaitForAjax(previousWaitForAjax);
        }
    }

    protected boolean willTriggerAjax(WebElement element) {
        return this.shouldWaitForAjax() || this.hasRichFacesAjax(element);
    }

    protected boolean hasRichFacesAjax(WebElement element) {
        WebElement labelTarget;
        String tagName;
        if (element == null) {
            return false;
        }
        boolean result = this.isAjaxEventPresent(element);
        if (!result && "label".equalsIgnoreCase(tagName = element.getTagName()) && (labelTarget = this.getSeleniumHelper().getLabelledElement(element)) != null) {
            result = this.isAjaxEventPresent(labelTarget);
        }
        if (result) {
            this.storeLocationBeforeAction();
        }
        return result;
    }

    protected boolean isAjaxEventPresent(WebElement element) {
        String event;
        boolean result = false;
        Iterator<String> iterator = this.getEventsThatMayRequireWaiting().iterator();
        while (iterator.hasNext() && !(result = this.eventTriggersAjax(element, event = iterator.next()))) {
        }
        return result;
    }

    protected void storeLocationBeforeAction() {
        this.previousLocation = this.location();
    }

    protected boolean eventTriggersAjax(WebElement element, String attribute) {
        String eventHandler = element.getAttribute(attribute);
        return eventHandler != null && (this.ajaxStartWithOnly ? eventHandler.startsWith(RICH_FACES_AJAX_CALL) : eventHandler.contains(RICH_FACES_AJAX_CALL));
    }

    public void waitForJsfAjax() {
        try {
            this.waitForJsfAjaxImpl(false);
        }
        catch (ScriptTimeoutException e) {
            throw this.createAjaxTimeout(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForJsfAjaxImpl(boolean checkLocation) {
        block8: {
            try {
                if (checkLocation) {
                    this.waitForJavascriptCallback("if(!window.jsf||window.location.href!==arguments[0]){callback();}else{jsf.ajax.addOnEvent(function(data){if(data.status=='success')callback();});}", this.previousLocation);
                } else {
                    this.waitForJavascriptCallback("if(!window.jsf){callback();}else{jsf.ajax.addOnEvent(function(data){if(data.status=='success')callback();});}", new Object[0]);
                }
            }
            catch (JavascriptException e) {
                String msg = e.getMessage();
                if (msg.startsWith("javascript error: document unloaded while waiting for result")) {
                    break block8;
                }
                throw e;
            }
            finally {
                this.setShouldWaitForAjax(false);
            }
        }
    }

    protected void setShouldWaitForAjax(boolean shouldWaitForAjax) {
        this.shouldWaitForAjax = shouldWaitForAjax;
    }

    protected boolean shouldWaitForAjax() {
        return this.shouldWaitForAjax;
    }

    public List<String> getEventsThatMayRequireWaiting() {
        return this.eventsThatMayRequireWaiting;
    }

    public void setIgnoreImplicitAjaxWaitTimeouts(boolean ignoreAjaxWaitTimeouts) {
        this.ignoreImplicitAjaxWaitTimeouts = ignoreAjaxWaitTimeouts;
    }

    public boolean willIgnoreImplicitAjaxWaitTimeouts() {
        return this.ignoreImplicitAjaxWaitTimeouts;
    }

    protected AjaxTimeout createAjaxTimeout(ScriptTimeoutException e) {
        return new AjaxTimeout(this.createAjaxTimeoutMessage(e), e);
    }

    protected String createAjaxTimeoutMessage(ScriptTimeoutException e) {
        String messageBase = "Did not detect completion of RichFaces ajax call: " + e.getMessage();
        return this.getSlimFixtureExceptionMessage("timeouts", "rfAjaxTimeout", messageBase, e);
    }

    public static class AjaxTimeout
    extends SlimFixtureException {
        public AjaxTimeout(String message, ScriptTimeoutException e) {
            super(false, message, (Throwable)e);
        }
    }
}

