/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.slim.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.slim.SlimFixture;
import nl.hsac.fitnesse.fixture.util.selenium.SauceLabsHelper;
import nl.hsac.fitnesse.fixture.util.selenium.SeleniumHelper;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverFactory;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverManager;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.LocalDriverFactory;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.ProjectDriverFactoryFactory;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.RemoteDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SeleniumDriverSetup
extends SlimFixture {
    private static final String LAST_RUN_SUMMARY = "SeleniumLastRunSummary";
    protected static boolean OVERRIDE_ACTIVE = false;
    private final List<String> secretCapabilities = new ArrayList<String>();

    public boolean setPropertyValue(String propName, String value) {
        if (OVERRIDE_ACTIVE) {
            return true;
        }
        System.setProperty(propName, value);
        return true;
    }

    public boolean startDriver(String driverClassName, Map<String, Object> profile) throws Exception {
        if (OVERRIDE_ACTIVE) {
            return true;
        }
        LocalDriverFactory driverFactory = new LocalDriverFactory(driverClassName, profile);
        WebDriver driver = this.setAndUseDriverFactory(driverFactory);
        return driver != null;
    }

    public boolean startDriver(String driverClassName) throws Exception {
        return this.startDriver(driverClassName, null);
    }

    public boolean startDriverForWithProfile(String browser, Map<String, Object> profile) throws Exception {
        if (OVERRIDE_ACTIVE) {
            return true;
        }
        LocalDriverFactory driverFactory = new ProjectDriverFactoryFactory().create(browser, profile);
        WebDriver driver = this.setAndUseDriverFactory(driverFactory);
        return driver != null;
    }

    public boolean startDriverFor(String browser) throws Exception {
        return this.startDriverForWithProfile(browser, null);
    }

    public boolean connectToDriverForAt(String browser, String url) throws MalformedURLException {
        return this.connectToDriverForVersionOnAt(browser, "", Platform.ANY.name(), url);
    }

    public boolean connectToDriverForOnAt(String browser, String platformName, String url) throws MalformedURLException {
        return this.connectToDriverForVersionOnAt(browser, "", platformName, url);
    }

    public boolean connectToDriverForVersionOnAt(String browser, String version, String platformName, String url) throws MalformedURLException {
        Platform platform = Platform.valueOf((String)platformName);
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(browser, version, platform);
        desiredCapabilities.setVersion(version);
        return this.createAndSetRemoteDriver(url, desiredCapabilities);
    }

    public boolean connectToDriverAtWithCapabilities(String url, Map<String, Object> capabilities) throws MalformedURLException {
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(capabilities);
        return this.createAndSetRemoteDriver(url, desiredCapabilities);
    }

    public boolean connectToFirefoxDriverAtWithProfile(String url, Map<String, Object> profile) throws MalformedURLException {
        FirefoxProfile fxProfile = LocalDriverFactory.getFirefoxProfile(profile);
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
        desiredCapabilities.setCapability("browserName", "firefox");
        desiredCapabilities.setCapability("firefox_profile", (Object)fxProfile);
        return this.createAndSetRemoteDriver(url, desiredCapabilities);
    }

    public boolean connectToDriverAtWithJsonCapabilities(String url, String capabilitiesInJson) throws MalformedURLException {
        Map<String, Object> desiredCapabilities = this.getEnvironment().getJsonHelper().jsonStringToMap(capabilitiesInJson);
        return this.connectToDriverAtWithCapabilities(url, desiredCapabilities);
    }

    public String driverDescription() {
        String result = null;
        WebDriver driver = this.getHelper().driver();
        if (driver != null) {
            StringBuilder builder = new StringBuilder("<div>");
            builder.append("<pre>");
            builder.append(driver.getClass().getName());
            builder.append("</pre>");
            if (driver instanceof RemoteWebDriver) {
                RemoteWebDriver remoteDriver = (RemoteWebDriver)driver;
                URL lastRemoteUrl = SeleniumDriverSetup.getLastRemoteUrl();
                if (lastRemoteUrl != null) {
                    builder.append(" at <strong>");
                    builder.append(lastRemoteUrl.getHost());
                    builder.append("</strong>");
                }
                builder.append(this.describeCapabilities(remoteDriver));
                builder.append(this.extendedDriverDescription(lastRemoteUrl));
            }
            builder.append("</div>");
            result = builder.toString();
        }
        return result;
    }

    public String runSummary() {
        URL lastRemoteUrl;
        String result = null;
        String sessionId = this.getHelper().getSessionId();
        if (sessionId != null && !"".equals(sessionId) && (lastRemoteUrl = SeleniumDriverSetup.getLastRemoteUrl()) != null && SauceLabsHelper.isRelevant(lastRemoteUrl)) {
            result = SauceLabsHelper.getTagToEmbedVideoOfRun(lastRemoteUrl, sessionId);
        }
        this.getEnvironment().setSymbol(LAST_RUN_SUMMARY, result);
        return result;
    }

    public static String getLastRunSummary() {
        return Environment.getInstance().getSymbol(LAST_RUN_SUMMARY);
    }

    protected String describeCapabilities(RemoteWebDriver remoteDriver) {
        Capabilities capabilities = remoteDriver.getCapabilities();
        Map<String, ?> capaToShow = this.getCapabilitiesToDescribe(capabilities);
        StringBuilder result = new StringBuilder("<table><tbody>");
        for (Map.Entry<String, ?> entry : capaToShow.entrySet()) {
            result.append("<tr><th>");
            result.append(entry.getKey());
            result.append("</th><td>");
            result.append(entry.getValue());
            result.append("</td></tr>");
        }
        result.append("</tbody></table>");
        return result.toString();
    }

    protected Map<String, ?> getCapabilitiesToDescribe(Capabilities capabilities) {
        Map<String, Object> result = capabilities.asMap();
        List<String> keysToMask = this.getSecretCapabilities();
        if (!keysToMask.isEmpty()) {
            result = this.getEnvironment().getSecretMasker().replaceSecrets(keysToMask, result);
        }
        return result;
    }

    protected String extendedDriverDescription(URL lastRemoteUrl) {
        String result = "";
        if (SauceLabsHelper.isRelevant(lastRemoteUrl)) {
            String jobLink = SauceLabsHelper.getJobLink(lastRemoteUrl, this.getHelper().getSessionId());
            result = String.format("<a href=\"%s\" target=\"_blank\">Job details</a>", jobLink);
        }
        return result;
    }

    protected boolean createAndSetRemoteDriver(String url, DesiredCapabilities desiredCapabilities) throws MalformedURLException {
        return this.createAndSetRemoteWebDriver(RemoteWebDriver::new, url, desiredCapabilities);
    }

    protected boolean createAndSetRemoteWebDriver(BiFunction<URL, Capabilities, ? extends RemoteWebDriver> constr, String url, DesiredCapabilities desiredCapabilities) throws MalformedURLException {
        if (OVERRIDE_ACTIVE) {
            return true;
        }
        String cleanUrl = this.cleanupValue(url);
        RemoteDriverFactory<? extends RemoteWebDriver> driverFactory = new RemoteDriverFactory<RemoteWebDriver>(constr, cleanUrl, (Capabilities)desiredCapabilities);
        WebDriver driver = this.setAndUseDriverFactory(driverFactory);
        return driver != null;
    }

    public static URL getLastRemoteUrl() {
        URL result = null;
        String urlValue = Environment.getInstance().getSymbol("SeleniumRemoteUrl");
        if (urlValue != null) {
            try {
                result = new URL(urlValue);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    protected WebDriver setAndUseDriverFactory(DriverFactory driverFactory) {
        DriverManager driverManager = this.getEnvironment().getSeleniumDriverManager();
        driverManager.setFactory(driverFactory);
        return driverManager.getSeleniumHelper().driver();
    }

    public boolean stopDriver() {
        if (OVERRIDE_ACTIVE) {
            return true;
        }
        this.runSummary();
        this.getEnvironment().getSeleniumDriverManager().closeDriver();
        return true;
    }

    public List<String> getSecretCapabilities() {
        return this.secretCapabilities;
    }

    public static void lockConfig() {
        OVERRIDE_ACTIVE = true;
    }

    public static void unlockConfig() {
        OVERRIDE_ACTIVE = false;
    }

    protected SeleniumHelper getHelper() {
        return Environment.getInstance().getSeleniumHelper();
    }
}

