/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.net.MalformedURLException;
import java.net.URL;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;

public class BinaryHttpResponse
extends HttpResponse {
    private byte[] responseContent;
    private String fileName;

    public byte[] getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(byte[] aResponseContent) {
        this.responseContent = aResponseContent;
    }

    public String getFileName() {
        if (this.fileName == null) {
            try {
                String reqUrl = this.getRequest();
                URL url = new URL(reqUrl);
                String path = url.getPath();
                this.fileName = FilenameUtils.getName((String)path);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.fileName;
    }

    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    @Override
    public String getResponse() {
        String result = null;
        result = this.responseContent != null ? new Base64().encodeToString(this.responseContent) : super.getResponse();
        return result;
    }

    @Override
    public void setResponse(String aResponse) {
        if (aResponse != null) {
            try {
                byte[] content = new Base64().decode(aResponse);
                this.responseContent = content;
            }
            catch (Exception e) {
                this.responseContent = null;
            }
        } else {
            this.responseContent = null;
        }
        super.setResponse(aResponse);
    }

    @Override
    public String toString() {
        String result = this.getFileName() != null && this.responseContent != null ? this.getFileName() + ": " + this.responseContent.length + " bytes" : this.getClass().getName() + ": " + this.getRequest();
        return result;
    }
}

