/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

public final class CalendarUtil {
    public XMLGregorianCalendar buildXMLGregorianCalendar() {
        return this.buildXMLGregorianCalendarDate(new GregorianCalendar());
    }

    public XMLGregorianCalendar addDays(XMLGregorianCalendar cal, int amount) {
        XMLGregorianCalendar to = this.buildXMLGregorianCalendarDate(cal);
        to.add(this.addDays(amount));
        return to;
    }

    public XMLGregorianCalendar addMonths(XMLGregorianCalendar cal, int amount) {
        XMLGregorianCalendar to = this.buildXMLGregorianCalendarDate(cal);
        to.add(this.addMonths(amount));
        return to;
    }

    public XMLGregorianCalendar addYears(XMLGregorianCalendar cal, int amount) {
        XMLGregorianCalendar to = this.buildXMLGregorianCalendarDate(cal);
        to.add(this.addYears(amount));
        return to;
    }

    public XMLGregorianCalendar buildXMLGregorianCalendarDate(XMLGregorianCalendar cal) {
        XMLGregorianCalendar result = null;
        if (cal != null) {
            result = this.newXMLGregorianCalendar(cal.getDay(), cal.getMonth(), cal.getYear());
        }
        return result;
    }

    public XMLGregorianCalendar buildXMLGregorianCalendarDate(Date date) {
        XMLGregorianCalendar result = null;
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            result = this.buildXMLGregorianCalendarDate(cal);
        }
        return result;
    }

    public XMLGregorianCalendar buildXMLGregorianCalendarDate(Calendar cal) {
        XMLGregorianCalendar result = null;
        if (cal != null) {
            result = this.newXMLGregorianCalendar(cal.get(5), cal.get(2) + 1, cal.get(1));
        }
        return result;
    }

    private XMLGregorianCalendar newXMLGregorianCalendar(int day, int month, int year) {
        return this.getDatatypeFactory().newXMLGregorianCalendar(year, month, day, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public XMLGregorianCalendar buildXMLGregorianCalendar(String dateString) {
        return this.getDatatypeFactory().newXMLGregorianCalendar(dateString);
    }

    public XMLGregorianCalendar buildXMLGregorianCalendarDateTime(GregorianCalendar cal) {
        return this.getDatatypeFactory().newXMLGregorianCalendar(cal);
    }

    public int getDurationInYears(XMLGregorianCalendar startDate, XMLGregorianCalendar endDate) {
        int startYear = startDate.getYear();
        int dec = 12;
        if (startDate.getMonth() == 12) {
            ++startYear;
        }
        int endYear = endDate.getYear();
        return endYear - startYear;
    }

    public XMLGregorianCalendar getCurrentFirstOfMonthDate() {
        XMLGregorianCalendar result = this.buildXMLGregorianCalendar();
        result.setDay(1);
        return result;
    }

    Duration addDays(int amount) {
        Duration duration = amount < 0 ? this.getDatatypeFactory().newDuration(false, 0, 0, Math.abs(amount), 0, 0, 0) : this.getDatatypeFactory().newDuration(true, 0, 0, amount, 0, 0, 0);
        return duration;
    }

    Duration addMonths(int amount) {
        Duration duration = amount < 0 ? this.getDatatypeFactory().newDuration(false, 0, Math.abs(amount), 0, 0, 0, 0) : this.getDatatypeFactory().newDuration(true, 0, amount, 0, 0, 0, 0);
        return duration;
    }

    Duration addYears(int amount) {
        Duration duration = amount < 0 ? this.getDatatypeFactory().newDuration(false, Math.abs(amount), 0, 0, 0, 0, 0) : this.getDatatypeFactory().newDuration(true, amount, 0, 0, 0, 0, 0);
        return duration;
    }

    private DatatypeFactory getDatatypeFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException("Incorrect configuration, unable to get DatatypeFactory instance", e);
        }
    }
}

