/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatesHelper {
    private String dayPattern = "%s_day";
    private String monthPattern = "%s_month";
    private String yearPattern = "%s_year";
    private static final Pattern XML_DATE = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})");
    private static final Pattern NL_DATE = Pattern.compile("(\\d{1,2})-(\\d{1,2})-(\\d{4})");

    public void addDerivedDates(Map<String, Object> values) {
        HashMap<String, Object> valuesToAdd = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String key = entry.getKey();
            Object object = entry.getValue();
            if (object == null) continue;
            String stringValue = object.toString();
            Matcher matcher = XML_DATE.matcher(stringValue);
            if (matcher.matches()) {
                this.handleXmlMatch(matcher, valuesToAdd, key);
                continue;
            }
            matcher = NL_DATE.matcher(stringValue);
            if (!matcher.matches()) continue;
            this.handleNLMatch(matcher, valuesToAdd, key);
        }
        values.putAll(valuesToAdd);
    }

    private void addDerivedDates(Map<String, Object> valuesToAddTo, String baseKey, String day, String month, String year) {
        valuesToAddTo.put(String.format(this.dayPattern, baseKey), this.forceLength2(day));
        valuesToAddTo.put(String.format(this.monthPattern, baseKey), this.forceLength2(month));
        valuesToAddTo.put(String.format(this.yearPattern, baseKey), year);
    }

    private String forceLength2(String group) {
        return String.format("%02d", Integer.valueOf(group));
    }

    public String getDayPattern() {
        return this.dayPattern;
    }

    public void setDayPattern(String dayPattern) {
        this.dayPattern = dayPattern;
    }

    public String getMonthPattern() {
        return this.monthPattern;
    }

    public void setMonthPattern(String monthPattern) {
        this.monthPattern = monthPattern;
    }

    public String getYearPattern() {
        return this.yearPattern;
    }

    public void setYearPattern(String yearPattern) {
        this.yearPattern = yearPattern;
    }

    private void handleXmlMatch(Matcher matcher, Map<String, Object> valuesToAdd, String key) {
        String day = matcher.group(3);
        String month = matcher.group(2);
        String year = matcher.group(1);
        this.addDerivedDates(valuesToAdd, key, day, month, year);
    }

    private void handleNLMatch(Matcher matcher, Map<String, Object> valuesToAdd, String key) {
        String day = matcher.group(1);
        String month = matcher.group(2);
        String year = matcher.group(3);
        this.addDerivedDates(valuesToAdd, key, day, month, year);
    }
}

