/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;

public final class FileUtil {
    private static final int BUFFER_SIZE = 4096;
    private static final String FILE_ENCODING = "UTF-8";

    private FileUtil() {
    }

    public static String loadFile(String filename) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = classLoader.getResourceAsStream(filename);
        if (is == null) {
            throw new IllegalArgumentException("Unable to locate: " + filename);
        }
        return FileUtil.streamToString(is, filename);
    }

    public static String streamToString(InputStream inputStream, String fileName) {
        return FileUtil.streamToString(inputStream, fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String streamToString(InputStream is, String name, Integer numberOfLines) {
        String result = null;
        try {
            try {
                if (numberOfLines == null) {
                    result = new Scanner(is, FILE_ENCODING).useDelimiter("\\A").next();
                } else {
                    Scanner scanner = new Scanner(is, FILE_ENCODING);
                    int resultNrOfLines = 1;
                    result = "";
                    while (scanner.hasNext()) {
                        result = result + scanner.nextLine() + System.lineSeparator();
                        if (++resultNrOfLines <= numberOfLines) continue;
                    }
                    scanner.close();
                    if (result.isEmpty()) {
                        result = null;
                    }
                }
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("Unable to read: " + name + ". Error: " + e.getMessage(), e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close: " + name, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFile(String source, String target) throws IOException {
        FileChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(target).getChannel();
            ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, inputChannel.size());
        }
        finally {
            if (inputChannel != null) {
                inputChannel.close();
            }
            if (outputChannel != null) {
                outputChannel.close();
            }
        }
        return new File(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static File writeFile(String filename, String content) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(filename, FILE_ENCODING);
            pw.write(content);
            pw.flush();
        }
        return new File(filename);
    }

    public static File writeFromScanner(String filename, Scanner sc) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(filename, FILE_ENCODING);
            while (sc.hasNextLine()) {
                String next = sc.nextLine();
                pw.write(next + System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Unable to write to: " + filename + ".tmp", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
        return new File(filename);
    }

    public static String saveToFile(String baseName, String extension, byte[] content) {
        String result;
        File output = FileUtil.determineFilename(baseName, extension);
        FileOutputStream target = null;
        try {
            target = new FileOutputStream(output);
            target.write(content);
            result = output.getAbsolutePath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (target != null) {
                try {
                    target.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static File determineFilename(String baseName, String extension) {
        File output;
        File parent;
        if (!StringUtils.isEmpty((CharSequence)extension)) {
            extension = "." + extension;
        }
        if (!(parent = (output = new File(baseName + extension)).getAbsoluteFile().getParentFile()).exists() && !parent.mkdirs()) {
            throw new IllegalArgumentException("Unable to create directory: " + parent.getAbsolutePath());
        }
        int i = 0;
        while (output.exists()) {
            String name = String.format("%s_%s%s", baseName, ++i, extension);
            output = new File(name);
        }
        return output;
    }

    public static String getRelativePath(String base, String child) {
        return new File(base).toURI().relativize(new File(child).toURI()).getPath();
    }

    public static File appendToFile(String filename, String extraContent, boolean onNewLine) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, true), FILE_ENCODING)));
            if (onNewLine) {
                pw.println();
            }
            pw.print(extraContent);
        }
        return new File(filename);
    }

    public static boolean delete(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                FileUtil.delete(c);
            }
        }
        f.delete();
        return !f.exists();
    }

    public static void copyTree(String source, String target) {
        final Path sourcePath = Paths.get(source, new String[0]);
        final Path targetPath = Paths.get(target, new String[0]);
        try {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(this.resolveTarget(dir), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, this.resolveTarget(file), StandardCopyOption.COPY_ATTRIBUTES);
                    return FileVisitResult.CONTINUE;
                }

                private Path resolveTarget(Path file) {
                    return targetPath.resolve(sourcePath.relativize(file));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy tree", e);
        }
    }
}

