/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FtpFileUtil {
    public static Integer getFileSizeOnFTPServer(String hostName, Integer port, String userName, String password, String filePath) {
        Integer result = null;
        String replyString = FtpFileUtil.executeCommandOnFTPServer(hostName, port, userName, password, "SIZE", filePath);
        if (replyString == null || !replyString.contains(" ")) {
            throw new RuntimeException(String.format("Unable to get size of the %s file. Got [%s] reply from FTP server.", filePath, replyString));
        }
        result = Integer.valueOf(replyString.split(" ")[1].replaceAll("[\r\n]", ""));
        return result;
    }

    public static String executeCommandOnFTPServer(String hostName, Integer port, String userName, String password, String command, String commandArgs) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)command)) {
            FTPClient ftpClient = new FTPClient();
            String errorMessage = "Unable to connect and execute %s command with argumments '%s' for FTP server '%s'.";
            try {
                FtpFileUtil.connectAndLoginOnFTPServer(ftpClient, hostName, port, userName, password);
                if (StringUtils.isBlank((CharSequence)commandArgs)) {
                    ftpClient.sendCommand(command);
                } else {
                    ftpClient.sendCommand(command, commandArgs);
                }
                FtpFileUtil.validatResponse(ftpClient);
                result = ftpClient.getReplyString();
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format(errorMessage, command, commandArgs, hostName), ex);
            }
            finally {
                FtpFileUtil.disconnectAndLogoutFromFTPServer(ftpClient, hostName);
            }
        }
        return result;
    }

    public static String uploadFileToFTPServer(String hostName, Integer port, String userName, String password, String localFileFullName, String remotePath) {
        String result = null;
        FTPClient ftpClient = new FTPClient();
        String errorMessage = "Unable to upload file '%s' for FTP server '%s'.";
        FileInputStream inputStream = null;
        try {
            FtpFileUtil.connectAndLoginOnFTPServer(ftpClient, hostName, port, userName, password);
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            File localFile = new File(localFileFullName);
            String remoteFile = remotePath + FilenameUtils.getName((String)localFileFullName);
            inputStream = new FileInputStream(localFile);
            boolean uploadFinished = ftpClient.storeFile(remoteFile, (InputStream)inputStream);
            result = uploadFinished ? String.format("File '%s' successfully uploaded", localFileFullName) : String.format("Failed upload '%s' file to FTP server. Got reply: %s", localFileFullName, ftpClient.getReplyString());
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(String.format(errorMessage, remotePath, hostName), ex);
            }
            catch (Throwable throwable) {
                FtpFileUtil.closeInputStream(inputStream);
                FtpFileUtil.disconnectAndLogoutFromFTPServer(ftpClient, hostName);
                throw throwable;
            }
        }
        FtpFileUtil.closeInputStream(inputStream);
        FtpFileUtil.disconnectAndLogoutFromFTPServer(ftpClient, hostName);
        return result;
    }

    public static boolean deleteDirectoryFromFTPServer(String hostName, Integer port, String userName, String password, String remotePath) {
        boolean deleted = false;
        FTPClient ftpClient = new FTPClient();
        String errorMessage = "Could not delete the directory '%s' from FTP server '%s'. Cause: %s";
        try {
            FtpFileUtil.connectAndLoginOnFTPServer(ftpClient, hostName, port, userName, password);
            deleted = ftpClient.removeDirectory(remotePath);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format(errorMessage, remotePath, hostName), ex);
        }
        finally {
            FtpFileUtil.disconnectAndLogoutFromFTPServer(ftpClient, hostName);
        }
        return deleted;
    }

    public static String loadFileFromFTPServer(String hostName, Integer port, String userName, String password, String filePath, int numberOfLines) {
        String result = null;
        FTPClient ftpClient = new FTPClient();
        InputStream inputStream = null;
        String errorMessage = "Unable to connect and download file '%s' from FTP server '%s'.";
        try {
            FtpFileUtil.connectAndLoginOnFTPServer(ftpClient, hostName, port, userName, password);
            ftpClient.enterLocalPassiveMode();
            inputStream = ftpClient.retrieveFileStream(filePath);
            FtpFileUtil.validatResponse(ftpClient);
            result = FileUtil.streamToString(inputStream, filePath, numberOfLines);
            ftpClient.completePendingCommand();
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(String.format(errorMessage, filePath, hostName), ex);
            }
            catch (Throwable throwable) {
                FtpFileUtil.closeInputStream(inputStream);
                FtpFileUtil.disconnectAndLogoutFromFTPServer(ftpClient, hostName);
                throw throwable;
            }
        }
        FtpFileUtil.closeInputStream(inputStream);
        FtpFileUtil.disconnectAndLogoutFromFTPServer(ftpClient, hostName);
        return result;
    }

    public static void connectAndLoginOnFTPServer(FTPClient ftpClient, String hostName, Integer port, String userName, String password) {
        try {
            if (port != null && port > 0) {
                ftpClient.connect(hostName, port.intValue());
            } else {
                ftpClient.connect(hostName);
            }
            if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                throw new IOException(String.format("FTP server '%s' refused connection.", hostName));
            }
            if (!ftpClient.login(userName, password)) {
                throw new IOException(String.format("Unable to login to FTP server '%s'.", hostName));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Unable to connect and login to FTP server '%s'. Cause: ", hostName), ex);
        }
    }

    public static void disconnectAndLogoutFromFTPServer(FTPClient ftpClient, String hostName) {
        try {
            if (ftpClient != null && ftpClient.isConnected()) {
                ftpClient.logout();
                ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to logout and disconnect from : " + hostName, e);
        }
    }

    private static void validatResponse(FTPClient ftpClient) {
        if (FTPReply.isNegativeTransient((int)ftpClient.getReplyCode()) || FTPReply.isNegativePermanent((int)ftpClient.getReplyCode())) {
            throw new RuntimeException("Got error response: " + ftpClient.getReplyCode());
        }
    }

    private static void closeInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close file input stream.", e);
        }
    }
}

