/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.ConverterRegistry;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class HtmlCleaner {
    private static final Pattern LINKPATTERN = Pattern.compile("<a(\\s+.*?)?\\s+href=\"(.*?)\".*?>(.*?)</a>(.*)", 2);
    private static final Pattern IMAGEPATTERN = Pattern.compile("<img(\\s+.*?)?\\s+src=\"(.*?)\".*?/>", 2);
    private static final Pattern PRE_FORMATTED_PATTERN = Pattern.compile("<pre>\\s*(.*?)\\s*</pre>", 32);

    public String getUrl(String htmlLink) {
        String result = htmlLink;
        if (htmlLink != null) {
            Matcher linkMatcher = LINKPATTERN.matcher(htmlLink);
            Matcher imgMatcher = IMAGEPATTERN.matcher(htmlLink);
            if (linkMatcher.matches()) {
                String href = linkMatcher.group(2);
                href = StringEscapeUtils.unescapeHtml4((String)href);
                result = href + linkMatcher.group(4);
            } else if (imgMatcher.matches()) {
                String src = imgMatcher.group(2);
                result = StringEscapeUtils.unescapeHtml4((String)src);
            }
        }
        return result;
    }

    public <T> T cleanupValue(T rawValue) {
        Object cleanValue = rawValue instanceof String ? this.cleanupValue((String)rawValue) : rawValue;
        return cleanValue;
    }

    public String cleanupValue(String rawValue) {
        String result = null;
        if (rawValue != null) {
            Matcher matcher = LINKPATTERN.matcher(rawValue);
            result = matcher.matches() ? matcher.group(3) + matcher.group(4) : this.cleanupPreFormatted(rawValue);
        }
        return result;
    }

    public String cleanupPreFormatted(String value) {
        Matcher matcher;
        String result = value;
        if (value != null && (matcher = PRE_FORMATTED_PATTERN.matcher(value)).matches()) {
            String escapedBody = matcher.group(1);
            result = StringEscapeUtils.unescapeHtml4((String)escapedBody);
        }
        return result;
    }

    public Object parseValue(String value) {
        Object result = value;
        try {
            Converter<Map> converter = this.getConverter(value);
            if (converter != null) {
                result = converter.fromString(value);
            }
        }
        catch (Throwable t) {
            System.err.println("Unable to parse value: " + value);
            t.printStackTrace();
        }
        return result;
    }

    protected Converter<Map> getConverter(String cell) {
        Converter converter = null;
        if (cell.startsWith("<table class=\"hash_table\">") && cell.endsWith("</table>")) {
            converter = ConverterRegistry.getConverterForClass(Map.class);
        }
        return converter;
    }
}

