/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.net.ssl.SSLContext;
import nl.hsac.fitnesse.fixture.util.BinaryHttpResponse;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    public static final org.apache.http.client.HttpClient DEFAULT_HTTP_CLIENT = HttpClient.buildHttpClient(false, true);
    private org.apache.http.client.HttpClient httpClient = DEFAULT_HTTP_CLIENT;
    private boolean contentCompression = false;
    private boolean sslVerification = true;

    public void post(String url, HttpResponse response, Map<String, Object> headers, String type) {
        HttpPost methodPost = new HttpPost(url);
        ContentType contentType = ContentType.parse((String)type);
        StringEntity ent = new StringEntity(response.getRequest(), contentType);
        methodPost.setEntity((HttpEntity)ent);
        this.getResponse(url, response, (HttpRequestBase)methodPost, headers);
    }

    public void post(String url, HttpResponse response, Map<String, Object> headers, File file) {
        HttpPost methodPost = new HttpPost(url);
        HttpEntity multipart = this.buildBodyWithFile(file);
        methodPost.setEntity(multipart);
        this.getResponse(url, response, (HttpRequestBase)methodPost, headers);
    }

    public void put(String url, HttpResponse response, Map<String, Object> headers, String type) {
        HttpPut methodPut = new HttpPut(url);
        ContentType contentType = ContentType.parse((String)type);
        StringEntity ent = new StringEntity(response.getRequest(), contentType);
        methodPut.setEntity((HttpEntity)ent);
        this.getResponse(url, response, (HttpRequestBase)methodPut, headers);
    }

    public void put(String url, HttpResponse response, Map<String, Object> headers, File file) {
        HttpPut methodPut = new HttpPut(url);
        HttpEntity multipart = this.buildBodyWithFile(file);
        methodPut.setEntity(multipart);
        this.getResponse(url, response, (HttpRequestBase)methodPut, headers);
    }

    public void patch(String url, HttpResponse response, Map<String, Object> headers, String type) {
        HttpPatch methodPatch = new HttpPatch(url);
        ContentType contentType = ContentType.parse((String)type);
        StringEntity ent = new StringEntity(response.getRequest(), contentType);
        methodPatch.setEntity((HttpEntity)ent);
        this.getResponse(url, response, (HttpRequestBase)methodPatch, headers);
    }

    private HttpEntity buildBodyWithFile(File file) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addBinaryBody("file", file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
        HttpEntity multipart = builder.build();
        return multipart;
    }

    public void get(String url, HttpResponse response, Map<String, Object> headers, boolean followRedirect) {
        HttpGet method = new HttpGet(url);
        if (!followRedirect) {
            RequestConfig r = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setRedirectsEnabled(false).build();
            method.setConfig(r);
        }
        this.getResponse(url, response, (HttpRequestBase)method, headers);
    }

    public void head(String url, HttpResponse response, Map<String, Object> headers) {
        HttpHead method = new HttpHead(url);
        this.getResponse(url, response, (HttpRequestBase)method, headers);
    }

    public void delete(String url, HttpResponse response, Map<String, Object> headers) {
        HttpDelete method = new HttpDelete(url);
        this.getResponse(url, response, (HttpRequestBase)method, headers);
    }

    public void delete(String url, HttpResponse response, Map<String, Object> headers, String type) {
        HttpDeleteWithBody methodPost = new HttpDeleteWithBody(url);
        ContentType contentType = ContentType.parse((String)type);
        StringEntity ent = new StringEntity(response.getRequest(), contentType);
        methodPost.setEntity((HttpEntity)ent);
        this.getResponse(url, response, (HttpRequestBase)methodPost, headers);
    }

    public void enableCompression() {
        if (!this.contentCompression) {
            this.contentCompression = true;
            this.updateHttpClient();
        }
    }

    public void disableCompression() {
        if (this.contentCompression) {
            this.contentCompression = false;
            this.updateHttpClient();
        }
    }

    public void disableSSLVerification() {
        if (this.sslVerification) {
            this.sslVerification = false;
            this.updateHttpClient();
        }
    }

    public void enableSSLVerification() {
        if (!this.sslVerification) {
            this.sslVerification = true;
            this.updateHttpClient();
        }
    }

    protected void updateHttpClient() {
        this.httpClient = !this.contentCompression && this.sslVerification ? DEFAULT_HTTP_CLIENT : HttpClient.buildHttpClient(this.contentCompression, this.sslVerification);
    }

    protected static org.apache.http.client.HttpClient buildHttpClient(boolean contentCompression, boolean sslVerification) {
        RequestConfig rc = RequestConfig.custom().setCookieSpec("standard").build();
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties();
        if (!contentCompression) {
            builder.disableContentCompression();
        }
        if (!sslVerification) {
            try {
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClient.generateAllTrustingSSLConnectionSocketFactory());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create all-trusting SSLConnectionSocketFactory", e);
            }
        }
        return builder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE).setUserAgent(HttpClient.class.getName()).setDefaultRequestConfig(rc).build();
    }

    protected static SSLConnectionSocketFactory generateAllTrustingSSLConnectionSocketFactory() throws Exception {
        SSLContext allTrustingSSLContext = SSLContexts.custom().loadTrustMaterial(null, (a, b) -> true).build();
        return new SSLConnectionSocketFactory(allTrustingSSLContext, (a, b) -> true);
    }

    protected void getResponse(String url, HttpResponse response, HttpRequestBase method, Map<String, Object> headers) {
        long startTime = 0L;
        long endTime = -1L;
        org.apache.http.HttpResponse resp = null;
        try {
            if (headers != null) {
                this.addHeadersToMethod(headers, method);
            }
            HttpContext context = this.createContext(response);
            response.setMethod(method.getMethod());
            startTime = this.currentTimeMillis();
            resp = this.executeMethod(context, method);
            endTime = this.currentTimeMillis();
            this.storeResponse(response, resp);
            if (startTime > 0L && endTime < 0L) {
                endTime = this.currentTimeMillis();
            }
            response.setResponseTime(endTime - startTime);
            this.cleanupAfterRequest(resp, method);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to get response from: " + url, e);
            }
            catch (Throwable throwable) {
                if (startTime > 0L && endTime < 0L) {
                    endTime = this.currentTimeMillis();
                }
                response.setResponseTime(endTime - startTime);
                this.cleanupAfterRequest(resp, method);
                throw throwable;
            }
        }
    }

    protected void addHeadersToMethod(Map<String, Object> requestHeaders, HttpRequestBase method) {
        for (String key : requestHeaders.keySet()) {
            Object value = requestHeaders.get(key);
            if (value == null) continue;
            method.setHeader(key, value.toString());
        }
    }

    protected HttpContext createContext(HttpResponse response) {
        BasicHttpContext localContext = new BasicHttpContext();
        CookieStore store = response.getCookieStore();
        if (store != null) {
            localContext.setAttribute("http.cookie-store", (Object)store);
        }
        return localContext;
    }

    protected org.apache.http.HttpResponse executeMethod(HttpContext context, HttpRequestBase method) throws IOException {
        return this.httpClient.execute((HttpUriRequest)method, context);
    }

    protected void storeResponse(HttpResponse response, org.apache.http.HttpResponse resp) throws IOException {
        int returnCode = resp.getStatusLine().getStatusCode();
        response.setStatusCode(returnCode);
        this.addHeadersFromResponse(response.getResponseHeaders(), resp.getAllHeaders());
        this.copyResponseContent(response, resp);
    }

    protected void addHeadersFromResponse(Map<String, Object> responseHeaders, Header[] respHeaders) {
        for (Header h : respHeaders) {
            String headerName = h.getName();
            String headerValue = h.getValue();
            if (responseHeaders.containsKey(headerName)) {
                this.handleRepeatedHeaderValue(responseHeaders, headerName, headerValue);
                continue;
            }
            responseHeaders.put(headerName, headerValue);
        }
    }

    protected void handleRepeatedHeaderValue(Map<String, Object> responseHeaders, String headerName, String headerValue) {
        Object previousHeaderValue = responseHeaders.get(headerName);
        if (previousHeaderValue instanceof Collection) {
            ((Collection)previousHeaderValue).add(headerValue);
        } else {
            ArrayList<Object> valueList = new ArrayList<Object>();
            valueList.add(previousHeaderValue);
            valueList.add(headerValue);
            responseHeaders.put(headerName, valueList);
        }
    }

    protected void copyResponseContent(HttpResponse response, org.apache.http.HttpResponse resp) throws IOException {
        HttpEntity entity = resp.getEntity();
        if (entity == null) {
            response.setResponse(null);
        } else if (response instanceof BinaryHttpResponse) {
            BinaryHttpResponse binaryHttpResponse = (BinaryHttpResponse)response;
            byte[] content = EntityUtils.toByteArray((HttpEntity)entity);
            binaryHttpResponse.setResponseContent(content);
            String fileName = this.getAttachmentFileName(resp);
            binaryHttpResponse.setFileName(fileName);
        } else {
            String result = EntityUtils.toString((HttpEntity)entity);
            response.setResponse(result);
        }
    }

    protected String getAttachmentFileName(org.apache.http.HttpResponse resp) {
        HeaderElement[] headerElements;
        String fileName = null;
        Header[] contentDisp = resp.getHeaders("content-disposition");
        if (contentDisp != null && contentDisp.length > 0 && (headerElements = contentDisp[0].getElements()) != null) {
            for (HeaderElement headerElement : headerElements) {
                NameValuePair param;
                if (!"attachment".equals(headerElement.getName()) || (param = headerElement.getParameterByName("filename")) == null) continue;
                fileName = param.getValue();
                break;
            }
        }
        return fileName;
    }

    protected void cleanupAfterRequest(org.apache.http.HttpResponse response, HttpRequestBase method) {
        method.reset();
        if (response instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)response).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close connection", e);
            }
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public org.apache.http.client.HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(org.apache.http.client.HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public String getMethod() {
            return "DELETE";
        }

        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }
    }
}

