/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.hsac.fitnesse.fixture.util.NonValidResponseReceivedException;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

public class HttpResponse {
    private static final Map<String, HttpResponse> INSTANCES = new ConcurrentHashMap<String, HttpResponse>();
    private Map<String, Object> responseHeaders = new LinkedHashMap<String, Object>();
    private String method;
    private String request;
    protected String response;
    private int statusCode;
    private CookieStore cookieStore;
    private long responseTime = -1L;

    public void validResponse() {
        if (this.statusCode == 0) {
            throw new NonValidResponseReceivedException("Status code is 0. Probably no response was received.");
        }
        if (this.statusCode < 100) {
            throw new NonValidResponseReceivedException("Status code is less than 100: " + this.statusCode);
        }
        if (this.statusCode >= 400 && this.statusCode <= 499) {
            throw new NonValidResponseReceivedException("Server reported client error: " + this.statusCode);
        }
        if (this.statusCode >= 500 && this.statusCode <= 599) {
            throw new NonValidResponseReceivedException("Server error returned: " + this.statusCode);
        }
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String aRequest) {
        this.request = aRequest;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String aResponse) {
        this.response = aResponse;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int aStatusCode) {
        this.statusCode = aStatusCode;
    }

    public Map<String, Object> getResponseHeaders() {
        return this.responseHeaders;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public Cookie getCookieNamed(String cookieName) {
        Cookie result = null;
        if (this.cookieStore != null) {
            for (Cookie cookie : this.getCookieStore().getCookies()) {
                if (!cookieName.equals(cookie.getName())) continue;
                result = cookie;
                break;
            }
        }
        return result;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void cloneValues(HttpResponse resp) {
        this.setCookieStore(resp.getCookieStore());
        this.setRequest(resp.getRequest());
        this.setMethod(resp.getMethod());
        this.getResponseHeaders().putAll(resp.getResponseHeaders());
        this.setStatusCode(resp.getStatusCode());
        this.setResponse(resp.getResponse());
        this.setResponseTime(resp.getResponseTime());
    }

    public String toString() {
        String result = super.toString();
        INSTANCES.put(result, this);
        return result;
    }

    public static HttpResponse parse(String value) {
        return INSTANCES.get(value);
    }

    public static void clearInstances() {
        INSTANCES.clear();
    }
}

