/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer<T extends HttpResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServer.class);
    private static final Charset UTF8 = ContentType.parse((String)"text/xml; charset=UTF-8").getCharset();
    public static final int MAX_PORT = 65535;
    private final T response;
    private final com.sun.net.httpserver.HttpServer server;
    private final InetSocketAddress address;
    private final String path;
    private final AtomicInteger requestsReceived = new AtomicInteger(0);
    private final Object lock = new Object();

    public HttpServer(InetSocketAddress anAddress, String aPath, T aResponse) {
        this(anAddress.getAddress(), anAddress.getPort(), aPath, aResponse);
    }

    public HttpServer(InetAddress anAddress, int port, String aPath, T aResponse) {
        this(anAddress, port, port, aPath, aResponse);
    }

    public HttpServer(InetAddress anAddress, int startPort, int maxPort, String aPath, T aResponse) {
        if (startPort > 65535) {
            throw new IllegalArgumentException("port must be below: 65535");
        }
        this.response = aResponse;
        this.path = aPath;
        this.server = HttpServer.bind(anAddress, startPort, maxPort);
        InetSocketAddress serverAddress = this.server.getAddress();
        int port = serverAddress.getPort();
        this.address = new InetSocketAddress(anAddress, port);
        this.server.createContext(aPath, this.getHandler(aResponse));
        this.server.start();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getURL() {
        InetSocketAddress address = this.getAddress();
        InetAddress hostAddress = address.getAddress();
        return "http://" + hostAddress.getHostAddress() + ":" + address.getPort() + this.path;
    }

    public T getResponse() {
        return this.response;
    }

    public int getRequestsReceived() {
        return this.requestsReceived.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T waitForRequest(long maxWait) {
        long start = System.currentTimeMillis();
        try {
            while (this.requestsReceived.get() < 1 && System.currentTimeMillis() - start < maxWait) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                    return this.getResponse();
                }
            }
        }
        finally {
            this.stopServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        Object object = this.lock;
        synchronized (object) {
            this.server.stop(0);
        }
    }

    public static com.sun.net.httpserver.HttpServer bind(InetAddress address, int startPort, int maxPort) {
        com.sun.net.httpserver.HttpServer aServer = HttpServer.createServer();
        int port = -1;
        for (int possiblePort = startPort; port == -1 && possiblePort <= maxPort; ++possiblePort) {
            try {
                InetSocketAddress s = new InetSocketAddress(address, possiblePort);
                aServer.bind(s, 1);
                port = possiblePort;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (aServer.getAddress() == null) {
            throw new RuntimeException(new BindException("Unable to bind to: " + address.getHostAddress()));
        }
        return aServer;
    }

    private static com.sun.net.httpserver.HttpServer createServer() {
        try {
            return com.sun.net.httpserver.HttpServer.create();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected HttpHandler getHandler(T aResponse) {
        return he -> {
            Object object = this.lock;
            synchronized (object) {
                String method = he.getRequestMethod();
                String uri = he.getRequestURI().toString();
                LOGGER.debug("Handling {} request for {}", (Object)method, (Object)uri);
                OutputStream os = null;
                try {
                    byte[] responseBytes;
                    InputStream is = he.getRequestBody();
                    String body = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
                    String request = "POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method) && !"".equals(body) || "PATCH".equals(method) ? body : String.format("%s: %s", method, uri);
                    aResponse.setRequest(request);
                    aResponse.setMethod(method);
                    Headers heHeaders = he.getResponseHeaders();
                    Map<String, Object> responseHeaders = aResponse.getResponseHeaders();
                    for (Map.Entry<String, Object> headerEntry : responseHeaders.entrySet()) {
                        String headerName = headerEntry.getKey();
                        Object headerEntryValue = headerEntry.getValue();
                        heHeaders.add(headerName, headerEntryValue.toString());
                    }
                    if (aResponse.getResponse() == null) {
                        responseBytes = new byte[]{};
                    } else {
                        Charset charset = this.getCharSet(heHeaders);
                        responseBytes = aResponse.getResponse().getBytes(charset);
                    }
                    he.sendResponseHeaders(aResponse.getStatusCode(), responseBytes.length);
                    os = he.getResponseBody();
                    os.write(responseBytes);
                    os.flush();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Error handling {} request for {}", new Object[]{method, uri, e});
                }
                finally {
                    this.incrementRequestsReceived();
                    if (os != null) {
                        os.close();
                    }
                }
            }
        };
    }

    protected Charset getCharSet(Headers heHeaders) {
        Charset charset = UTF8;
        String contentTypeHeader = heHeaders.getFirst("Content-Type");
        if (contentTypeHeader != null) {
            try {
                ContentType contentType = ContentType.parse((String)contentTypeHeader);
                Charset contentTypeCharset = contentType.getCharset();
                if (contentTypeCharset != null) {
                    charset = contentTypeCharset;
                }
            }
            catch (UnsupportedCharsetException | ParseException throwable) {
                // empty catch block
            }
        }
        return charset;
    }

    protected int incrementRequestsReceived() {
        return this.requestsReceived.incrementAndGet();
    }
}

