/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.util.Formatter;
import nl.hsac.fitnesse.fixture.util.JsonPathHelper;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;

public class JsonHelper
implements Formatter {
    @Override
    public String format(String json) {
        String result = null;
        if (json != null) {
            if (json.startsWith("{")) {
                result = new org.json.JSONObject(json).toString(4);
            } else if (json.startsWith("[")) {
                org.json.JSONObject jsonObject = new org.json.JSONObject("{'a': " + json + "}");
                org.json.JSONArray array = (org.json.JSONArray)jsonObject.get("a");
                result = array.toString(4);
            }
        }
        return result;
    }

    public Map<String, Object> jsonStringToMap(String jsonString) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            org.json.JSONObject jsonObject = new org.json.JSONObject(jsonString);
            return this.jsonObjectToMap(jsonObject);
        }
        catch (JSONException e) {
            throw new RuntimeException("Unable to convert string to map: " + jsonString, e);
        }
    }

    private Map<String, Object> jsonObjectToMap(org.json.JSONObject jsonObject) throws JSONException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Object key : jsonObject.keySet()) {
            String stringKey = String.valueOf(key);
            Object value = this.convertJsonObject(jsonObject.get(stringKey));
            result.put(stringKey, value);
        }
        return result;
    }

    private Object convertJsonObject(Object value) {
        Object result = value;
        if (value instanceof org.json.JSONObject) {
            result = this.jsonObjectToMap((org.json.JSONObject)value);
        } else if (value instanceof org.json.JSONArray) {
            ArrayList<Object> newVal = new ArrayList<Object>();
            for (Object o : (org.json.JSONArray)value) {
                newVal.add(this.convertJsonObject(o));
            }
            result = newVal;
        }
        return result;
    }

    public String sort(String json, String arrayExpr, String nestedPathExpr) {
        JsonPathHelper pathHelper = this.getPathHelper();
        Object topLevel = pathHelper.getJsonPath(json, arrayExpr);
        if (topLevel instanceof JSONArray) {
            JSONArray a = (JSONArray)topLevel;
            JSONArray aSorted = this.sort(pathHelper, a, nestedPathExpr);
            return pathHelper.updateJsonPathWithValue(json, arrayExpr, aSorted);
        }
        throw new IllegalArgumentException("Unable to find array using: " + arrayExpr);
    }

    private JSONArray sort(final JsonPathHelper pathHelper, JSONArray a, final String nestedPathExpr) {
        ArrayList<String> elements = new ArrayList<String>(a.size());
        for (Object element : a) {
            JSONObject jsonObject = new JSONObject((Map)element);
            elements.add(jsonObject.toJSONString());
        }
        Collections.sort(elements, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Comparable val1 = (Comparable)pathHelper.getJsonPath(o1, nestedPathExpr);
                Comparable val2 = (Comparable)pathHelper.getJsonPath(o2, nestedPathExpr);
                return val1.compareTo(val2);
            }
        });
        return this.convertToArray(elements);
    }

    private JSONArray convertToArray(List<String> elements) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(elements.size());
        for (String str : elements) {
            Map<String, Object> map = this.jsonStringToMap(str);
            result.add(map);
        }
        JSONArray array = new JSONArray();
        array.addAll(result);
        return array;
    }

    public JsonPathHelper getPathHelper() {
        return Environment.getInstance().getJsonPathHelper();
    }
}

