/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.HtmlCleaner;

public class MapHelper {
    private static final Pattern LIST_INDEX_PATTERN = Pattern.compile("(\\S+)\\[(\\d+)\\]");
    private HtmlCleaner htmlCleaner = new HtmlCleaner();

    public Object getValue(Map<String, Object> map, String name) {
        String cleanName = this.htmlCleaner.cleanupValue(name);
        return this.getValueImpl(map, cleanName, true);
    }

    protected Object getValueImpl(Map<String, Object> map, String name, boolean throwIfNoList) {
        Object value = null;
        if (map.containsKey(name)) {
            value = map.get(name);
        } else {
            String[] parts = name.split("\\.", 2);
            if (parts.length > 1) {
                Object nested = this.getValueImpl(map, parts[0], throwIfNoList);
                if (nested instanceof Map) {
                    Map nestedMap = (Map)nested;
                    value = this.getValueImpl(nestedMap, parts[1], throwIfNoList);
                }
            } else if (this.isListName(name)) {
                value = this.getListValue(map, name);
            } else if (this.isListIndexExpr(name)) {
                value = this.getIndexedListValue(map, name, throwIfNoList);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValueForIn(Object value, String name, Map<String, Object> map) {
        if (this.isListName(name)) {
            String valueStr = null;
            if (value != null) {
                valueStr = value.toString();
            }
            this.setValuesForIn(valueStr, this.stripListIndicator(name), map);
            return;
        } else {
            if (name.endsWith("\\[]")) {
                name = name.replace("\\[]", "[]");
            }
            String cleanName = this.htmlCleaner.cleanupValue(name);
            Object cleanValue = this.getCleanValue(value);
            if (map.containsKey(cleanName)) {
                map.put(cleanName, cleanValue);
                return;
            } else {
                int firstDot = cleanName.indexOf(".");
                if (firstDot > -1) {
                    String key = cleanName.substring(0, firstDot);
                    LinkedHashMap nested = this.getValueImpl(map, key, false);
                    if (nested == null) {
                        nested = new LinkedHashMap();
                        if (this.isListIndexExpr(key)) {
                            this.setIndexedListValue(map, key, nested);
                        } else {
                            map.put(key, nested);
                        }
                    }
                    if (!(nested instanceof Map)) throw new SlimFixtureException(false, key + " is not a map, but " + nested.getClass());
                    Map nestedMap = nested;
                    String lastPart = cleanName.substring(firstDot + 1);
                    this.setValueForIn(cleanValue, lastPart, nestedMap);
                    return;
                } else if (this.isListIndexExpr(name)) {
                    this.setIndexedListValue(map, cleanName, cleanValue);
                    return;
                } else {
                    map.put(cleanName, cleanValue);
                }
            }
        }
    }

    public void addValueToIn(Object value, String name, Map<String, Object> map) {
        Object val = this.getValue(map, name);
        if (val instanceof Collection) {
            Object cleanValue = this.getCleanValue(value);
            ((Collection)val).add(cleanValue);
        } else if (val == null) {
            this.setValueForIn(value, name + "[0]", map);
        } else {
            throw new SlimFixtureException(false, "name is not a list but: " + val.getClass().getSimpleName());
        }
    }

    public void copyValuesFromTo(Map<String, Object> otherMap, Map<String, Object> map) {
        map.putAll(otherMap);
    }

    public void setValuesForIn(String values, String name, Map<String, Object> map) {
        String cleanName = this.htmlCleaner.cleanupValue(name);
        String[] valueArrays = values.split("\\s*,\\s*");
        ArrayList<Object> valueObjects = new ArrayList<Object>(valueArrays.length);
        for (int i = 0; i < valueArrays.length; ++i) {
            Object cleanValue = this.getCleanValue(valueArrays[i]);
            valueObjects.add(cleanValue);
        }
        this.setValueForIn(valueObjects, cleanName, map);
    }

    public boolean contentOfEquals(Map<String, Object> one, Object two) {
        if (one == null) {
            return two == null;
        }
        return one.equals(two);
    }

    public int sizeOfIn(String expr, Map<String, Object> map) {
        int result;
        Object val = this.getValue(map, expr);
        if (val instanceof Map) {
            result = ((Map)val).size();
        } else if (val instanceof Collection) {
            result = ((Collection)val).size();
        } else {
            throw new SlimFixtureException(false, expr + " is not a collection");
        }
        return result;
    }

    public Object getCleanValue(Object value) {
        Object cleanValue = value;
        if (value instanceof String && (cleanValue = this.htmlCleaner.parseValue((String)value)) instanceof String) {
            cleanValue = this.htmlCleaner.cleanupValue((String)cleanValue);
        }
        return cleanValue;
    }

    protected Object getListValue(Map<String, Object> map, String name) {
        return this.getValue(map, this.stripListIndicator(name));
    }

    protected Object getIndexedListValue(Map<String, Object> map, String name, boolean throwIfNoList) {
        ScriptObjectMirror mirror;
        Object value = null;
        String prop = this.getListKeyName(name);
        Object val = this.getValue(map, prop);
        if (!(val instanceof List) && val instanceof ScriptObjectMirror && (mirror = (ScriptObjectMirror)val).isArray()) {
            val = mirror.to(List.class);
        }
        if (val instanceof List) {
            List list = (List)val;
            int index = this.getListIndex(name);
            value = index < list.size() ? list.get(index) : null;
        } else if (val != null || throwIfNoList) {
            throw new SlimFixtureException(false, prop + " is not a list, but " + val);
        }
        return value;
    }

    protected void setIndexedListValue(Map<String, Object> map, String name, Object value) {
        int index;
        List list;
        String prop = this.getListKeyName(name);
        ArrayList val = this.getValue(map, prop);
        if (val == null) {
            val = new ArrayList();
            this.setValueForIn(val, prop, map);
        }
        if (val instanceof List) {
            list = val;
            index = this.getListIndex(name);
            while (list.size() <= index) {
                list.add(null);
            }
        } else {
            throw new SlimFixtureException(false, prop + " is not a list, but " + val);
        }
        list.set(index, value);
    }

    protected boolean isListName(String name) {
        return name.endsWith("[]") && !name.endsWith("\\[]");
    }

    protected String stripListIndicator(String key) {
        return key.substring(0, key.length() - 2);
    }

    protected boolean isListIndexExpr(String key) {
        return this.getListIndexMatcher(key).matches();
    }

    protected String getListKeyName(String key) {
        Matcher matcher = this.getListIndexMatcher(key);
        matcher.matches();
        return matcher.group(1);
    }

    protected int getListIndex(String key) {
        Matcher matcher = this.getListIndexMatcher(key);
        matcher.matches();
        return Integer.parseInt(matcher.group(2));
    }

    protected Matcher getListIndexMatcher(String key) {
        return LIST_INDEX_PATTERN.matcher(key);
    }

    public void setHtmlCleaner(HtmlCleaner htmlCleaner) {
        this.htmlCleaner = htmlCleaner;
    }
}

