/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import nl.hsac.fitnesse.fixture.util.XmlHttpResponse;
import org.apache.commons.lang3.StringUtils;

public class MockXmlHttpResponseSequence
extends HttpResponse {
    private final List<XmlHttpResponse> responseList = new ArrayList<XmlHttpResponse>();
    private final Map<String, XmlHttpResponse> responsesForRequests = new HashMap<String, XmlHttpResponse>();
    private int currentIndex;

    public <T extends XmlHttpResponse> MockXmlHttpResponseSequence(T ... responses) {
        this((Collection<T>)(responses == null ? null : Arrays.asList(responses)));
    }

    public <T extends XmlHttpResponse> MockXmlHttpResponseSequence(Collection<T> responses) {
        this();
        if (responses != null) {
            this.responseList.addAll(responses);
        }
    }

    public MockXmlHttpResponseSequence() {
        this.resetCurrentIndex();
    }

    public XmlHttpResponse addResponse(String responseBody, String request) {
        XmlHttpResponse newResponse = new XmlHttpResponse();
        newResponse.setStatusCode(200);
        newResponse.setResponse(responseBody);
        if (request == null) {
            this.responseList.add(newResponse);
        } else {
            this.responsesForRequests.put(request, newResponse);
        }
        return newResponse;
    }

    public List<? extends XmlHttpResponse> getResponseList() {
        return this.responseList;
    }

    public String getExtraRequestsMessage() {
        List<String> extraRequests = this.getNotExpected();
        return this.createUnexpectedMessage("%s extra request(s) received: %s", extraRequests);
    }

    public String getMissingRequestsMessage() {
        List<String> extraResponses = this.getNotCalled();
        return this.createUnexpectedMessage("%s response(s) not requested: %s", extraResponses);
    }

    protected String createUnexpectedMessage(String messagePattern, List<String> extraMessages) {
        String msg = null;
        if (!extraMessages.isEmpty()) {
            StringBuilder messageList = new StringBuilder("<ol>");
            for (String message : extraMessages) {
                messageList.append("<li>");
                String formattedMsg = this.formatValue(message);
                messageList.append(formattedMsg);
                messageList.append("</li>");
            }
            messageList.append("</ol>");
            msg = String.format("<div>" + messagePattern + "</div>", extraMessages.size(), messageList);
        }
        return msg;
    }

    protected String formatValue(String value) {
        String result;
        try {
            result = Environment.getInstance().getHtmlForXml(value);
        }
        catch (Exception e) {
            result = value;
        }
        return result;
    }

    public List<String> getNotCalled() {
        ArrayList<String> result = new ArrayList<String>(1);
        for (XmlHttpResponse xmlHttpResponse : this.getResponseList()) {
            if (!StringUtils.isEmpty((CharSequence)xmlHttpResponse.getRequest())) continue;
            result.add(xmlHttpResponse.getResponse());
        }
        for (XmlHttpResponse xmlHttpResponse : this.responsesForRequests.values()) {
            if (this.getResponseList().contains(xmlHttpResponse)) continue;
            result.add(xmlHttpResponse.getResponse());
        }
        return result;
    }

    public List<String> getNotExpected() {
        ArrayList<String> result = new ArrayList<String>(1);
        for (XmlHttpResponse xmlHttpResponse : this.getResponseList()) {
            if (!StringUtils.isEmpty((CharSequence)xmlHttpResponse.getResponse())) continue;
            result.add(xmlHttpResponse.getRequest());
        }
        return result;
    }

    public void resetCurrentIndex() {
        this.currentIndex = -1;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public String getResponse() {
        return this.currentResponse().getResponse();
    }

    @Override
    public int getStatusCode() {
        return this.currentResponse().getStatusCode();
    }

    @Override
    public void setRequest(String aRequest) {
        ++this.currentIndex;
        if (this.responsesForRequests.containsKey(aRequest)) {
            this.responseList.add(this.currentIndex, this.responsesForRequests.get(aRequest));
        }
        this.currentResponse().setRequest(aRequest);
    }

    @Override
    public Map<String, Object> getResponseHeaders() {
        return this.currentResponse().getResponseHeaders();
    }

    @Override
    public String getMethod() {
        return this.currentResponse().getMethod();
    }

    @Override
    public void setMethod(String method) {
        this.currentResponse().setMethod(method);
    }

    protected XmlHttpResponse currentResponse() {
        if (this.currentIndex < 0) {
            throw new IllegalStateException("No 'current' response available. No requests received yet.");
        }
        if (this.currentIndex == this.responseList.size()) {
            XmlHttpResponse blankResponse = this.addResponse("", null);
            blankResponse.setStatusCode(404);
        }
        return this.getResponseList().get(this.currentIndex);
    }
}

