/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import fit.exception.FitFailureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceContextImpl
implements NamespaceContext {
    private final Map<String, String> namespaces = new HashMap<String, String>();

    public void add(String prefix, String uri) {
        if (uri == null) {
            this.namespaces.remove(prefix);
        } else if (this.namespaces.containsKey(prefix)) {
            String currentUri = this.namespaces.get(prefix);
            if (!currentUri.equals(uri)) {
                throw new FitFailureException(String.format("The prefix %s is already mapped to %s", prefix, currentUri));
            }
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public String getNamespaceURI(String aPrefix) {
        return this.namespaces.get(aPrefix);
    }

    @Override
    public String getPrefix(String anUri) {
        String result = null;
        for (String key : this.namespaces.keySet()) {
            String uri = this.namespaces.get(key);
            if (!uri.equals(anUri)) continue;
            result = key;
            break;
        }
        return result;
    }

    @Override
    public Iterator<String> getPrefixes(String anUri) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.namespaces.keySet()) {
            String uri = this.namespaces.get(key);
            if (!uri.equals(anUri)) continue;
            result.add(key);
        }
        return result.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamespaceContextImpl that = (NamespaceContextImpl)o;
        return this.namespaces.equals(that.namespaces);
    }

    public int hashCode() {
        return this.namespaces.hashCode();
    }
}

