/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import nl.hsac.fitnesse.fixture.util.ProgramResponse;
import nl.hsac.fitnesse.fixture.util.TimeoutHelper;

public class ProgramHelper {
    private TimeoutHelper timeoutHelper;

    public void setTimeoutHelper(TimeoutHelper timeoutHelper) {
        this.timeoutHelper = timeoutHelper;
    }

    public void execute(ProgramResponse response, int timeout) {
        ProcessBuilder builder = this.createProcessBuilder(response);
        this.invokeProgram(builder, response, timeout);
    }

    private ProcessBuilder createProcessBuilder(ProgramResponse response) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(response.getCommand());
        command.addAll(Arrays.asList(response.getArguments()));
        ProcessBuilder builder = new ProcessBuilder(new String[0]).directory(response.getDirectory()).command(command);
        Map<String, String> respEnv = response.getEnvironment();
        if (respEnv != null && !respEnv.isEmpty()) {
            builder.environment().putAll(respEnv);
        }
        response.setEnvironment(builder.environment());
        return builder;
    }

    private void invokeProgram(ProcessBuilder builder, ProgramResponse response, int timeout) {
        StreamConsumer stdErrConsumer;
        StreamConsumer stdOutConsumer;
        Process process;
        try {
            process = builder.start();
            stdOutConsumer = new StreamConsumer(process.getInputStream()).start();
            stdErrConsumer = new StreamConsumer(process.getErrorStream()).start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start: " + response.getCommand(), e);
        }
        try {
            Integer exitCode = this.timeoutHelper.callWithTimeout(response.getCommand(), timeout, new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return process.waitFor();
                }
            });
            response.setExitCode(exitCode);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TimeoutException) {
                process.destroy();
            }
            throw e;
        }
        finally {
            String stdOut = stdOutConsumer.getCurrentOutput();
            response.setStdOut(stdOut);
            String stdErr = stdErrConsumer.getCurrentOutput();
            response.setStdErr(stdErr);
        }
    }

    private static class StreamConsumer
    implements Runnable {
        private final InputStream stream;
        private final Thread thread;
        private final StringBuffer buffer = new StringBuffer();

        StreamConsumer(InputStream stream) {
            this.stream = stream;
            this.thread = new Thread(this);
        }

        StreamConsumer start() {
            this.thread.start();
            return this;
        }

        String getOutput() throws InterruptedException {
            this.thread.join();
            return this.getCurrentOutput();
        }

        String getCurrentOutput() {
            return this.buffer.toString();
        }

        @Override
        public void run() {
            BufferedReader brCleanUp = new BufferedReader(new InputStreamReader(this.stream));
            try {
                String line;
                while ((line = brCleanUp.readLine()) != null) {
                    this.buffer.append(line);
                    this.buffer.append(System.lineSeparator());
                }
                brCleanUp.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to consume output", e);
            }
        }
    }
}

