/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import nl.hsac.fitnesse.fixture.util.StreamUtil;

public class PropertiesHelper {
    public Properties parsePropertiesString(String propertiesAsString) {
        Properties p = new Properties();
        try (StringReader reader = new StringReader(propertiesAsString);){
            p.load(reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse .properties: " + propertiesAsString, e);
        }
        return p;
    }

    public Map<String, Object> convertPropertiesToMap(Properties properties) {
        return properties.entrySet().stream().collect(StreamUtil.toLinkedMap(e -> e.getKey().toString(), e -> e.getValue()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writePropertiesToString(Properties properties) {
        try (StringWriter sw = new StringWriter();){
            properties.store(sw, null);
            String content = sw.toString();
            int firstNewline = content.indexOf(10);
            String string = content.substring(firstNewline + 1);
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to write: " + properties, e);
        }
    }
}

